/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.concurrent.atomic.AtomicInteger;
import org.jgroups.Address;
import org.jgroups.protocols.raft.InMemoryLog;
import org.jgroups.protocols.raft.LevelDBLog;
import org.jgroups.protocols.raft.Log;
import org.jgroups.protocols.raft.LogEntry;
import org.jgroups.util.Util;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"functional"}, singleThreaded=true, dataProvider="logProvider")
public class LogTest {
    protected Log log;
    protected static final String filename = "LogTest.log";

    @DataProvider
    static Object[][] logProvider() {
        return new Object[][]{{new LevelDBLog()}, {new InMemoryLog()}};
    }

    @AfterMethod
    protected void destroy() {
        if (this.log != null) {
            this.log.delete();
            this.log = null;
        }
    }

    public void testFields(Log log) throws Exception {
        Address addr = Util.createRandomAddress((String)"A");
        this.log = log;
        log.init(filename, null);
        log.currentTerm(22);
        int current_term = log.currentTerm();
        Assert.assertEquals((int)current_term, (int)22);
        log.votedFor(addr);
        Address voted_for = log.votedFor();
        Assert.assertEquals((Object)addr, (Object)voted_for);
        log.close();
        log.init(filename, null);
        current_term = log.currentTerm();
        Assert.assertEquals((int)current_term, (int)22);
        voted_for = log.votedFor();
        Assert.assertEquals((Object)addr, (Object)voted_for);
        log.close();
        log.delete();
        log.init(filename, null);
        current_term = log.currentTerm();
        Assert.assertEquals((int)current_term, (int)0);
        voted_for = log.votedFor();
        Assert.assertNull((Object)voted_for);
    }

    public void testNewLog(Log log) throws Exception {
        this.log = log;
        log.init(filename, null);
        this.assertIndices(0, 0, 0, 0);
        Assert.assertNull((Object)log.votedFor());
    }

    public void testNewLogAfterDelete(Log log) throws Exception {
        this.log = log;
        log.init(filename, null);
        this.append(log, 1, false, new byte[10], 5, 5, 5);
        log.commitIndex(2);
        this.assertIndices(0, 3, 2, 5);
        log.close();
        log.delete();
        log.init(filename, null);
        this.assertIndices(0, 0, 0, 0);
        Assert.assertNull((Object)log.votedFor());
    }

    public void testMetadataInAReopenedLog(Log log) throws Exception {
        this.log = log;
        log.init(filename, null);
        byte[] buf = new byte[10];
        this.append(log, 1, false, buf, 1, 1, 1, 4, 4, 5, 5, 6, 6, 6);
        log.commitIndex(10);
        log.votedFor(Util.createRandomAddress((String)"A"));
        log.close();
        log.init(filename, null);
        this.assertIndices(0, 10, 10, 6);
        Assert.assertEquals((String)log.votedFor().toString(), (String)Util.createRandomAddress((String)"A").toString());
    }

    public void testAppendOnLeader(Log log) throws Exception {
        this.log = log;
        log.init(filename, null);
        byte[] buf = new byte[10];
        log.append(1, false, new LogEntry(5, buf));
        log.append(2, false, new LogEntry(5, buf));
        this.assertIndices(0, 2, 0, 5);
    }

    public void testAppendMultipleEntries(Log log) throws Exception {
        this.log = log;
        log.init(filename, null);
        byte[] buf = new byte[10];
        LogEntry[] entries = new LogEntry[]{new LogEntry(1, buf), new LogEntry(1, buf), new LogEntry(3, buf)};
        log.append(1, false, entries);
        this.assertIndices(0, 3, 0, 3);
        entries = new LogEntry[30];
        for (int i = 0; i < entries.length; ++i) {
            entries[i] = new LogEntry(Math.max(3, i / 2), buf);
        }
        log.append(4, false, entries);
        this.assertIndices(0, 33, 0, 14);
    }

    public void testDeleteEntriesInTheMiddle(Log log) throws Exception {
        int i;
        this.log = log;
        log.init(filename, null);
        byte[] buf = new byte[10];
        this.append(log, 1, false, buf, 1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 3);
        log.commitIndex(11);
        log.deleteAllEntriesStartingFrom(6);
        this.assertIndices(0, 5, 5, 2);
        for (i = 1; i <= 5; ++i) {
            Assert.assertNotNull((Object)log.get(i));
        }
        for (i = 6; i <= 11; ++i) {
            Assert.assertNull((Object)log.get(i));
        }
    }

    public void testDeleteEntriesFromFirst(Log log) throws Exception {
        this.log = log;
        log.init(filename, null);
        byte[] buf = new byte[10];
        this.append(log, 1, false, buf, 1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 3);
        log.commitIndex(11);
        log.deleteAllEntriesStartingFrom(1);
        this.assertIndices(0, 0, 0, 0);
        for (int i = 1; i <= 11; ++i) {
            Assert.assertNull((Object)log.get(i));
        }
    }

    public void testDeleteEntriesFromLast(Log log) throws Exception {
        this.log = log;
        log.init(filename, null);
        byte[] buf = new byte[10];
        this.append(log, 1, false, buf, 1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 3);
        log.commitIndex(11);
        log.deleteAllEntriesStartingFrom(11);
        this.assertIndices(0, 10, 10, 3);
        for (int i = 1; i <= 10; ++i) {
            Assert.assertNotNull((Object)log.get(i));
        }
        Assert.assertNull((Object)log.get(11));
    }

    public void testTruncateInTheMiddle(Log log) throws Exception {
        int i;
        this.log = log;
        log.init(filename, null);
        byte[] buf = new byte[10];
        this.append(log, 1, false, buf, 1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 3);
        log.commitIndex(11);
        log.truncate(6);
        this.assertIndices(6, 11, 11, 3);
        for (i = 1; i <= 5; ++i) {
            Assert.assertNull((Object)log.get(i));
        }
        for (i = 6; i <= 11; ++i) {
            Assert.assertNotNull((Object)log.get(i));
        }
    }

    public void testTruncateFirst(Log log) throws Exception {
        this.log = log;
        log.init(filename, null);
        byte[] buf = new byte[10];
        this.append(log, 1, false, buf, 1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 3);
        log.commitIndex(11);
        log.truncate(1);
        this.assertIndices(1, 11, 11, 3);
        Assert.assertNotNull((Object)log.get(1));
    }

    public void testTruncateLast(Log log) throws Exception {
        this.log = log;
        log.init(filename, null);
        byte[] buf = new byte[10];
        this.append(log, 1, false, buf, 1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 3);
        log.commitIndex(11);
        log.truncate(11);
        this.assertIndices(11, 11, 11, 3);
        for (int i = 1; i <= 10; ++i) {
            Assert.assertNull((Object)log.get(i));
        }
        Assert.assertNotNull((Object)log.get(11));
    }

    public void testTruncateAndReopen(Log log) throws Exception {
        int i;
        this.log = log;
        log.init(filename, null);
        byte[] buf = new byte[10];
        this.append(log, 1, false, buf, 1, 1, 1, 2, 2);
        log.commitIndex(5);
        log.truncate(4);
        log.close();
        log.init(filename, null);
        Assert.assertEquals((int)log.firstApplied(), (int)4);
        Assert.assertEquals((int)log.lastApplied(), (int)5);
        for (i = 1; i <= 3; ++i) {
            Assert.assertNull((Object)log.get(i));
        }
        for (i = 4; i <= 5; ++i) {
            Assert.assertNotNull((Object)log.get(i));
        }
    }

    public void testTruncateTwice(Log log) throws Exception {
        this.log = log;
        log.init(filename, null);
        byte[] buf = new byte[10];
        for (int i = 1; i <= 10; ++i) {
            log.append(i, false, new LogEntry(5, buf));
        }
        log.commitIndex(6);
        log.truncate(4);
        Assert.assertEquals((int)log.commitIndex(), (int)6);
        Assert.assertEquals((int)log.firstApplied(), (int)4);
        log.commitIndex(10);
        log.truncate(8);
        Assert.assertEquals((int)log.commitIndex(), (int)10);
        Assert.assertEquals((int)log.firstApplied(), (int)8);
    }

    public void testForEach(Log log) throws Exception {
        this.log = log;
        log.init(filename, null);
        byte[] buf = new byte[10];
        for (int i = 1; i <= 10; ++i) {
            log.append(i, false, new LogEntry(5, buf));
        }
        log.commitIndex(8);
        AtomicInteger cnt = new AtomicInteger(0);
        log.forEach((entry, index) -> cnt.incrementAndGet());
        assert (cnt.get() == 10);
        cnt.set(0);
        log.truncate(8);
        this.append(log, 11, false, buf, 6, 6, 6, 7, 7, 7, 8, 8, 8, 8);
        log.forEach((entry, index) -> cnt.incrementAndGet());
        assert (cnt.get() == 13);
        cnt.set(0);
        log.forEach((entry, index) -> cnt.incrementAndGet(), 0, 25);
        assert (cnt.get() == 13);
    }

    protected void append(Log log, int start_index, boolean overwrite, byte[] buf, int ... terms) {
        int index = start_index;
        for (int term : terms) {
            log.append(index, overwrite, new LogEntry(term, buf));
            ++index;
        }
    }

    protected void assertIndices(int first_applied, int last_applied, int commit_index, int current_term) {
        Assert.assertEquals((int)this.log.firstApplied(), (int)first_applied);
        Assert.assertEquals((int)this.log.lastApplied(), (int)last_applied);
        Assert.assertEquals((int)this.log.commitIndex(), (int)commit_index);
        Assert.assertEquals((int)this.log.currentTerm(), (int)current_term);
    }
}

