/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.DataOutput;
import org.jgroups.protocols.raft.AppendEntriesRequest;
import org.jgroups.protocols.raft.AppendEntriesResponse;
import org.jgroups.protocols.raft.AppendResult;
import org.jgroups.protocols.raft.HeartbeatRequest;
import org.jgroups.protocols.raft.InstallSnapshotRequest;
import org.jgroups.protocols.raft.REDIRECT;
import org.jgroups.protocols.raft.RaftHeader;
import org.jgroups.protocols.raft.VoteRequest;
import org.jgroups.protocols.raft.VoteResponse;
import org.jgroups.util.ByteArrayDataOutputStream;
import org.jgroups.util.Util;
import org.testng.annotations.Test;

@Test(groups={"functional"}, singleThreaded=false)
public class RaftHeaderTest {
    public void testVoteRequestHeader() throws Exception {
        VoteRequest hdr = new VoteRequest(22, 3, 7);
        RaftHeaderTest._testSize(hdr, VoteRequest.class);
    }

    public void testVoteResponseHeader() throws Exception {
        VoteResponse rsp = new VoteResponse(22, true);
        RaftHeaderTest._testSize(rsp, VoteResponse.class);
    }

    public void testHeatbeatHeader() throws Exception {
        HeartbeatRequest hb = new HeartbeatRequest(22, Util.createRandomAddress((String)"A"));
        RaftHeaderTest._testSize(hb, HeartbeatRequest.class);
    }

    public void testAppendEntriesRequest() throws Exception {
        AppendEntriesRequest req = new AppendEntriesRequest(22, Util.createRandomAddress((String)"A"), 4, 21, 22, 18, true);
        RaftHeaderTest._testSize(req, AppendEntriesRequest.class);
    }

    public void testAppendEntriesResponse() throws Exception {
        AppendEntriesResponse rsp = new AppendEntriesResponse(22, new AppendResult(false, 22, 5));
        RaftHeaderTest._testSize(rsp, AppendEntriesResponse.class);
    }

    public void testInstallSnapshotHeader() throws Exception {
        InstallSnapshotRequest hdr = new InstallSnapshotRequest(5);
        RaftHeaderTest._testSize(hdr, InstallSnapshotRequest.class);
        hdr = new InstallSnapshotRequest(5, Util.createRandomAddress((String)"A"), 5, 4);
        RaftHeaderTest._testSize(hdr, InstallSnapshotRequest.class);
    }

    public static void testRedirectHeader() throws Exception {
        REDIRECT.RedirectHeader hdr = new REDIRECT.RedirectHeader(REDIRECT.RequestType.SET_REQ, 22, true);
        RaftHeaderTest._testSize(hdr, REDIRECT.RedirectHeader.class);
        hdr = new REDIRECT.RedirectHeader(REDIRECT.RequestType.RSP, 322649, false);
        RaftHeaderTest._testSize(hdr, REDIRECT.RedirectHeader.class);
    }

    protected static <T extends RaftHeader> void _testSize(T hdr, Class<T> clazz) throws Exception {
        int size = hdr.size();
        ByteArrayDataOutputStream out = new ByteArrayDataOutputStream(size);
        hdr.writeTo((DataOutput)out);
        System.out.println(clazz.getSimpleName() + ": size=" + size);
        assert (out.position() == size);
        RaftHeader hdr2 = (RaftHeader)Util.streamableFromByteBuffer(clazz, (byte[])out.buffer(), (int)0, (int)out.position());
        assert (hdr2 != null);
        assert (hdr.term() == hdr2.term());
    }

    protected static <T extends REDIRECT.RedirectHeader> void _testSize(T hdr, Class<T> clazz) throws Exception {
        int size = hdr.size();
        ByteArrayDataOutputStream out = new ByteArrayDataOutputStream(size);
        hdr.writeTo((DataOutput)out);
        System.out.println(clazz.getSimpleName() + ": size=" + size);
        assert (out.position() == size);
        REDIRECT.RedirectHeader hdr2 = (REDIRECT.RedirectHeader)Util.streamableFromByteBuffer(clazz, (byte[])out.buffer(), (int)0, (int)out.position());
        assert (hdr2 != null);
        assert (hdr.size() == hdr2.size());
    }
}

