/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.protocols.raft.ELECTION;
import org.jgroups.protocols.raft.RAFT;
import org.jgroups.protocols.raft.REDIRECT;
import org.jgroups.protocols.raft.StateMachine;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, singleThreaded=true)
public class VoteTest {
    protected JChannel[] channels;
    protected RAFT[] rafts;
    protected Address leader;
    protected static final String CLUSTER = VoteTest.class.getSimpleName();
    protected static final List<String> mbrs = Arrays.asList("A", "B", "C", "D");

    @AfterMethod
    protected void destroy() {
        this.close(true, true, this.channels);
    }

    public void testStartOfNonMember() {
        Object non_member;
        block4: {
            non_member = null;
            try {
                this.init("X");
                if ($assertionsDisabled) break block4;
                throw new AssertionError((Object)"Starting a non-member should throw an exception");
            }
            catch (Exception e) {
                try {
                    System.out.println("received exception as expected: " + e.toString());
                }
                catch (Throwable throwable) {
                    this.close(true, true, non_member);
                    throw throwable;
                }
                this.close(true, true, non_member);
            }
        }
        this.close(true, true, non_member);
    }

    public void testMemberVotesTwice() throws Exception {
        int actual_last_applied;
        RAFT r;
        this.init("A", "B", "C");
        this.leader = VoteTest.leader(10000L, 500L, this.channels);
        System.out.println("leader = " + this.leader);
        assert (this.leader != null);
        this.assertSameLeader(this.leader, this.channels);
        RAFT raft = this.raft(this.leader);
        int index = VoteTest.nonLeader(this.channels);
        JChannel non_leader = this.channels[index];
        String name = non_leader.getName();
        System.out.println("---> Stopping " + name);
        Util.close((Closeable)non_leader);
        try {
            raft.set(new byte[]{98, 101, 108, 97}, 0, 4, 500L, TimeUnit.MILLISECONDS);
            assert (false) : "the change should have failed as we don't have a majority of 3 to commit it";
        }
        catch (TimeoutException ex) {
            System.out.println("Caught an exception as expected, trying to commit a change: " + ex);
        }
        for (JChannel ch : this.channels) {
            if (!ch.isConnected()) continue;
            r = VoteTest.raft(ch);
            System.out.println(ch.getAddress() + ": last_applied=" + r.lastApplied() + ", commit_index=" + r.commitIndex());
            assert (r.commitIndex() == 0) : "commit_index of " + ch.getName() + " should be 0 (was " + r.commitIndex() + ")";
            actual_last_applied = r.lastApplied();
            assert (actual_last_applied == 1) : "expected last_applied=1, but got " + actual_last_applied;
        }
        index = VoteTest.nonLeader(this.channels);
        non_leader = this.channels[index];
        name = non_leader.getName();
        System.out.println("---> Stopping " + name);
        Util.close((Closeable)non_leader);
        System.out.println("--> Starting " + name);
        this.channels[index] = this.create(name);
        Util.sleep((long)2000L);
        for (JChannel ch : this.channels) {
            if (!ch.isConnected()) continue;
            r = VoteTest.raft(ch);
            System.out.println(ch.getAddress() + ": last_applied=" + r.lastApplied() + ", commit_index=" + r.commitIndex());
        }
        for (JChannel ch : this.channels) {
            if (!ch.isConnected()) continue;
            r = VoteTest.raft(ch);
            System.out.println(ch.getAddress() + ": last_applied=" + r.lastApplied() + ", commit_index=" + r.commitIndex());
            assert (r.commitIndex() == 0) : "commit_index of " + ch.getName() + " should be 0 (was " + r.commitIndex() + ")";
            actual_last_applied = r.lastApplied();
            assert (actual_last_applied == 1) : "expected last_applied=1, but got " + actual_last_applied;
        }
    }

    protected void init(String ... nodes) throws Exception {
        this.channels = new JChannel[nodes.length];
        this.rafts = new RAFT[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            this.channels[i] = this.create(nodes[i]);
            this.rafts[i] = VoteTest.raft(this.channels[i]);
        }
    }

    protected JChannel create(String name) throws Exception {
        RAFT raft = new RAFT().members(mbrs).raftId(name).stateMachine(new DummyStateMachine()).logClass("org.jgroups.protocols.raft.InMemoryLog").logName(name + "-" + CLUSTER);
        JChannel ch = new JChannel(Util.getTestStack((Protocol[])new Protocol[]{new ELECTION(), raft, new REDIRECT()})).name(name);
        ch.connect(CLUSTER);
        return ch;
    }

    protected static Address leader(long timeout, long interval, JChannel ... channels) {
        long target_time = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() <= target_time) {
            for (JChannel ch : channels) {
                if (!ch.isConnected() || VoteTest.raft(ch).leader() == null) continue;
                return VoteTest.raft(ch).leader();
            }
            Util.sleep((long)interval);
        }
        return null;
    }

    protected static int nonLeader(JChannel ... channels) {
        for (int i = channels.length - 1; i >= 0; --i) {
            JChannel ch = channels[i];
            if (!ch.isConnected() || VoteTest.raft(ch).leader().equals(ch.getAddress())) continue;
            return i;
        }
        return -1;
    }

    protected void assertSameLeader(Address leader, JChannel ... channels) {
        for (JChannel ch : channels) {
            assert (leader.equals(VoteTest.raft(ch).leader()));
        }
    }

    protected void assertCommitIndex(long timeout, long interval, int expected_commit, JChannel ... channels) {
        long target_time = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() <= target_time) {
            boolean all_ok = true;
            JChannel[] jChannelArray = channels;
            int n = jChannelArray.length;
            for (int i = 0; i < n; ++i) {
                JChannel ch = jChannelArray[i];
                RAFT raft = VoteTest.raft(ch);
                if (expected_commit == raft.commitIndex()) continue;
                all_ok = false;
            }
            if (all_ok) break;
            Util.sleep((long)interval);
        }
        for (JChannel ch : channels) {
            RAFT raft = VoteTest.raft(ch);
            System.out.printf("%s: members=%s, last-applied=%d, commit-index=%d\n", ch.getAddress(), raft.members(), raft.lastApplied(), raft.commitIndex());
            assert (raft.commitIndex() == expected_commit) : String.format("%s: last-applied=%d, commit-index=%d", ch.getAddress(), raft.lastApplied(), raft.commitIndex());
        }
    }

    protected RAFT raft(Address addr) {
        return VoteTest.raft(this.channel(addr));
    }

    protected JChannel channel(Address addr) {
        for (JChannel ch : Arrays.asList(this.channels)) {
            if (ch.getAddress() == null || !ch.getAddress().equals(addr)) continue;
            return ch;
        }
        return null;
    }

    protected static RAFT raft(JChannel ch) {
        return (RAFT)ch.getProtocolStack().findProtocol(RAFT.class);
    }

    protected void close(boolean remove_log, boolean remove_snapshot, JChannel ... channels) {
        for (JChannel ch : channels) {
            if (ch == null) continue;
            RAFT raft = (RAFT)ch.getProtocolStack().findProtocol(RAFT.class);
            if (remove_log) {
                raft.log().delete();
            }
            if (remove_snapshot) {
                raft.deleteSnapshot();
            }
            Util.close((Closeable)ch);
        }
    }

    protected static class DummyStateMachine
    implements StateMachine {
        protected DummyStateMachine() {
        }

        @Override
        public byte[] apply(byte[] data, int offset, int length) throws Exception {
            return new byte[0];
        }

        @Override
        public void readContentFrom(DataInput in) throws Exception {
        }

        @Override
        public void writeContentTo(DataOutput out) throws Exception {
        }
    }
}

