/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.raft;

import java.io.DataInput;
import java.io.DataOutput;
import org.jgroups.util.Bits;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class LogEntry
implements Streamable {
    protected int term;
    protected byte[] command;
    protected int offset;
    protected int length;
    protected boolean internal;

    public LogEntry() {
    }

    public LogEntry(int term, byte[] command) {
        this(term, command, 0, command != null ? command.length : 0);
    }

    public LogEntry(int term, byte[] command, int offset, int length) {
        this(term, command, offset, length, false);
    }

    public LogEntry(int term, byte[] command, int offset, int length, boolean internal) {
        this.term = term;
        this.command = command;
        this.offset = offset;
        this.length = length;
        this.internal = internal;
    }

    public int term() {
        return this.term;
    }

    public byte[] command() {
        return this.command;
    }

    public int offset() {
        return this.offset;
    }

    public int length() {
        return this.length;
    }

    public boolean internal() {
        return this.internal;
    }

    public void writeTo(DataOutput out) throws Exception {
        Bits.writeInt((int)this.term, (DataOutput)out);
        Util.writeByteBuffer((byte[])this.command, (int)this.offset, (int)this.length, (DataOutput)out);
        out.writeBoolean(this.internal);
    }

    public void readFrom(DataInput in) throws Exception {
        this.term = Bits.readInt((DataInput)in);
        this.command = Util.readByteBuffer((DataInput)in);
        this.offset = 0;
        this.length = this.command != null ? this.command.length : 0;
        this.internal = in.readBoolean();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("term=").append(this.term).append(" (").append(this.command != null ? this.command.length : 0).append(" bytes)");
        if (this.internal) {
            str.append(" [internal]");
        }
        return str.toString();
    }
}

