/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.raft;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.lang.reflect.Array;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.ObjIntConsumer;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.protocols.raft.AppendEntriesRequest;
import org.jgroups.protocols.raft.AppendEntriesResponse;
import org.jgroups.protocols.raft.AppendResult;
import org.jgroups.protocols.raft.Candidate;
import org.jgroups.protocols.raft.DynamicMembership;
import org.jgroups.protocols.raft.Follower;
import org.jgroups.protocols.raft.InstallSnapshotRequest;
import org.jgroups.protocols.raft.InternalCommand;
import org.jgroups.protocols.raft.Leader;
import org.jgroups.protocols.raft.Log;
import org.jgroups.protocols.raft.LogEntry;
import org.jgroups.protocols.raft.RaftHeader;
import org.jgroups.protocols.raft.RaftImpl;
import org.jgroups.protocols.raft.Role;
import org.jgroups.protocols.raft.Settable;
import org.jgroups.protocols.raft.StateMachine;
import org.jgroups.raft.util.CommitTable;
import org.jgroups.raft.util.RequestTable;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Bits;
import org.jgroups.util.ExtendedUUID;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.Streamable;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

@MBean(description="Implementation of the RAFT consensus protocol")
public class RAFT
extends Protocol
implements Runnable,
Settable,
DynamicMembership {
    protected static final byte[] raft_id_key = Util.stringToBytes((String)"raft-id");
    protected static final short RAFT_ID = 521;
    protected static final short APPEND_ENTRIES_REQ = 2000;
    protected static final short APPEND_ENTRIES_RSP = 2001;
    protected static final short APPEND_RESULT = 2002;
    protected static final short INSTALL_SNAPSHOT_REQ = 2003;
    @Property(description="The identifier of this node. Needs to be unique and an element of members. Must not be null", writable=false)
    protected String raft_id;
    protected final List<String> members = new ArrayList<String>();
    @ManagedAttribute(description="Majority needed to achieve consensus; computed from members)")
    protected int majority = -1;
    @ManagedAttribute(description="If true, we can change 'members' at runtime")
    protected boolean dynamic_view_changes = true;
    @Property(description="The fully qualified name of the class implementing Log")
    protected String log_class = "org.jgroups.protocols.raft.LevelDBLog";
    @Property(description="Arguments to the log impl, e.g. k1=v1,k2=v2. These will be passed to init()")
    protected String log_args;
    @Property(description="The name of the log. The logical name of the channel (if defined) is used by default. Note that logs for different processes on the same host need to be different")
    protected String log_name;
    @Property(description="The name of the snapshot. By default, <log_name>.snapshot will be used")
    protected String snapshot_name;
    @Property(description="Interval (ms) at which AppendEntries messages are resent to members which haven't received them yet")
    protected long resend_interval = 1000L;
    @Property(description="Max number of bytes a log can have until a snapshot is created")
    protected int max_log_size = 1000000;
    protected Future<?> resend_task;
    protected StateMachine state_machine;
    protected boolean state_machine_loaded;
    protected Log log_impl;
    protected RequestTable<String> request_table;
    protected CommitTable commit_table;
    protected final List<RoleChange> role_change_listeners = new ArrayList<RoleChange>();
    protected final AtomicBoolean members_being_changed = new AtomicBoolean(false);
    protected volatile RaftImpl impl = new Follower(this);
    protected volatile View view;
    protected Address local_addr;
    protected TimeScheduler timer;
    protected volatile Address leader;
    @ManagedAttribute(description="The current term")
    protected int current_term;
    @ManagedAttribute(description="Index of the highest log entry appended to the log")
    protected int last_appended;
    @ManagedAttribute(description="Index of the highest committed log entry")
    protected int commit_index;
    @ManagedAttribute(description="Is a snapshot in progress")
    protected boolean snapshotting;
    protected int log_size_bytes;

    public Address address() {
        return this.local_addr;
    }

    public String raftId() {
        return this.raft_id;
    }

    public RAFT raftId(String id) {
        if (id != null) {
            this.raft_id = id;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int majority() {
        List<String> list = this.members;
        synchronized (list) {
            return this.majority;
        }
    }

    public String logClass() {
        return this.log_class;
    }

    public RAFT logClass(String clazz) {
        this.log_class = clazz;
        return this;
    }

    public String logArgs() {
        return this.log_args;
    }

    public RAFT logArgs(String args) {
        this.log_args = args;
        return this;
    }

    public String logName() {
        return this.log_name;
    }

    public RAFT logName(String name) {
        this.log_name = name;
        return this;
    }

    public String snapshotName() {
        return this.snapshot_name;
    }

    public RAFT snapshotName(String name) {
        this.snapshot_name = name;
        return this;
    }

    public long resendInterval() {
        return this.resend_interval;
    }

    public RAFT resendInterval(long val) {
        this.resend_interval = val;
        return this;
    }

    public int maxLogSize() {
        return this.max_log_size;
    }

    public RAFT maxLogSize(int val) {
        this.max_log_size = val;
        return this;
    }

    @ManagedAttribute(description="Current leader")
    public String getLeader() {
        return this.leader != null ? this.leader.toString() : "none";
    }

    public Address leader() {
        return this.leader;
    }

    public RAFT leader(Address new_leader) {
        this.leader = new_leader;
        return this;
    }

    public boolean isLeader() {
        return Objects.equals(this.leader, this.local_addr);
    }

    public org.jgroups.logging.Log getLog() {
        return this.log;
    }

    public RAFT stateMachine(StateMachine sm) {
        this.state_machine = sm;
        return this;
    }

    public StateMachine stateMachine() {
        return this.state_machine;
    }

    public int currentTerm() {
        return this.current_term;
    }

    public int lastAppended() {
        return this.last_appended;
    }

    public int commitIndex() {
        return this.commit_index;
    }

    public Log log() {
        return this.log_impl;
    }

    public RAFT log(Log new_log) {
        this.log_impl = new_log;
        return this;
    }

    public RAFT addRoleListener(RoleChange c) {
        this.role_change_listeners.add(c);
        return this;
    }

    public RAFT remRoleListener(RoleChange c) {
        this.role_change_listeners.remove(c);
        return this;
    }

    @ManagedAttribute(description="Is the resend task running")
    public boolean resendTaskRunning() {
        return this.resend_task != null && !this.resend_task.isDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Property(description="List of members (logical names); majority is computed from it")
    public void setMembers(String list) {
        List<String> list2 = this.members;
        synchronized (list2) {
            this.members.clear();
            this.members.addAll(new HashSet(Util.parseCommaDelimitedStrings((String)list)));
            this.majority = this.members.size() / 2 + 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RAFT members(List<String> list) {
        List<String> list2 = this.members;
        synchronized (list2) {
            this.members.clear();
            this.members.addAll(new HashSet<String>(list));
            this.majority = this.members.size() / 2 + 1;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Property
    public List<String> members() {
        List<String> list = this.members;
        synchronized (list) {
            return new ArrayList<String>(this.members);
        }
    }

    public synchronized int currentTerm(int new_term) {
        if (new_term < this.current_term) {
            return -1;
        }
        if (new_term > this.current_term) {
            this.log.trace("%s: changed term from %d -> %d", new Object[]{this.local_addr, this.current_term, new_term});
            this.current_term = new_term;
            this.log_impl.currentTerm(new_term);
            this.changeRole(Role.Follower);
            return 1;
        }
        return 0;
    }

    @ManagedAttribute(description="The current role")
    public String role() {
        RaftImpl tmp = this.impl;
        return tmp.getClass().getSimpleName();
    }

    @ManagedOperation(description="Dumps the commit table")
    public String dumpCommitTable() {
        return this.commit_table != null ? this.commit_table.toString() : "n/a";
    }

    @ManagedAttribute(description="Number of log entries in the log")
    public int logSize() {
        AtomicInteger count = new AtomicInteger(0);
        this.log_impl.forEach((entry, index) -> count.incrementAndGet());
        return count.intValue();
    }

    @ManagedAttribute(description="Number of bytes in the log")
    public int logSizeInBytes() {
        AtomicInteger count = new AtomicInteger(0);
        this.log_impl.forEach((entry, index) -> count.addAndGet(entry.length()));
        return count.intValue();
    }

    @ManagedOperation(description="Dumps the last N log entries")
    public String dumpLog(int last_n) {
        StringBuilder sb = new StringBuilder();
        int to = this.last_appended;
        int from = Math.max(1, to - last_n);
        this.log_impl.forEach((entry, index) -> sb.append("index=").append(index).append(", term=").append(entry.term()).append(" (").append(entry.command().length).append(" bytes)\n"), from, to);
        return sb.toString();
    }

    @ManagedOperation(description="Dumps all log entries")
    public String dumpLog() {
        return this.dumpLog(this.last_appended - 1);
    }

    public void logEntries(ObjIntConsumer<LogEntry> func) {
        this.log_impl.forEach(func);
    }

    public synchronized int createNewTerm() {
        return ++this.current_term;
    }

    protected synchronized void createRequestTable() {
        this.request_table = new RequestTable();
        for (int i = this.commit_index + 1; i <= this.last_appended; ++i) {
            this.request_table.create(i, this.raft_id, null);
        }
    }

    protected void createCommitTable() {
        ArrayList<Address> mbrs = new ArrayList<Address>(this.view.getMembers());
        mbrs.remove(this.local_addr);
        this.commit_table = new CommitTable(mbrs, this.last_appended + 1);
    }

    public synchronized boolean updateTermAndLeader(int term, Address new_leader) {
        if (this.leader == null || new_leader != null && !this.leader.equals(new_leader)) {
            this.leader = new_leader;
        }
        if (term > this.current_term) {
            this.current_term = term;
            return true;
        }
        return false;
    }

    @Override
    @ManagedOperation(description="Adds a new server to members. Prevents duplicates")
    public CompletableFuture<byte[]> addServer(String name) throws Exception {
        return this.changeMembers(name, InternalCommand.Type.addServer);
    }

    @Override
    @ManagedOperation(description="Removes a new server from members")
    public CompletableFuture<byte[]> removeServer(String name) throws Exception {
        return this.changeMembers(name, InternalCommand.Type.removeServer);
    }

    protected CompletableFuture<byte[]> changeMembers(String name, InternalCommand.Type type) throws Exception {
        if (!this.dynamic_view_changes) {
            throw new Exception("dynamic view changes are not allowed; set dynamic_view_changes to true to enable it");
        }
        if (this.leader == null || this.local_addr != null && !this.leader.equals(this.local_addr)) {
            throw new IllegalStateException("I'm not the leader (local_addr=" + this.local_addr + ", leader=" + this.leader + ")");
        }
        if (this.members_being_changed.compareAndSet(false, true)) {
            InternalCommand cmd = new InternalCommand(type, name);
            byte[] buf = Util.streamableToByteBuffer((Streamable)cmd);
            return this.setAsync(buf, 0, buf.length, cmd);
        }
        throw new IllegalStateException((Object)((Object)type) + "(" + name + ") cannot be invoked as previous operation has not yet been committed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _addServer(String name) {
        if (name == null) {
            return;
        }
        List<String> list = this.members;
        synchronized (list) {
            if (!this.members.contains(name)) {
                this.members.add(name);
                this.majority = this.members.size() / 2 + 1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _removeServer(String name) {
        if (name == null) {
            return;
        }
        List<String> list = this.members;
        synchronized (list) {
            if (this.members.remove(name)) {
                this.majority = this.members.size() / 2 + 1;
            }
        }
    }

    @ManagedOperation(description="Creates a new snapshot and truncates the log")
    public synchronized void snapshot() throws Exception {
        if (this.snapshotting) {
            this.log.error("%s: cannot create snapshot; snapshot is being created by another thread");
            return;
        }
        try {
            this.snapshotting = true;
            this.doSnapshot();
        }
        finally {
            this.snapshotting = false;
        }
    }

    @ManagedOperation(description="Reads snapshot (if present) and log entries up to commit_index and applies them to the state machine")
    public synchronized void initStateMachineFromLog(boolean force) throws Exception {
        if (this.state_machine != null && (!this.state_machine_loaded || force)) {
            int snapshot_offset = 0;
            try (FileInputStream input2 = new FileInputStream(this.snapshot_name);){
                this.state_machine.readContentFrom(new DataInputStream(input2));
                snapshot_offset = 1;
                this.log.debug("%s: initialized state machine from snapshot %s", new Object[]{this.local_addr, this.snapshot_name});
            }
            catch (FileNotFoundException input2) {
                // empty catch block
            }
            int from = Math.max(1, this.log_impl.firstAppended() + snapshot_offset);
            int to = this.commit_index;
            int count = 0;
            for (int i = from; i <= to; ++i) {
                LogEntry log_entry = this.log_impl.get(i);
                if (log_entry == null) {
                    this.log.error("%s: log entry for index %d not found in log", new Object[]{this.local_addr, i});
                    break;
                }
                if (log_entry.command == null) continue;
                if (log_entry.internal) {
                    this.executeInternalCommand(null, log_entry.command, log_entry.offset, log_entry.length);
                    continue;
                }
                this.state_machine.apply(log_entry.command, log_entry.offset, log_entry.length);
                ++count;
            }
            this.state_machine_loaded = true;
            if (count > 0) {
                this.log.debug("%s: applied %d entries from the log (%d - %d) to the state machine", new Object[]{this.local_addr, count, from, to});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws Exception {
        super.init();
        this.timer = this.getTransport().getTimer();
        if (this.raft_id == null) {
            throw new IllegalStateException("raft_id must not be null");
        }
        List<String> list = this.members;
        synchronized (list) {
            HashSet<String> tmp = new HashSet<String>(this.members);
            if (tmp.size() != this.members.size()) {
                this.log.error("members (%s) contains duplicates; removing them and setting members to %s", new Object[]{this.members, tmp});
                this.members.clear();
                this.members.addAll(tmp);
            }
            this.majority = this.members.size() / 2 + 1;
        }
        JChannel ch = this.stack.getChannel();
        ch.addAddressGenerator(() -> ExtendedUUID.randomUUID((String)ch.getName()).put(raft_id_key, Util.stringToBytes((String)this.raft_id)));
    }

    public void start() throws Exception {
        super.start();
        if (this.log_class == null) {
            throw new IllegalStateException("log_class has to be defined");
        }
        if (!(this.local_addr instanceof ExtendedUUID)) {
            throw new IllegalStateException("local address must be an ExtendedUUID but is a " + this.local_addr.getClass().getSimpleName());
        }
        Class clazz = Util.loadClass((String)this.log_class, this.getClass());
        this.log_impl = (Log)clazz.newInstance();
        Map args = this.log_args != null && !this.log_args.isEmpty() ? Util.parseCommaDelimitedProps((String)this.log_args) : new HashMap();
        if (this.log_name == null) {
            this.log_name = this.raft_id;
        }
        this.snapshot_name = this.log_name;
        this.log_name = RAFT.createLogName(this.log_name, "log");
        this.snapshot_name = RAFT.createLogName(this.snapshot_name, "snapshot");
        this.log_impl.init(this.log_name, args);
        this.last_appended = this.log_impl.lastAppended();
        this.commit_index = this.log_impl.commitIndex();
        this.current_term = this.log_impl.currentTerm();
        this.log.trace("set last_appended=%d, commit_index=%d, current_term=%d", new Object[]{this.last_appended, this.commit_index, this.current_term});
        this.initStateMachineFromLog(false);
        this.log_size_bytes = this.logSizeInBytes();
        if (!this.members.contains(this.raft_id)) {
            throw new IllegalStateException(String.format("raft-id %s is not listed in members %s", this.raft_id, this.members));
        }
    }

    public void stop() {
        super.stop();
        this.impl.destroy();
    }

    public Object down(Event evt) {
        switch (evt.getType()) {
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 6: {
                this.handleView((View)evt.getArg());
            }
        }
        return this.down_prot.down(evt);
    }

    public Object up(Event evt) {
        if (evt.getType() == 6) {
            this.handleView((View)evt.getArg());
        }
        return this.up_prot.up(evt);
    }

    public Object up(Message msg) {
        RaftHeader hdr = (RaftHeader)msg.getHeader(this.id);
        if (hdr != null) {
            this.handleEvent(msg, hdr);
            return null;
        }
        return this.up_prot.up(msg);
    }

    public void up(MessageBatch batch) {
        for (Message msg : batch) {
            RaftHeader hdr = (RaftHeader)msg.getHeader(this.id);
            if (hdr == null) continue;
            batch.remove(msg);
            this.handleEvent(msg, hdr);
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    @Override
    public byte[] set(byte[] buf, int offset, int length) throws Exception {
        CompletableFuture<byte[]> future = this.setAsync(buf, offset, length, null);
        return future.get();
    }

    @Override
    public byte[] set(byte[] buf, int offset, int length, long timeout, TimeUnit unit) throws Exception {
        CompletableFuture<byte[]> future = this.setAsync(buf, offset, length, null);
        return future.get(timeout, unit);
    }

    @Override
    public CompletableFuture<byte[]> setAsync(byte[] buf, int offset, int length) {
        return this.setAsync(buf, offset, length, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletableFuture<byte[]> setAsync(byte[] buf, int offset, int length, InternalCommand cmd) {
        if (this.leader == null || this.local_addr != null && !this.leader.equals(this.local_addr)) {
            throw new IllegalStateException("I'm not the leader (local_addr=" + this.local_addr + ", leader=" + this.leader + ")");
        }
        if (buf == null) {
            throw new IllegalArgumentException("buffer must not be null");
        }
        CompletableFuture<byte[]> retval = new CompletableFuture<byte[]>();
        int prev_index = 0;
        int curr_index = 0;
        int prev_term = 0;
        int curr_term = 0;
        int commit_idx = 0;
        RequestTable<String> reqtab = this.request_table;
        if (reqtab == null) {
            retval.completeExceptionally(new IllegalStateException("request table was null on " + this.impl.getClass().getSimpleName()));
            return retval;
        }
        RAFT rAFT = this;
        synchronized (rAFT) {
            prev_index = this.last_appended++;
            curr_index = this.last_appended;
            curr_term = this.current_term;
            commit_idx = this.commit_index;
            LogEntry entry = this.log_impl.get(prev_index);
            prev_term = entry != null ? entry.term : 0;
            this.log_impl.append(curr_index, true, new LogEntry(curr_term, buf, offset, length, cmd != null));
            if (cmd != null) {
                this.executeInternalCommand(cmd, null, 0, 0);
            }
            reqtab.create(curr_index, this.raft_id, retval);
            Message msg = new Message(null, buf, offset, length).putHeader(this.id, (Header)new AppendEntriesRequest(curr_term, this.local_addr, prev_index, prev_term, curr_term, commit_idx, cmd != null)).setTransientFlag(new Message.TransientFlag[]{Message.TransientFlag.DONT_LOOPBACK});
            this.down_prot.down(msg);
        }
        this.snapshotIfNeeded(length);
        return retval;
    }

    protected void handleEvent(Message msg, RaftHeader hdr) {
        if (this.currentTerm(hdr.term) < 0) {
            return;
        }
        if (hdr instanceof AppendEntriesRequest) {
            AppendEntriesRequest req = (AppendEntriesRequest)hdr;
            AppendResult result = this.impl.handleAppendEntriesRequest(msg.getRawBuffer(), msg.getOffset(), msg.getLength(), msg.src(), req.prev_log_index, req.prev_log_term, req.entry_term, req.leader_commit, req.internal);
            if (result != null) {
                result.commitIndex(this.commit_index);
                Message rsp = new Message(this.leader).putHeader(this.id, (Header)new AppendEntriesResponse(this.current_term, result));
                this.down_prot.down(rsp);
            }
        } else if (hdr instanceof AppendEntriesResponse) {
            AppendEntriesResponse rsp = (AppendEntriesResponse)hdr;
            this.impl.handleAppendEntriesResponse(msg.src(), rsp.term(), rsp.result);
        } else if (hdr instanceof InstallSnapshotRequest) {
            InstallSnapshotRequest req = (InstallSnapshotRequest)hdr;
            this.impl.handleInstallSnapshotRequest(msg, req.term(), req.leader, req.last_included_index, req.last_included_term);
        } else {
            this.log.warn("%s: invalid header %s", new Object[]{this.local_addr, ((Object)((Object)hdr)).getClass().getCanonicalName()});
        }
    }

    @Override
    public void run() {
        this.commit_table.forEach(this::sendAppendEntriesMessage);
    }

    protected void sendAppendEntriesMessage(Address member, CommitTable.Entry entry) {
        int next_index = entry.nextIndex();
        int commit_idx = entry.commitIndex();
        int match_index = entry.matchIndex();
        if (next_index < this.log().firstAppended()) {
            if (entry.snapshotInProgress(true)) {
                try {
                    this.sendSnapshotTo(member);
                }
                catch (Exception e) {
                    this.log.error("%s: failed sending snapshot to %s: next_index=%d, first_applied=%d", new Object[]{this.local_addr, member, next_index, this.log().firstAppended()});
                }
            }
            return;
        }
        if (this.last_appended >= next_index) {
            int to = entry.sendSingleMessage() ? next_index : this.last_appended;
            for (int i = Math.max(next_index, 1); i <= to; ++i) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("%s: resending %d to %s\n", new Object[]{this.local_addr, i, member});
                }
                this.resend(member, i);
            }
            return;
        }
        if (this.last_appended > match_index) {
            int index = this.last_appended;
            if (index > 0) {
                this.log.trace("%s: resending %d to %s\n", new Object[]{this.local_addr, index, member});
                this.resend(member, index);
            }
            return;
        }
        if (this.commit_index > commit_idx) {
            Message msg = new Message(member).putHeader(this.id, (Header)new AppendEntriesRequest(this.current_term, this.local_addr, 0, 0, 0, this.commit_index, false));
            this.down_prot.down(msg);
            return;
        }
        if (this.commit_index < this.last_appended) {
            for (int i = this.commit_index + 1; i <= this.last_appended; ++i) {
                this.resend(member, i);
            }
        }
    }

    protected void resend(Address target, int index) {
        LogEntry entry = this.log_impl.get(index);
        if (entry == null) {
            this.log.error("%s: resending of %d failed; entry not found", new Object[]{this.local_addr, index});
            return;
        }
        LogEntry prev = this.log_impl.get(index - 1);
        int prev_term = prev != null ? prev.term : 0;
        Message msg = new Message(target).setBuffer(entry.command, entry.offset, entry.length).putHeader(this.id, (Header)new AppendEntriesRequest(this.current_term, this.local_addr, index - 1, prev_term, entry.term, this.commit_index, entry.internal));
        this.down_prot.down(msg);
    }

    protected void doSnapshot() throws Exception {
        if (this.state_machine == null) {
            throw new IllegalStateException("state machine is null");
        }
        try (FileOutputStream output = new FileOutputStream(this.snapshot_name);){
            this.state_machine.writeContentTo(new DataOutputStream(output));
        }
        this.log_impl.truncate(this.commitIndex());
    }

    protected boolean snapshotExists() {
        File file = new File(this.snapshot_name);
        return file.exists();
    }

    public boolean deleteSnapshot() {
        File file = new File(this.snapshot_name);
        return file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void sendSnapshotTo(Address dest) throws Exception {
        try {
            if (this.snapshotting) {
                return;
            }
            this.snapshotting = true;
            LogEntry last_committed_entry = this.log_impl.get(this.commitIndex());
            int last_index = this.commit_index;
            int last_term = last_committed_entry.term;
            this.doSnapshot();
            byte[] data = Files.readAllBytes(Paths.get(this.snapshot_name, new String[0]));
            this.log.debug("%s: sending snapshot (%s) to %s", new Object[]{this.local_addr, Util.printBytes((long)data.length), dest});
            Message msg = new Message(dest, data).putHeader(this.id, (Header)new InstallSnapshotRequest(this.currentTerm(), this.leader(), last_index, last_term));
            this.down_prot.down(msg);
        }
        finally {
            this.snapshotting = false;
            if (this.commit_table != null) {
                this.commit_table.snapshotInProgress(dest, false);
            }
        }
    }

    protected synchronized void handleCommit(int index) {
        try {
            for (int i = this.commit_index + 1; i <= index; ++i) {
                if (!this.request_table.isCommitted(i)) continue;
                this.applyCommit(i);
                this.commit_index = Math.max(this.commit_index, i);
            }
        }
        catch (Throwable t) {
            this.log.error("failed applying commit %d: %s", new Object[]{index, t});
        }
    }

    protected synchronized RAFT commitLogTo(int leader_commit) {
        try {
            for (int i = this.commit_index + 1; i <= Math.min(this.last_appended, leader_commit); ++i) {
                this.applyCommit(i);
                this.commit_index = Math.max(this.commit_index, i);
            }
        }
        catch (Throwable t) {
            this.log.error(this.local_addr + ": failed advancing commit_index (%d) to %d: %s", new Object[]{this.commit_index, leader_commit, t});
        }
        return this;
    }

    protected RAFT append(int term, int index, byte[] data, int offset, int length, boolean internal) {
        LogEntry entry = new LogEntry(term, data, offset, length, internal);
        this.log_impl.append(index, true, entry);
        this.last_appended = this.log_impl.lastAppended();
        this.snapshotIfNeeded(length);
        return this;
    }

    protected void deleteAllLogEntriesStartingFrom(int index) {
        this.log_impl.deleteAllEntriesStartingFrom(index);
        this.last_appended = this.log_impl.lastAppended();
        this.commit_index = this.log_impl.commitIndex();
    }

    protected void snapshotIfNeeded(int bytes_added) {
        this.log_size_bytes += bytes_added;
        if (this.log_size_bytes >= this.max_log_size) {
            try {
                this.log.debug("%s: current log size is %d, exceeding max_log_size of %d: creating snapshot", new Object[]{this.local_addr, this.log_size_bytes, this.max_log_size});
                this.snapshot();
                this.log_size_bytes = this.logSizeInBytes();
            }
            catch (Exception ex) {
                this.log.error("%s: failed snapshotting log: %s", new Object[]{this.local_addr, ex});
            }
        }
    }

    protected void applyCommit(int index) throws Exception {
        LogEntry log_entry = this.log_impl.get(index);
        if (log_entry == null) {
            throw new IllegalStateException(this.local_addr + ": log entry for index " + index + " not found in log");
        }
        if (this.state_machine == null) {
            throw new IllegalStateException(this.local_addr + ": state machine is null");
        }
        byte[] rsp = null;
        if (log_entry.internal) {
            try {
                InternalCommand cmd = (InternalCommand)Util.streamableFromByteBuffer(InternalCommand.class, (byte[])log_entry.command, (int)log_entry.offset, (int)log_entry.length);
                if (cmd.type() == InternalCommand.Type.addServer || cmd.type() == InternalCommand.Type.removeServer) {
                    this.members_being_changed.set(false);
                }
            }
            catch (Throwable t) {
                this.log.error("%s: failed unmarshalling internal command: %s", new Object[]{this.local_addr, t});
            }
        } else {
            rsp = this.state_machine.apply(log_entry.command, log_entry.offset, log_entry.length);
        }
        if (this.request_table != null) {
            this.request_table.notifyAndRemove(index, rsp);
        }
        this.log_impl.commitIndex(index);
    }

    protected void handleView(View view) {
        boolean check_view = this.view != null && this.view.size() < view.size();
        this.view = view;
        if (this.commit_table != null) {
            ArrayList<Address> mbrs = new ArrayList<Address>(view.getMembers());
            mbrs.remove(this.local_addr);
            this.commit_table.adjust(mbrs, this.last_appended + 1);
        }
        if (check_view && this.duplicatesInView(view)) {
            this.log.error("view contains duplicate raft-ids: %s", new Object[]{view});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changeRole(Role new_role) {
        RaftImpl new_impl = new_role == Role.Follower ? new Follower(this) : (new_role == Role.Candidate ? new Candidate(this) : new Leader(this));
        RaftImpl old_impl = this.impl;
        if (old_impl == null || !old_impl.getClass().equals(new_impl.getClass())) {
            if (old_impl != null) {
                old_impl.destroy();
            }
            new_impl.init();
            RAFT rAFT = this;
            synchronized (rAFT) {
                this.impl = new_impl;
            }
            this.log.trace("%s: changed role from %s -> %s", new Object[]{this.local_addr, old_impl == null ? "null" : old_impl.getClass().getSimpleName(), new_impl.getClass().getSimpleName()});
            this.notifyRoleChangeListeners(new_role);
        }
    }

    protected void executeInternalCommand(InternalCommand cmd, byte[] buf, int offset, int length) {
        if (cmd == null) {
            try {
                cmd = (InternalCommand)Util.streamableFromByteBuffer(InternalCommand.class, (byte[])buf, (int)offset, (int)length);
            }
            catch (Exception ex) {
                this.log.error("%s: failed unmarshalling internal command: %s", new Object[]{this.local_addr, ex});
                return;
            }
        }
        try {
            cmd.execute(this);
        }
        catch (Exception ex) {
            this.log.error("%s: failed executing internal command %s: %s", new Object[]{this.local_addr, cmd, ex});
        }
    }

    protected synchronized void startResendTask() {
        if (this.resend_task == null || this.resend_task.isDone()) {
            this.resend_task = this.timer.scheduleWithFixedDelay((Runnable)this, this.resend_interval, this.resend_interval, TimeUnit.MILLISECONDS);
        }
    }

    protected synchronized void stopResendTask() {
        if (this.resend_task != null) {
            this.resend_task.cancel(false);
            this.resend_task = null;
        }
    }

    public static <T> T findProtocol(Class<T> clazz, Protocol start, boolean down) {
        Protocol prot = start;
        while (prot != null && clazz != null) {
            if (clazz.isAssignableFrom(prot.getClass())) {
                return (T)prot;
            }
            prot = down ? prot.getDownProtocol() : prot.getUpProtocol();
        }
        return null;
    }

    public static <T extends Streamable> void write(T[] array, DataOutput out) throws Exception {
        Bits.writeInt((int)(array != null ? array.length : 0), (DataOutput)out);
        if (array == null) {
            return;
        }
        for (T el : array) {
            el.writeTo(out);
        }
    }

    public static <T extends Streamable> T[] read(Class<T> clazz, DataInput in) throws Exception {
        int size = Bits.readInt((DataInput)in);
        if (size == 0) {
            return null;
        }
        Streamable[] retval = (Streamable[])Array.newInstance(clazz, size);
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = (Streamable)clazz.newInstance();
            retval[i].readFrom(in);
        }
        return retval;
    }

    protected static String createLogName(String name, String suffix) {
        if (!suffix.startsWith(".")) {
            suffix = "." + suffix;
        }
        boolean needs_suffix = !name.endsWith(suffix);
        String retval = name;
        if (!new File(name).isAbsolute()) {
            String dir = Util.checkForMac() ? File.separator + "tmp" : System.getProperty("java.io.tmpdir", File.separator + "tmp");
            retval = dir + File.separator + name;
        }
        return needs_suffix ? retval + suffix : retval;
    }

    protected void notifyRoleChangeListeners(Role role) {
        for (RoleChange ch : this.role_change_listeners) {
            try {
                ch.roleChanged(role);
            }
            catch (Throwable throwable) {}
        }
    }

    protected boolean duplicatesInView(View view) {
        HashSet<String> mbrs = new HashSet<String>();
        for (Address addr : view) {
            String m;
            if (!(addr instanceof ExtendedUUID)) {
                this.log.warn("address %s is not an ExtendedUUID but a %s", new Object[]{addr, addr.getClass().getSimpleName()});
                continue;
            }
            ExtendedUUID uuid = (ExtendedUUID)addr;
            byte[] val = uuid.get(raft_id_key);
            String string = m = val != null ? Util.bytesToString((byte[])val) : null;
            if (m == null) {
                this.log.error("address %s doesn't have a raft-id", new Object[]{addr});
                continue;
            }
            if (mbrs.add(m)) continue;
            return true;
        }
        return false;
    }

    public int requestTableSize() {
        return this.request_table.size();
    }

    static {
        ClassConfigurator.addProtocol((short)521, RAFT.class);
        ClassConfigurator.add((short)2000, AppendEntriesRequest.class);
        ClassConfigurator.add((short)2001, AppendEntriesResponse.class);
        ClassConfigurator.add((short)2003, InstallSnapshotRequest.class);
        ClassConfigurator.add((short)2002, AppendResult.class);
    }

    public static interface RoleChange {
        public void roleChanged(Role var1);
    }
}

