/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.raft.blocks;

import org.jgroups.blocks.atomic.Counter;
import org.jgroups.raft.blocks.CounterService;

public class CounterImpl
implements Counter {
    protected final String name;
    protected final CounterService counter_service;

    public CounterImpl(String name, CounterService counter_service) {
        this.name = name;
        this.counter_service = counter_service;
    }

    public String getName() {
        return this.name;
    }

    public long get() {
        try {
            return this.counter_service.allowDirtyReads() ? this.counter_service._get(this.name) : this.counter_service.get(this.name);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void set(long new_value) {
        try {
            this.counter_service.set(this.name, new_value);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean compareAndSet(long expect, long update) {
        try {
            return this.counter_service.compareAndSet(this.name, expect, update);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public long incrementAndGet() {
        try {
            return this.counter_service.incrementAndGet(this.name);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public long decrementAndGet() {
        try {
            return this.counter_service.decrementAndGet(this.name);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public long addAndGet(long delta) {
        try {
            return this.counter_service.addAndGet(this.name, delta);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public String toString() {
        return String.valueOf(this.counter_service._get(this.name));
    }
}

