/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.raft.blocks;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jgroups.JChannel;
import org.jgroups.blocks.atomic.Counter;
import org.jgroups.protocols.raft.InternalCommand;
import org.jgroups.protocols.raft.RAFT;
import org.jgroups.protocols.raft.Role;
import org.jgroups.protocols.raft.StateMachine;
import org.jgroups.raft.RaftHandle;
import org.jgroups.raft.blocks.CounterImpl;
import org.jgroups.util.AsciiString;
import org.jgroups.util.Bits;
import org.jgroups.util.ByteArrayDataInputStream;
import org.jgroups.util.ByteArrayDataOutputStream;
import org.jgroups.util.Util;

public class CounterService
implements StateMachine,
RAFT.RoleChange {
    protected JChannel ch;
    protected RaftHandle raft;
    protected long repl_timeout = 20000L;
    protected boolean allow_dirty_reads = true;
    protected final Map<String, Long> counters = new HashMap<String, Long>();

    public CounterService(JChannel ch) {
        this.setChannel(ch);
    }

    public void setChannel(JChannel ch) {
        this.ch = ch;
        this.raft = new RaftHandle(this.ch, this);
        this.raft.addRoleListener(this);
    }

    public void addRoleChangeListener(RAFT.RoleChange listener) {
        this.raft.addRoleListener(listener);
    }

    public long replTimeout() {
        return this.repl_timeout;
    }

    public CounterService replTimeout(long timeout) {
        this.repl_timeout = timeout;
        return this;
    }

    public boolean allowDirtyReads() {
        return this.allow_dirty_reads;
    }

    public CounterService allowDirtyReads(boolean flag) {
        this.allow_dirty_reads = flag;
        return this;
    }

    public int lastApplied() {
        return this.raft.lastApplied();
    }

    public int commitIndex() {
        return this.raft.commitIndex();
    }

    public void snapshot() throws Exception {
        this.raft.snapshot();
    }

    public int logSize() {
        return this.raft.logSizeInBytes();
    }

    public String raftId() {
        return this.raft.raftId();
    }

    public CounterService raftId(String id) {
        this.raft.raftId(id);
        return this;
    }

    public Counter getOrCreateCounter(String name, long initial_value) throws Exception {
        Long existing_value;
        Long l = existing_value = this.allow_dirty_reads ? Long.valueOf(this._get(name)) : this.invoke(Command.get, name, false, new long[0]);
        if (existing_value != null) {
            this.counters.put(name, existing_value);
        } else {
            Object retval = this.invoke(Command.create, name, false, initial_value);
            if (retval instanceof Long) {
                this.counters.put(name, (Long)retval);
            }
        }
        return new CounterImpl(name, this);
    }

    public void deleteCounter(String name) throws Exception {
        this.invoke(Command.delete, name, true, new long[0]);
    }

    public String printCounters() {
        return this.counters.entrySet().stream().collect(StringBuilder::new, (sb, entry) -> sb.append((String)entry.getKey()).append(" = ").append(entry.getValue()).append("\n"), (l, r) -> {}).toString();
    }

    public long get(String name) throws Exception {
        Long retval = this.allow_dirty_reads ? Long.valueOf(this._get(name)) : this.invoke(Command.get, name, false, new long[0]);
        return retval;
    }

    public void set(String name, long new_value) throws Exception {
        this.invoke(Command.set, name, true, new_value);
    }

    public boolean compareAndSet(String name, long expect, long update) throws Exception {
        Object retval = this.invoke(Command.compareAndSet, name, false, expect, update);
        return (Boolean)retval;
    }

    public long incrementAndGet(String name) throws Exception {
        Object retval = this.invoke(Command.incrementAndGet, name, false, new long[0]);
        return (Long)retval;
    }

    public long decrementAndGet(String name) throws Exception {
        Object retval = this.invoke(Command.decrementAndGet, name, false, new long[0]);
        return (Long)retval;
    }

    public long addAndGet(String name, long delta) throws Exception {
        Object retval = this.invoke(Command.addAndGet, name, false, delta);
        return (Long)retval;
    }

    @Override
    public byte[] apply(byte[] data, int offset, int length) throws Exception {
        ByteArrayDataInputStream in = new ByteArrayDataInputStream(data, offset, length);
        Command command = Command.values()[in.readByte()];
        String name = Bits.readAsciiString((DataInput)in).toString();
        switch (command) {
            case create: {
                long v1 = Bits.readLong((DataInput)in);
                long retval = this._create(name, v1);
                return Util.objectToByteBuffer((Object)retval);
            }
            case delete: {
                this._delete(name);
                break;
            }
            case get: {
                long retval = this._get(name);
                return Util.objectToByteBuffer((Object)retval);
            }
            case set: {
                long v1 = Bits.readLong((DataInput)in);
                this._set(name, v1);
                break;
            }
            case compareAndSet: {
                long v1 = Bits.readLong((DataInput)in);
                long v2 = Bits.readLong((DataInput)in);
                boolean success = this._cas(name, v1, v2);
                return Util.objectToByteBuffer((Object)success);
            }
            case incrementAndGet: {
                long retval = this._add(name, 1L);
                return Util.objectToByteBuffer((Object)retval);
            }
            case decrementAndGet: {
                long retval = this._add(name, -1L);
                return Util.objectToByteBuffer((Object)retval);
            }
            case addAndGet: {
                long v1 = Bits.readLong((DataInput)in);
                long retval = this._add(name, v1);
                return Util.objectToByteBuffer((Object)retval);
            }
            default: {
                throw new IllegalArgumentException("command " + (Object)((Object)command) + " is unknown");
            }
        }
        return Util.objectToByteBuffer(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeContentTo(DataOutput out) throws Exception {
        Map<String, Long> map = this.counters;
        synchronized (map) {
            int size = this.counters.size();
            out.writeInt(size);
            for (Map.Entry<String, Long> entry : this.counters.entrySet()) {
                AsciiString name = new AsciiString(entry.getKey());
                Long value = entry.getValue();
                Bits.writeAsciiString((AsciiString)name, (DataOutput)out);
                Bits.writeLong((long)value, (DataOutput)out);
            }
        }
    }

    @Override
    public void readContentFrom(DataInput in) throws Exception {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            AsciiString name = Bits.readAsciiString((DataInput)in);
            Long value = Bits.readLong((DataInput)in);
            this.counters.put(name.toString(), value);
        }
    }

    public void dumpLog() {
        this.raft.logEntries((entry, index) -> {
            StringBuilder sb = new StringBuilder().append(index).append(" (").append(entry.term()).append("): ");
            if (entry.command() == null) {
                sb.append("<marker record>");
                System.out.println(sb);
                return;
            }
            if (entry.internal()) {
                try {
                    InternalCommand cmd = (InternalCommand)Util.streamableFromByteBuffer(InternalCommand.class, (byte[])entry.command(), (int)entry.offset(), (int)entry.length());
                    sb.append("[internal] ").append(cmd);
                }
                catch (Exception ex) {
                    sb.append("[failure reading internal cmd] ").append(ex);
                }
                System.out.println(sb);
                return;
            }
            ByteArrayDataInputStream in = new ByteArrayDataInputStream(entry.command(), entry.offset(), entry.length());
            try {
                Command cmd = Command.values()[in.readByte()];
                String name = Bits.readAsciiString((DataInput)in).toString();
                switch (cmd) {
                    case create: 
                    case set: 
                    case addAndGet: {
                        sb.append(CounterService.print(cmd, name, 1, (DataInput)in));
                        break;
                    }
                    case delete: 
                    case get: 
                    case incrementAndGet: 
                    case decrementAndGet: {
                        sb.append(CounterService.print(cmd, name, 0, (DataInput)in));
                        break;
                    }
                    case compareAndSet: {
                        sb.append(CounterService.print(cmd, name, 2, (DataInput)in));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("command " + (Object)((Object)cmd) + " is unknown");
                    }
                }
            }
            catch (Throwable t) {
                sb.append(t);
            }
            System.out.println(sb);
        });
    }

    @Override
    public void roleChanged(Role role) {
        System.out.println("-- changed role to " + (Object)((Object)role));
    }

    protected Object invoke(Command command, String name, boolean ignore_return_value, long ... values) throws Exception {
        ByteArrayDataOutputStream out = new ByteArrayDataOutputStream(256);
        try {
            out.writeByte(command.ordinal());
            Bits.writeAsciiString((AsciiString)new AsciiString(name), (DataOutput)out);
            for (long val : values) {
                Bits.writeLong((long)val, (DataOutput)out);
            }
        }
        catch (Exception ex) {
            throw new Exception("serialization failure (cmd=" + (Object)((Object)command) + ", name=" + name + ")");
        }
        byte[] buf = out.buffer();
        byte[] rsp = this.raft.set(buf, 0, out.position(), this.repl_timeout, TimeUnit.MILLISECONDS);
        return ignore_return_value ? null : Util.objectFromByteBuffer((byte[])rsp);
    }

    protected static String print(Command command, String name, int num_args, DataInput in) {
        StringBuilder sb = new StringBuilder(command.toString()).append("(").append(name);
        for (int i = 0; i < num_args; ++i) {
            try {
                long val = Bits.readLong((DataInput)in);
                sb.append(", ").append(val);
                continue;
            }
            catch (IOException e) {
                break;
            }
        }
        sb.append(")");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long _create(String name, long initial_value) {
        Map<String, Long> map = this.counters;
        synchronized (map) {
            Long val = this.counters.get(name);
            if (val != null) {
                return val;
            }
            this.counters.put(name, initial_value);
            return initial_value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _delete(String name) {
        Map<String, Long> map = this.counters;
        synchronized (map) {
            this.counters.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long _get(String name) {
        Map<String, Long> map = this.counters;
        synchronized (map) {
            Long retval = this.counters.get(name);
            return retval != null ? retval : 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _set(String name, long new_val) {
        Map<String, Long> map = this.counters;
        synchronized (map) {
            this.counters.put(name, new_val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean _cas(String name, long expected, long value) {
        Map<String, Long> map = this.counters;
        synchronized (map) {
            Long existing_value = this.counters.get(name);
            if (existing_value == null) {
                return false;
            }
            if (existing_value == expected) {
                this.counters.put(name, value);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long _add(String name, long delta) {
        Map<String, Long> map = this.counters;
        synchronized (map) {
            Long val = this.counters.get(name);
            if (val == null) {
                val = 0L;
            }
            this.counters.put(name, val + delta);
            return val + delta;
        }
    }

    protected static enum Command {
        create,
        delete,
        get,
        set,
        compareAndSet,
        incrementAndGet,
        decrementAndGet,
        addAndGet;

    }
}

