/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.raft.demos;

import java.io.Closeable;
import javax.management.MBeanServer;
import org.jgroups.JChannel;
import org.jgroups.Receiver;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.protocols.raft.ELECTION;
import org.jgroups.protocols.raft.RAFT;
import org.jgroups.protocols.raft.Role;
import org.jgroups.raft.blocks.ReplicatedStateMachine;
import org.jgroups.util.Util;

public class ReplicatedStateMachineDemo
extends ReceiverAdapter
implements RAFT.RoleChange {
    protected JChannel ch;
    protected ReplicatedStateMachine<String, Object> rsm;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start(String props, String name, boolean follower, long timeout) throws Exception {
        this.ch = new JChannel(props).name(name);
        this.rsm = new ReplicatedStateMachine(this.ch).raftId(name).timeout(timeout);
        if (follower) {
            ReplicatedStateMachineDemo.disableElections(this.ch);
        }
        this.ch.setReceiver((Receiver)this);
        try {
            this.ch.connect("rsm");
            Util.registerChannel((JChannel)this.rsm.channel(), (String)"rsm");
            this.rsm.addRoleChangeListener(this);
            this.rsm.addNotificationListener(new ReplicatedStateMachine.Notification<String, Object>(){

                @Override
                public void put(String key, Object val, Object old_val) {
                    System.out.printf("-- put(%s, %s) -> %s\n", key, val, old_val);
                }

                @Override
                public void remove(String key, Object old_val) {
                    System.out.printf("-- remove(%s) -> %s\n", key, old_val);
                }
            });
            this.loop();
            JmxConfigurator.unregisterChannel((JChannel)this.rsm.channel(), (MBeanServer)Util.getMBeanServer(), (String)"rsm");
        }
        finally {
            Util.close((Closeable)this.ch);
        }
    }

    protected static void disableElections(JChannel ch) {
        ELECTION election = (ELECTION)ch.getProtocolStack().findProtocol(ELECTION.class);
        if (election != null) {
            election.noElections(true);
        }
    }

    protected void loop() {
        boolean looping = true;
        while (looping) {
            int input = Util.keyPress((String)("[1] add [2] get [3] remove [4] show all [5] dump log [6] snapshot [7] put N [x] exit\nfirst-applied=" + this.firstApplied() + ", last-applied=" + this.rsm.lastApplied() + ", commit-index=" + this.rsm.commitIndex() + ", log size=" + Util.printBytes((long)this.logSize()) + "\n"));
            switch (input) {
                case 49: {
                    this.put(ReplicatedStateMachineDemo.read("key"), ReplicatedStateMachineDemo.read("value"));
                    break;
                }
                case 50: {
                    this.get(ReplicatedStateMachineDemo.read("key"));
                    break;
                }
                case 51: {
                    this.remove(ReplicatedStateMachineDemo.read("key"));
                    break;
                }
                case 52: {
                    System.out.println(this.rsm + "\n");
                    break;
                }
                case 53: {
                    this.dumpLog();
                    break;
                }
                case 54: {
                    try {
                        this.rsm.snapshot();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case 55: {
                    try {
                        int num = Util.readIntFromStdin((String)"num: ");
                        System.out.println("");
                        String value = "hello world #";
                        int print = num / 10;
                        long start = System.currentTimeMillis();
                        for (int i = 1; i <= num; ++i) {
                            this.put("key-" + i, value + i);
                            if (i <= 0 || i % print != 0) continue;
                            System.out.println("-- count=" + i);
                        }
                        long diff = System.currentTimeMillis() - start;
                        System.out.println("\n" + num + " puts took " + diff + " ms; " + (double)num / ((double)diff / 1000.0) + " ops /sec\n");
                    }
                    catch (Throwable throwable) {}
                    break;
                }
                case 120: {
                    looping = false;
                }
            }
        }
    }

    protected void put(String key, String value) {
        if (key == null || value == null) {
            System.err.printf("Key (%s) or value (%s) is null\n", key, value);
            return;
        }
        try {
            this.rsm.put(key, value);
        }
        catch (Throwable t) {
            System.err.println("failed setting " + key + "=" + value + ": " + t);
        }
    }

    protected void get(String key) {
        Object val = this.rsm.get(key);
        System.out.printf("-- get(%s) -> %s\n", key, val);
    }

    protected void remove(String key) {
        try {
            this.rsm.remove(key);
        }
        catch (Exception ex) {
            System.err.println("failed removing " + key + ": " + ex);
        }
    }

    protected static String read(String name) {
        try {
            return Util.readStringFromStdin((String)(name + ": "));
        }
        catch (Exception e) {
            return null;
        }
    }

    protected int firstApplied() {
        RAFT raft = (RAFT)this.rsm.channel().getProtocolStack().findProtocol(RAFT.class);
        return raft.log().firstAppended();
    }

    protected int logSize() {
        return this.rsm.logSize();
    }

    protected void dumpLog() {
        System.out.println("\nindex (term): command\n---------------------");
        this.rsm.dumpLog();
        System.out.println("");
    }

    public void viewAccepted(View view) {
        System.out.println("-- view change: " + view);
    }

    @Override
    public void roleChanged(Role role) {
        System.out.println("-- changed role to " + (Object)((Object)role));
    }

    public static void main(String[] args) throws Exception {
        String props = "raft.xml";
        String name = null;
        boolean follower = false;
        long timeout = 3000L;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-props")) {
                props = args[++i];
                continue;
            }
            if (args[i].equals("-name")) {
                name = args[++i];
                continue;
            }
            if (args[i].equals("-follower")) {
                follower = true;
                continue;
            }
            if (args[i].equals("-timeout")) {
                timeout = Long.parseLong(args[++i]);
                continue;
            }
            System.out.println("ReplicatedStateMachine [-props <config>] [-name <name>] [-follower] [-timeout timeout]");
            return;
        }
        new ReplicatedStateMachineDemo().start(props, name, follower, timeout);
    }
}

