/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.raft.util;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.jgroups.annotations.Property;
import org.jgroups.annotations.Unsupported;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

public class PropsToAsciidoc {
    public static void main(String[] args) {
        if (args.length != 1) {
            PropsToAsciidoc.help();
            System.err.println("args[0]=" + args[0]);
            return;
        }
        String prot_file = args[0];
        String temp_file = prot_file + ".tmp";
        try {
            File f = new File(temp_file);
            PropsToAsciidoc.copy(new FileReader(new File(prot_file)), new FileWriter(f));
            String s = PropsToAsciidoc.fileToString(f);
            Set classes = Util.findClassesAssignableFrom((String)"org.jgroups.protocols.raft", Protocol.class);
            Properties props = new Properties();
            for (Class clazz : classes) {
                PropsToAsciidoc.convertProtocolToAsciidocTable(props, clazz);
            }
            String result = Util.replaceProperties((String)s, (Properties)props);
            FileWriter fw = new FileWriter(f, false);
            fw.write(result);
            fw.flush();
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void help() {
        System.out.println("PropsToAsciidoc <path to protocols.adoc file>");
    }

    protected static void convertUnsupportedToAsciidocTable(Properties props, List<Class<?>> clazzes, String title) throws ParserConfigurationException, TransformerException {
        ArrayList<String[]> rows = new ArrayList<String[]>(clazzes.size() + 1);
        rows.add(new String[]{"Package", "Class"});
        for (Class<?> clazz : clazzes) {
            rows.add(new String[]{clazz.getPackage().getName(), clazz.getSimpleName()});
        }
        String tmp = PropsToAsciidoc.createAsciidocTable(rows, title, "[align=\"left\",width=\"50%\",options=\"header\"]");
        if (clazzes.size() > 1) {
            props.put(title, tmp);
        }
    }

    protected static String createAsciidocTable(List<String[]> rows, String title, String header) throws ParserConfigurationException, TransformerException {
        StringBuilder sb = new StringBuilder(".").append(title).append("\n");
        sb.append(header).append("\n");
        sb.append("|=================\n");
        for (String[] row : rows) {
            for (String el : row) {
                sb.append("|").append(el);
            }
            sb.append("\n");
        }
        sb.append("|=================\n");
        return sb.toString();
    }

    private static void convertProtocolToAsciidocTable(Properties props, Class<Protocol> clazz) throws Exception {
        Method[] methods;
        String desc;
        Property annotation;
        Field[] fields;
        boolean isUnsupported = clazz.isAnnotationPresent(Unsupported.class);
        if (isUnsupported) {
            return;
        }
        TreeMap<String, String> nameToDescription = new TreeMap<String, String>();
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Property.class)) continue;
            String property = field.getName();
            annotation = field.getAnnotation(Property.class);
            desc = annotation.description();
            nameToDescription.put(property, desc);
        }
        for (Method method : methods = clazz.getDeclaredMethods()) {
            String name;
            if (!method.isAnnotationPresent(Property.class)) continue;
            annotation = method.getAnnotation(Property.class);
            desc = annotation.description();
            if (desc == null || desc.isEmpty()) {
                desc = "n/a";
            }
            if ((name = annotation.name()).length() < 1) {
                name = Util.methodNameToAttributeName((String)method.getName());
            }
            nameToDescription.put(name, desc);
        }
        if (nameToDescription.isEmpty()) {
            return;
        }
        ArrayList<String[]> rows = new ArrayList<String[]>(nameToDescription.size() + 1);
        rows.add(new String[]{"Name", "Description"});
        for (Map.Entry entry : nameToDescription.entrySet()) {
            rows.add(new String[]{(String)entry.getKey(), (String)entry.getValue()});
        }
        String tmp = PropsToAsciidoc.createAsciidocTable(rows, clazz.getSimpleName(), "[align=\"left\",width=\"90%\",cols=\"2,10\",options=\"header\"]");
        props.put(clazz.getSimpleName(), tmp);
    }

    private static String fileToString(File f) throws Exception {
        StringWriter output = new StringWriter();
        FileReader input = new FileReader(f);
        char[] buffer = new char[8192];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        return output.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(Reader input, Writer output) throws IOException {
        char[] buffer = new char[8192];
        int count = 0;
        int n = 0;
        try {
            while (-1 != (n = input.read(buffer))) {
                output.write(buffer, 0, n);
                count += n;
            }
        }
        finally {
            output.flush();
            output.close();
        }
        return count;
    }
}

