/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.perf;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.HdrHistogram.AbstractHistogram;
import org.HdrHistogram.Histogram;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.Version;
import org.jgroups.View;
import org.jgroups.annotations.Property;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.blocks.atomic.SyncCounter;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.perf.AsyncCounterBenchmark;
import org.jgroups.perf.CounterBenchmark;
import org.jgroups.perf.HistogramUtil;
import org.jgroups.perf.SyncBenchmark;
import org.jgroups.protocols.TP;
import org.jgroups.raft.blocks.CounterService;
import org.jgroups.tests.perf.PerfUtil;
import org.jgroups.util.Bits;
import org.jgroups.util.DefaultThreadFactory;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.jgroups.util.Streamable;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.Util;

public class CounterPerf
implements Receiver {
    private JChannel channel;
    private Address local_addr;
    private RpcDispatcher disp;
    static final String groupname = "counter-perf";
    protected final List<Address> members = new ArrayList<Address>();
    protected volatile View view;
    protected volatile boolean looping = true;
    protected ThreadFactory thread_factory;
    protected CounterService counter_service;
    protected SyncCounter counter;
    private volatile String histogramPath;
    @Property
    protected int num_threads = 100;
    @Property
    protected int time = 30;
    @Property
    protected boolean print_updaters;
    @Property
    protected boolean print_details;
    @Property
    protected long timeout = 60000L;
    @Property
    protected int range = 10;
    @Property
    protected String benchmark = "sync";
    private static final Method[] METHODS = new Method[4];
    private static final short START = 0;
    private static final short GET_CONFIG = 1;
    private static final short SET = 2;
    private static final short QUIT_ALL = 3;
    protected static final Field NUM_THREADS;
    protected static final Field TIME;
    protected static final Field TIMEOUT;
    protected static final Field PRINT_INVOKERS;
    protected static final Field PRINT_DETAILS;
    protected static final Field RANGE;
    protected static final Field BENCHMARK;
    protected static final String COUNTER = "counter";
    protected static final String format = "[1] Start test [2] View [4] Threads (%d) [6] Time (%s) [r] Range (%d)\n[t] incr timeout (%s) [d] details (%b)  [i] print updaters (%b)\n[b] benchmark mode (%s)\n[v] Version [x] Exit [X] Exit all %s";
    private static final Map<String, Supplier<CounterBenchmark>> BENCHMARKS_MODES;

    public void init(String props, String name, int bind_port, boolean use_fibers, String histogram_path) throws Throwable {
        this.histogramPath = histogram_path;
        if (this.histogramPath != null) {
            System.out.println("Histogram enabled! Will be stored into " + this.histogramPath);
        }
        this.thread_factory = new DefaultThreadFactory("updater", false, true).useFibers(use_fibers);
        if (use_fibers && Util.fibersAvailable()) {
            System.out.println("-- using fibers instead of threads");
        }
        this.channel = new JChannel(props).setName(name);
        if (bind_port > 0) {
            TP transport = this.channel.getProtocolStack().getTransport();
            transport.setBindPort(bind_port);
        }
        this.disp = new RpcDispatcher(this.channel, (Object)this).setReceiver((Receiver)this).setMethodLookup(id -> METHODS[id]);
        this.counter_service = new CounterService(this.channel).raftId(name).replTimeout(this.timeout);
        this.channel.connect(groupname);
        this.local_addr = this.channel.getAddress();
        if (this.members.size() < 2) {
            return;
        }
        Address coord = this.members.get(0);
        PerfUtil.Config config = (PerfUtil.Config)this.disp.callRemoteMethod(coord, new MethodCall(1, new Object[0]), new RequestOptions(ResponseMode.GET_ALL, 5000L));
        if (config != null) {
            this.applyConfig(config);
            System.out.println("Fetched config from " + coord + ": " + config + "\n");
        } else {
            System.err.println("failed to fetch config from " + coord);
        }
    }

    void stop() {
        Util.close((Closeable[])new Closeable[]{this.disp, this.channel});
    }

    protected void stopEventLoop() {
        this.looping = false;
        Util.close((Closeable)this.channel);
    }

    public void viewAccepted(View new_view) {
        this.view = new_view;
        System.out.println("** view: " + new_view);
        this.members.clear();
        this.members.addAll(new_view.getMembers());
    }

    public UpdateResult startTest() throws Throwable {
        System.out.printf("running for %d seconds\n", this.time);
        Supplier<CounterBenchmark> benchmarkSupplier = BENCHMARKS_MODES.get(this.benchmark.toLowerCase());
        if (benchmarkSupplier == null) {
            String msg = String.format("Benchmark %s not found!", this.benchmark);
            System.out.println(msg);
            throw new IllegalArgumentException(msg);
        }
        try (CounterBenchmark bm = benchmarkSupplier.get();){
            bm.init(this.num_threads, (java.util.concurrent.ThreadFactory)this.thread_factory, this::getDelta, this.counter);
            long start = System.currentTimeMillis();
            bm.start();
            long interval = (long)((double)this.time * 1000.0 / 10.0);
            for (int i = 1; i <= 10; ++i) {
                Util.sleep((long)interval);
                System.out.printf("%d: %s\n", i, CounterPerf.printAverage(start, bm));
            }
            bm.stop();
            bm.join();
            long total_time = System.currentTimeMillis() - start;
            System.out.println();
            Histogram avg_incrs = bm.getResults(this.print_updaters, avgMinMax -> CounterPerf.print(avgMinMax, this.print_details));
            if (this.print_updaters) {
                System.out.printf("\navg over all updaters: %s\n", CounterPerf.print((AbstractHistogram)avg_incrs, this.print_details));
            }
            System.out.printf("\ndone (in %s ms)\n", total_time);
            if (this.histogramPath != null) {
                String fileName = String.format("histogram_%s_%s.hgrm", this.counter_service.raftId(), this.benchmark);
                Path filePath = Path.of(this.histogramPath, fileName);
                System.out.println("Storing histogram to " + filePath.toAbsolutePath());
                try {
                    HistogramUtil.writeTo((AbstractHistogram)avg_incrs, filePath.toFile());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            UpdateResult updateResult = new UpdateResult(bm.getTotalUpdates(), total_time, avg_incrs);
            return updateResult;
        }
    }

    public void quitAll() {
        System.out.println("-- received quitAll(): shutting down");
        this.stopEventLoop();
        System.exit(0);
    }

    protected static String printAverage(long start_time, CounterBenchmark benchmark) {
        long tmp_time = System.currentTimeMillis() - start_time;
        long incrs = benchmark.getTotalUpdates();
        double incrs_sec = (double)incrs / ((double)tmp_time / 1000.0);
        return String.format("%,.0f updates/sec (%,d updates)", incrs_sec, incrs);
    }

    public void set(String field_name, Object value) {
        Field field = Util.getField(this.getClass(), (String)field_name);
        if (field == null) {
            System.err.println("Field " + field_name + " not found");
        } else {
            Util.setField((Field)field, (Object)this, (Object)value);
            System.out.println(field.getName() + "=" + value);
        }
    }

    public PerfUtil.Config getConfig() {
        PerfUtil.Config config = new PerfUtil.Config();
        for (Field field : Util.getAllDeclaredFieldsWithAnnotations(CounterPerf.class, (Class[])new Class[]{Property.class})) {
            if (!field.isAnnotationPresent(Property.class)) continue;
            config.add(field.getName(), Util.getField((Field)field, (Object)this));
        }
        return config;
    }

    protected void applyConfig(PerfUtil.Config config) {
        for (Map.Entry entry : config.values().entrySet()) {
            Field field = Util.getField(this.getClass(), (String)((String)entry.getKey()));
            Util.setField((Field)field, (Object)this, entry.getValue());
        }
    }

    public void eventLoop() {
        long cnt = 0L;
        while (this.looping) {
            try {
                boolean counter_available;
                try {
                    cnt = this.getCounter();
                    counter_available = true;
                }
                catch (Throwable t) {
                    counter_available = false;
                }
                int c = Util.keyPress((String)String.format(format, this.num_threads, Util.printTime((double)this.time, (TimeUnit)TimeUnit.MILLISECONDS), this.range, Util.printTime((double)this.timeout, (TimeUnit)TimeUnit.MILLISECONDS), this.print_details, this.print_updaters, this.benchmark, counter_available ? String.format(" (counter=%d)\n", cnt) : "\n"));
                switch (c) {
                    case 49: {
                        this.startBenchmark();
                        break;
                    }
                    case 50: {
                        this.printView();
                        break;
                    }
                    case 52: {
                        this.changeFieldAcrossCluster(NUM_THREADS, Util.readIntFromStdin((String)"Number of updater threads: "));
                        break;
                    }
                    case 54: {
                        this.changeFieldAcrossCluster(TIME, Util.readIntFromStdin((String)"Time (secs): "));
                        break;
                    }
                    case 100: {
                        this.changeFieldAcrossCluster(PRINT_DETAILS, !this.print_details);
                        break;
                    }
                    case 105: {
                        this.changeFieldAcrossCluster(PRINT_INVOKERS, !this.print_updaters);
                        break;
                    }
                    case 116: {
                        this.changeFieldAcrossCluster(TIMEOUT, Util.readIntFromStdin((String)"update timeout (ms): "));
                        break;
                    }
                    case 114: {
                        this.changeFieldAcrossCluster(RANGE, Util.readIntFromStdin((String)"range: "));
                        break;
                    }
                    case 98: {
                        this.changeFieldAcrossCluster(BENCHMARK, Util.readStringFromStdin((String)"benchmark mode: "));
                        break;
                    }
                    case 118: {
                        System.out.printf("Version: %s, Java version: %s\n", Version.printVersion(), System.getProperty("java.vm.version", "n/a"));
                        break;
                    }
                    case -1: 
                    case 120: {
                        this.looping = false;
                        break;
                    }
                    case 88: {
                        try {
                            RequestOptions options = new RequestOptions(ResponseMode.GET_NONE, 0L).flags(new Message.Flag[]{Message.Flag.OOB, Message.Flag.DONT_BUNDLE, Message.Flag.NO_FC});
                            this.disp.callRemoteMethods(null, new MethodCall(3, new Object[0]), options);
                        }
                        catch (Throwable t) {
                            System.err.println("Calling quitAll() failed: " + t);
                        }
                        break;
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        this.stop();
    }

    void startBenchmark() {
        RspList responses;
        try {
            RequestOptions options = new RequestOptions(ResponseMode.GET_ALL, 0L).flags(new Message.Flag[]{Message.Flag.OOB, Message.Flag.DONT_BUNDLE, Message.Flag.NO_FC});
            responses = this.disp.callRemoteMethods(null, new MethodCall(0, new Object[0]), options);
        }
        catch (Throwable t) {
            System.err.println("starting the benchmark failed: " + t);
            return;
        }
        long total_incrs = 0L;
        long total_time = 0L;
        Histogram globalHistogram = null;
        System.out.println("\n======================= Results: ===========================");
        for (Map.Entry entry : responses.entrySet()) {
            Address mbr = (Address)entry.getKey();
            Rsp rsp = (Rsp)entry.getValue();
            UpdateResult result = (UpdateResult)rsp.getValue();
            if (result != null) {
                total_incrs += result.num_updates;
                total_time += result.total_time;
                if (globalHistogram == null) {
                    globalHistogram = result.histogram;
                } else {
                    globalHistogram.add((AbstractHistogram)result.histogram);
                }
            }
            System.out.println(mbr + ": " + result);
        }
        double total_reqs_sec = (double)total_incrs / ((double)total_time / 1000.0);
        System.out.println("\n");
        System.out.println(Util.bold((String)String.format("Throughput: %,.2f updates/sec/node\nTime:       %s / update\n", total_reqs_sec, CounterPerf.print(globalHistogram, this.print_details))));
        System.out.println("\n\n");
    }

    protected void changeFieldAcrossCluster(Field field, Object value) throws Exception {
        this.disp.callRemoteMethods(null, new MethodCall(2, new Object[]{field.getName(), value}), RequestOptions.SYNC());
    }

    protected void printView() {
        System.out.printf("\n-- local: %s, view: %s\n", this.local_addr, this.view);
        try {
            System.in.skip(System.in.available());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static String print(AbstractHistogram histogram, boolean details) {
        double avg = histogram.getMean();
        return details ? String.format("min/avg/max = %d/%f/%s", histogram.getMinValue(), avg, histogram.getMaxValue()) : String.format("%s", Util.printTime((double)avg, (TimeUnit)TimeUnit.NANOSECONDS));
    }

    protected long getCounter() throws Exception {
        if (this.counter == null) {
            this.counter = this.counter_service.getOrCreateCounter(COUNTER, 0L);
        }
        return this.counter.get();
    }

    protected int getDelta() {
        long random = Util.random((long)this.range);
        int retval = (int)(CounterPerf.tossWeightedCoin(0.5) ? -random : random);
        if (retval < 0 && this.counter.getLocal() < 0L) {
            retval = -retval;
        }
        return retval;
    }

    public static boolean tossWeightedCoin(double probability) {
        long cutoff;
        if (probability >= 1.0) {
            return true;
        }
        if (probability <= 0.0) {
            return false;
        }
        long r = Util.random((long)1000L);
        return r <= (cutoff = (long)(probability * 1000.0));
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        block12: {
            String props = null;
            String name = null;
            String histogram_path = null;
            boolean run_event_loop = true;
            boolean use_fibers = true;
            int port = 0;
            for (int i = 0; i < args.length; ++i) {
                if ("-props".equals(args[i])) {
                    props = args[++i];
                    continue;
                }
                if ("-name".equals(args[i])) {
                    name = args[++i];
                    continue;
                }
                if ("-nohup".equals(args[i])) {
                    run_event_loop = false;
                    continue;
                }
                if ("-port".equals(args[i])) {
                    port = Integer.parseInt(args[++i]);
                    continue;
                }
                if ("-use_fibers".equals(args[i])) {
                    use_fibers = Boolean.parseBoolean(args[++i]);
                    continue;
                }
                if ("-histogram".equals(args[i])) {
                    histogram_path = args[++i];
                    continue;
                }
                CounterPerf.help();
                return;
            }
            if (name == null) {
                throw new IllegalArgumentException("name (raft-id) must be set");
            }
            CounterPerf test = null;
            try {
                test = new CounterPerf();
                test.init(props, name, port, use_fibers, histogram_path);
                if (run_event_loop) {
                    test.eventLoop();
                    break block12;
                }
                while (true) {
                    Util.sleep((long)60000L);
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                if (test == null) break block12;
                test.stop();
            }
        }
    }

    static void help() {
        System.out.println("CounterPerf [-props <props>] [-name name] [-nohup] [-port <bind port>] [-use_fibers <true|false>] [-histogram /path/to/write/log]");
    }

    static {
        BENCHMARKS_MODES = new HashMap<String, Supplier<CounterBenchmark>>();
        try {
            CounterPerf.METHODS[0] = CounterPerf.class.getMethod("startTest", new Class[0]);
            CounterPerf.METHODS[1] = CounterPerf.class.getMethod("getConfig", new Class[0]);
            CounterPerf.METHODS[2] = CounterPerf.class.getMethod("set", String.class, Object.class);
            CounterPerf.METHODS[3] = CounterPerf.class.getMethod("quitAll", new Class[0]);
            NUM_THREADS = Util.getField(CounterPerf.class, (String)"num_threads", (boolean)true);
            TIME = Util.getField(CounterPerf.class, (String)"time", (boolean)true);
            TIMEOUT = Util.getField(CounterPerf.class, (String)"timeout", (boolean)true);
            PRINT_INVOKERS = Util.getField(CounterPerf.class, (String)"print_updaters", (boolean)true);
            PRINT_DETAILS = Util.getField(CounterPerf.class, (String)"print_details", (boolean)true);
            RANGE = Util.getField(CounterPerf.class, (String)"range", (boolean)true);
            BENCHMARK = Util.getField(CounterPerf.class, (String)"benchmark", (boolean)true);
            PerfUtil.init();
            ClassConfigurator.addIfAbsent((short)1050, UpdateResult.class);
            BENCHMARKS_MODES.put("sync", SyncBenchmark::new);
            BENCHMARKS_MODES.put("async", AsyncCounterBenchmark::new);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static class UpdateResult
    implements Streamable {
        protected long num_updates;
        protected long total_time;
        protected Histogram histogram;

        public UpdateResult() {
        }

        public UpdateResult(long num_updates, long total_time, Histogram histogram) {
            this.num_updates = num_updates;
            this.total_time = total_time;
            this.histogram = histogram;
        }

        public void writeTo(DataOutput out) throws IOException {
            Bits.writeLongCompressed((long)this.num_updates, (DataOutput)out);
            Bits.writeLongCompressed((long)this.total_time, (DataOutput)out);
            Util.objectToStream((Object)this.histogram, (DataOutput)out);
        }

        public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
            this.num_updates = Bits.readLongCompressed((DataInput)in);
            this.total_time = Bits.readLongCompressed((DataInput)in);
            this.histogram = (Histogram)Util.objectFromStream((DataInput)in);
        }

        public String toString() {
            double total_reqs_per_sec = (double)this.num_updates / ((double)this.total_time / 1000.0);
            return String.format("%,.2f updates/sec (%,d updates, %s / update)", total_reqs_per_sec, this.num_updates, Util.printTime((double)this.histogram.getMean(), (TimeUnit)TimeUnit.NANOSECONDS));
        }
    }
}

