/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.perf;

import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadFactory;
import java.util.function.Function;
import java.util.function.LongSupplier;
import org.HdrHistogram.AbstractHistogram;
import org.HdrHistogram.Histogram;
import org.jgroups.blocks.atomic.Counter;
import org.jgroups.blocks.atomic.SyncCounter;
import org.jgroups.perf.CounterBenchmark;
import org.jgroups.perf.HistogramUtil;
import org.jgroups.raft.Options;

public class SyncBenchmark
implements CounterBenchmark {
    private BenchmarkRun benchmarkRun;

    @Override
    public void init(int concurrency, ThreadFactory threadFactory, LongSupplier deltaSupplier, Counter counter) {
        this.benchmarkRun = new BenchmarkRun(concurrency, counter.sync(), threadFactory, deltaSupplier);
    }

    @Override
    public void start() {
        this.benchmarkRun.start();
    }

    @Override
    public void stop() {
        this.benchmarkRun.stop();
    }

    @Override
    public void join() throws InterruptedException {
        this.benchmarkRun.join();
    }

    @Override
    public long getTotalUpdates() {
        return Arrays.stream(this.benchmarkRun.updaters).filter(Objects::nonNull).mapToLong(Updater::numUpdates).sum();
    }

    @Override
    public Histogram getResults(boolean printUpdaters, Function<AbstractHistogram, String> timePrinter) {
        Histogram global = HistogramUtil.create();
        Arrays.stream(this.benchmarkRun.updaters).filter(Objects::nonNull).map(updater -> {
            if (printUpdaters) {
                System.out.printf("updater %s: updates %s\n", updater.thread.getId(), timePrinter.apply((AbstractHistogram)updater.histogram));
            }
            return updater.histogram;
        }).forEach(arg_0 -> ((Histogram)global).add(arg_0));
        return global;
    }

    @Override
    public void close() throws Exception {
        this.stop();
        Arrays.stream(this.benchmarkRun.updaters).map(updater -> updater.thread).forEach(Thread::interrupt);
        this.benchmarkRun = null;
    }

    private static class Updater
    implements Runnable {
        final CountDownLatch latch;
        final SyncCounter counter;
        final LongSupplier deltaSupplier;
        final Thread thread;
        long num_updates;
        volatile boolean running = true;
        final Histogram histogram = HistogramUtil.create();

        public Updater(CountDownLatch latch, SyncCounter counter, LongSupplier deltaSupplier, ThreadFactory threadFactory) {
            this.latch = latch;
            this.counter = (SyncCounter)counter.withOptions(Options.create(true));
            this.deltaSupplier = deltaSupplier;
            this.thread = threadFactory.newThread(this);
        }

        public long numUpdates() {
            return this.num_updates;
        }

        public void stop() {
            this.running = false;
        }

        @Override
        public void run() {
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            while (this.running) {
                try {
                    long delta = this.deltaSupplier.getAsLong();
                    long start = System.nanoTime();
                    this.counter.addAndGet(delta);
                    long incr_time = System.nanoTime() - start;
                    this.histogram.recordValue(incr_time);
                    ++this.num_updates;
                }
                catch (Throwable t) {
                    if (!this.running) continue;
                    t.printStackTrace();
                }
            }
        }
    }

    private static class BenchmarkRun {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final Updater[] updaters;

        BenchmarkRun(int numberOfThreads, SyncCounter counter, ThreadFactory threadFactory, LongSupplier deltaSupplier) {
            this.updaters = new Updater[numberOfThreads];
            for (int i = 0; i < this.updaters.length; ++i) {
                this.updaters[i] = new Updater(this.countDownLatch, counter, deltaSupplier, threadFactory);
                this.updaters[i].thread.setName("updater-" + i);
                this.updaters[i].thread.start();
            }
        }

        void start() {
            this.countDownLatch.countDown();
        }

        void stop() {
            Arrays.stream(this.updaters).filter(Objects::nonNull).forEach(Updater::stop);
        }

        void join() throws InterruptedException {
            for (Updater updater : this.updaters) {
                updater.thread.join();
            }
        }
    }
}

