/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.raft;

import java.util.function.Supplier;
import org.jgroups.Address;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.ObjectMessage;
import org.jgroups.protocols.raft.AppendEntriesRequest;
import org.jgroups.protocols.raft.AppendResult;
import org.jgroups.protocols.raft.RAFT;
import org.jgroups.protocols.raft.RaftImpl;
import org.jgroups.raft.util.CommitTable;
import org.jgroups.raft.util.RequestTable;
import org.jgroups.util.ExtendedUUID;
import org.jgroups.util.Util;

public class Leader
extends RaftImpl {
    protected final Supplier<Integer> majority = () -> this.raft.majority();

    public Leader(RAFT raft) {
        super(raft);
    }

    @Override
    public void init() {
        super.init();
        this.raft.createRequestTable();
        this.raft.createCommitTable();
    }

    @Override
    public void destroy() {
        super.destroy();
        this.raft.request_table = null;
        this.raft.commit_table = null;
    }

    @Override
    public void handleAppendEntriesResponse(Address sender, long term, AppendResult result) {
        RequestTable<String> reqtab = this.raft.request_table;
        if (reqtab == null) {
            throw new IllegalStateException("request table cannot be null in leader");
        }
        ExtendedUUID uuid = (ExtendedUUID)sender;
        String sender_raft_id = Util.bytesToString((byte[])uuid.get(RAFT.raft_id_key));
        this.raft.getLog().trace("%s: received AppendEntries response from %s for term %d: %s", new Object[]{this.raft.getAddress(), sender, term, result});
        switch (result.result) {
            case OK: {
                this.raft.commit_table.update(sender, result.index(), result.index() + 1L, result.commit_index, false);
                if (!reqtab.add(result.index, sender_raft_id, this.majority)) break;
                this.raft.commitLogTo(result.index, true);
                if (!this.raft.send_commits_immediately) break;
                this.sendCommitMessageToFollowers();
                break;
            }
            case FAIL_ENTRY_NOT_FOUND: {
                this.raft.commit_table.update(sender, result.index(), result.index() + 1L, result.commit_index, true);
                break;
            }
            case FAIL_CONFLICTING_PREV_TERM: {
                this.raft.commit_table.update(sender, result.index() - 1L, result.index(), result.commit_index, true, true);
            }
        }
    }

    private void sendCommitMessageToFollowers() {
        this.raft.commit_table.forEach(this::sendCommitMessageToFollower);
    }

    private void sendCommitMessageToFollower(Address member, CommitTable.Entry entry) {
        if (this.raft.commit_index > entry.commitIndex()) {
            long cterm = this.raft.currentTerm();
            short id = this.raft.getId();
            Address leader = this.raft.getAddress();
            Message msg = new ObjectMessage(member, null).putHeader(id, (Header)new AppendEntriesRequest(leader, cterm, 0L, 0L, cterm, this.raft.commit_index));
            this.raft.down(msg);
        }
    }
}

