/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.raft.blocks;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jgroups.JChannel;
import org.jgroups.protocols.raft.InternalCommand;
import org.jgroups.protocols.raft.RAFT;
import org.jgroups.raft.RaftHandle;
import org.jgroups.raft.StateMachine;
import org.jgroups.util.Bits;
import org.jgroups.util.ByteArrayDataInputStream;
import org.jgroups.util.ByteArrayDataOutputStream;
import org.jgroups.util.Util;

public class ReplicatedStateMachine<K, V>
implements StateMachine {
    protected JChannel ch;
    protected RaftHandle raft;
    protected long repl_timeout = 20000L;
    protected final List<Notification<K, V>> listeners = new ArrayList<Notification<K, V>>();
    protected final Map<K, V> map = new HashMap();
    protected static final byte PUT = 1;
    protected static final byte REMOVE = 2;

    public ReplicatedStateMachine(JChannel ch) {
        this.ch = ch;
        this.raft = new RaftHandle(this.ch, this);
    }

    public ReplicatedStateMachine<K, V> timeout(long timeout) {
        this.repl_timeout = timeout;
        return this;
    }

    public void addRoleChangeListener(RAFT.RoleChange listener) {
        this.raft.addRoleListener(listener);
    }

    public void addNotificationListener(Notification<K, V> n) {
        if (n != null) {
            this.listeners.add(n);
        }
    }

    public void removeNotificationListener(Notification<K, V> n) {
        this.listeners.remove(n);
    }

    public void removeRoleChangeListener(RAFT.RoleChange listener) {
        this.raft.removeRoleListener(listener);
    }

    public long lastApplied() {
        return this.raft.lastApplied();
    }

    public long commitIndex() {
        return this.raft.commitIndex();
    }

    public JChannel channel() {
        return this.ch;
    }

    public void snapshot() throws Exception {
        if (this.raft != null) {
            this.raft.snapshot();
        }
    }

    public long logSize() {
        return this.raft != null ? this.raft.logSize() : 0L;
    }

    public String raftId() {
        return this.raft.raftId();
    }

    public ReplicatedStateMachine<K, V> raftId(String id) {
        this.raft.raftId(id);
        return this;
    }

    public String dumpLog() {
        StringBuilder sb = new StringBuilder();
        this.raft.logEntries((entry, index) -> {
            sb.append(index).append(" (").append(entry.term()).append("): ");
            if (entry.command() == null) {
                sb.append("<marker record>\n");
                return;
            }
            if (entry.internal()) {
                try {
                    InternalCommand cmd = (InternalCommand)Util.streamableFromByteBuffer(InternalCommand.class, (byte[])entry.command(), (int)entry.offset(), (int)entry.length());
                    sb.append("[internal] ").append(cmd);
                }
                catch (Exception ex) {
                    sb.append("[failure reading internal cmd] ").append(ex);
                }
                sb.append("\n");
                return;
            }
            ByteArrayDataInputStream in = new ByteArrayDataInputStream(entry.command(), entry.offset(), entry.length());
            try {
                byte type = in.readByte();
                switch (type) {
                    case 1: {
                        Object key = Util.objectFromStream((DataInput)in);
                        Object val = Util.objectFromStream((DataInput)in);
                        sb.append("put(").append(key).append(", ").append(val).append(")");
                        break;
                    }
                    case 2: {
                        Object key = Util.objectFromStream((DataInput)in);
                        sb.append("remove(").append(key).append(")");
                        break;
                    }
                    default: {
                        sb.append("type " + type + " is unknown");
                        break;
                    }
                }
            }
            catch (Throwable t) {
                sb.append(t);
            }
            sb.append("\n");
        });
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        Map<K, V> map = this.map;
        synchronized (map) {
            return this.map.equals(((ReplicatedStateMachine)other).map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Map<K, V> map = this.map;
        synchronized (map) {
            return this.map.hashCode();
        }
    }

    public V put(K key, V val) throws Exception {
        return this.invoke((byte)1, key, val, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        Map<K, V> map = this.map;
        synchronized (map) {
            return this.map.get(key);
        }
    }

    public V remove(K key) throws Exception {
        return this.invoke((byte)2, key, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Map<K, V> map = this.map;
        synchronized (map) {
            return this.map.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] apply(byte[] data, int offset, int length, boolean serialize_response) throws Exception {
        ByteArrayDataInputStream in = new ByteArrayDataInputStream(data, offset, length);
        byte command = in.readByte();
        switch (command) {
            case 1: {
                Object old_val;
                Object key = Util.objectFromStream((DataInput)in);
                Object val = Util.objectFromStream((DataInput)in);
                Map<K, V> map = this.map;
                synchronized (map) {
                    old_val = this.map.put(key, val);
                }
                this.notifyPut(key, val, old_val);
                return old_val == null ? null : (serialize_response ? Util.objectToByteBuffer((Object)old_val) : null);
            }
            case 2: {
                V old_val;
                Object key = Util.objectFromStream((DataInput)in);
                Map<K, V> map = this.map;
                synchronized (map) {
                    old_val = this.map.remove(key);
                }
                this.notifyRemove(key, old_val);
                return old_val == null ? null : (serialize_response ? Util.objectToByteBuffer(old_val) : null);
            }
        }
        throw new IllegalArgumentException("command " + command + " is unknown");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readContentFrom(DataInput in) throws Exception {
        int size = Bits.readIntCompressed((DataInput)in);
        HashMap<Object, Object> tmp = new HashMap<Object, Object>(size);
        for (int i = 0; i < size; ++i) {
            Object key = Util.objectFromStream((DataInput)in);
            Object val = Util.objectFromStream((DataInput)in);
            tmp.put(key, val);
        }
        Map<K, V> map = this.map;
        synchronized (map) {
            this.map.putAll(tmp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeContentTo(DataOutput out) throws Exception {
        Map<K, V> map = this.map;
        synchronized (map) {
            int size = this.map.size();
            Bits.writeIntCompressed((int)size, (DataOutput)out);
            for (Map.Entry<K, V> entry : this.map.entrySet()) {
                Util.objectToStream(entry.getKey(), (DataOutput)out);
                Util.objectToStream(entry.getValue(), (DataOutput)out);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Map<K, V> map = this.map;
        synchronized (map) {
            return this.map.toString();
        }
    }

    protected V invoke(byte command, K key, V val, boolean ignore_return_value) throws Exception {
        ByteArrayDataOutputStream out = new ByteArrayDataOutputStream(256);
        try {
            out.writeByte((int)command);
            Util.objectToStream(key, (DataOutput)out);
            if (val != null) {
                Util.objectToStream(val, (DataOutput)out);
            }
        }
        catch (Exception ex) {
            throw new Exception("serialization failure (key=" + key + ", val=" + val + ")", ex);
        }
        byte[] buf = out.buffer();
        byte[] rsp = this.raft.set(buf, 0, out.position(), this.repl_timeout, TimeUnit.MILLISECONDS);
        return (V)(ignore_return_value ? null : Util.objectFromByteBuffer((byte[])rsp));
    }

    protected void notifyPut(K key, V val, V old_val) {
        for (Notification<K, V> n : this.listeners) {
            try {
                n.put(key, val, old_val);
            }
            catch (Throwable throwable) {}
        }
    }

    protected void notifyRemove(K key, V old_val) {
        for (Notification<K, V> n : this.listeners) {
            try {
                n.remove(key, old_val);
            }
            catch (Throwable throwable) {}
        }
    }

    public static interface Notification<K, V> {
        public void put(K var1, V var2, V var3);

        public void remove(K var1, V var2);
    }
}

