/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.raft.util;

import java.io.DataInput;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.StringJoiner;
import java.util.function.Function;
import org.jgroups.Address;
import org.jgroups.protocols.raft.LevelDBLog;
import org.jgroups.protocols.raft.Log;
import org.jgroups.protocols.raft.LogEntry;
import org.jgroups.raft.blocks.CounterService;
import org.jgroups.util.ByteArrayDataInputStream;

public class AnalyzeLog {
    protected Class<? extends Log> log_class = LevelDBLog.class;
    protected Function<LogEntry, String> reader = CounterService::dumpLogEntry;
    protected Function<DataInput, String> snapshot_reader = CounterService::readAndDumpSnapshot;

    public AnalyzeLog logClass(String cl) throws ClassNotFoundException {
        this.log_class = Class.forName(cl);
        return this;
    }

    public AnalyzeLog reader(String r) throws Exception {
        Method method = AnalyzeLog.getMethod(r, LogEntry.class);
        this.reader = le -> AnalyzeLog.invoke(method, le);
        return this;
    }

    public AnalyzeLog snapshotReader(String r) throws Exception {
        Method method = AnalyzeLog.getMethod(r, DataInput.class);
        this.snapshot_reader = le -> AnalyzeLog.invoke(method, le);
        return this;
    }

    protected static Method getMethod(String name, Class<?> param) throws Exception {
        int index = name.lastIndexOf(".");
        if (index < 0) {
            throw new IllegalArgumentException(String.format("expected class.method (was %s)", name));
        }
        String cl = name.substring(0, index);
        String method_name = name.substring(index + 1);
        Class<?> clazz = Class.forName(cl);
        return clazz.getMethod(method_name, param);
    }

    protected static String invoke(Method method, Object obj) {
        try {
            return (String)method.invoke(null, obj);
        }
        catch (Exception e) {
            return e.toString();
        }
    }

    protected void analzye(String ... paths) throws Exception {
        for (String path : paths) {
            this._analyze(path);
        }
    }

    protected void _analyze(String path) throws Exception {
        try (Log l = this.createLog();){
            ByteBuffer sn;
            l.init(path, null);
            long first = l.firstAppended();
            long commit = l.commitIndex();
            long last = l.lastAppended();
            long term = l.currentTerm();
            Address votedfor = l.votedFor();
            if (this.snapshot_reader != null && (sn = l.getSnapshot()) != null) {
                ByteArrayDataInputStream snapshot = new ByteArrayDataInputStream(sn);
                System.out.printf("----------\nsnapshot: %s\n-----------\n", this.snapshot_reader.apply((DataInput)snapshot));
            }
            System.out.printf("first=%d, commit-index=%d, last-appended=%d, term=%d, voted-for=%s\n", first, commit, last, term, votedfor);
            for (long i = Math.max(1L, first); i <= last; ++i) {
                LogEntry entry;
                StringJoiner sj = new StringJoiner(",");
                if (i == first) {
                    sj.add("first");
                }
                if (i == commit) {
                    sj.add("commit-index");
                }
                if (i == last) {
                    sj.add("last-appended");
                }
                if ((entry = l.get((int)i)) == null) continue;
                String log_contents = this.reader != null ? this.reader.apply(entry) : entry.toString();
                System.out.printf("%d [%d]: %s %s\n", i, entry.term(), log_contents, sj);
            }
        }
    }

    protected Log createLog() throws Exception {
        return this.log_class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public static void main(String[] args) throws Exception {
        AnalyzeLog al = new AnalyzeLog();
        ArrayList<String> files = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-log_class")) {
                al.logClass(args[++i]);
                continue;
            }
            if (args[i].equals("-reader")) {
                al.reader(args[++i]);
                continue;
            }
            if (args[i].startsWith("-snapshot_reader")) {
                al.snapshotReader(args[++i]);
                continue;
            }
            if (args[i].startsWith("-h")) {
                System.out.printf("%s [-log_class <log class>] [-reader <class.method>] [-snapshot_reader <class.method>] [logfiles]\n", AnalyzeLog.class.getSimpleName());
                return;
            }
            files.add(args[i]);
        }
        String[] paths = files.toArray(new String[0]);
        al.analzye(paths);
    }
}

