/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.raft;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.Supplier;
import org.jgroups.Address;
import org.jgroups.Header;
import org.jgroups.protocols.raft.RaftHeader;
import org.jgroups.util.Bits;
import org.jgroups.util.Util;

public class InstallSnapshotRequest
extends RaftHeader {
    protected Address leader;
    protected long last_included_index;
    protected long last_included_term;

    public InstallSnapshotRequest() {
    }

    public InstallSnapshotRequest(long term) {
        super(term);
    }

    public InstallSnapshotRequest(long term, Address leader, long last_included_index, long last_included_term) {
        this(term);
        this.leader = leader;
        this.last_included_index = last_included_index;
        this.last_included_term = last_included_term;
    }

    public short getMagicId() {
        return 2003;
    }

    public Supplier<? extends Header> create() {
        return InstallSnapshotRequest::new;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + Util.size((Address)this.leader) + Bits.size((long)this.last_included_index) + Bits.size((long)this.last_included_term);
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        Util.writeAddress((Address)this.leader, (DataOutput)out);
        Bits.writeLongCompressed((long)this.last_included_index, (DataOutput)out);
        Bits.writeLongCompressed((long)this.last_included_term, (DataOutput)out);
    }

    @Override
    public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
        super.readFrom(in);
        this.leader = Util.readAddress((DataInput)in);
        this.last_included_index = Bits.readLongCompressed((DataInput)in);
        this.last_included_term = Bits.readLongCompressed((DataInput)in);
    }

    @Override
    public String toString() {
        return super.toString() + ", leader=" + this.leader + ", last_included_index=" + this.last_included_index + ", last_included_term=" + this.last_included_term;
    }
}

