/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.raft;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.Supplier;
import org.jgroups.Header;
import org.jgroups.protocols.raft.RaftHeader;

public class VoteResponse
extends RaftHeader {
    protected boolean result;

    public VoteResponse() {
    }

    public VoteResponse(int term, boolean result) {
        super(term);
        this.result = result;
    }

    public short getMagicId() {
        return 3001;
    }

    public Supplier<? extends Header> create() {
        return VoteResponse::new;
    }

    public boolean result() {
        return this.result;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 1;
    }

    @Override
    public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
        super.readFrom(in);
        this.result = in.readByte() == 1;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        out.writeByte(this.result ? 1 : 0);
    }

    @Override
    public String toString() {
        return super.toString() + ", result=" + this.result;
    }
}

