/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.raft.demos;

import java.io.Closeable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.jgroups.JChannel;
import org.jgroups.Receiver;
import org.jgroups.View;
import org.jgroups.logging.LogFactory;
import org.jgroups.protocols.Discovery;
import org.jgroups.protocols.FD_ALL3;
import org.jgroups.protocols.FD_SOCK;
import org.jgroups.protocols.FRAG4;
import org.jgroups.protocols.MERGE3;
import org.jgroups.protocols.MFC;
import org.jgroups.protocols.MPING;
import org.jgroups.protocols.PING;
import org.jgroups.protocols.TCP;
import org.jgroups.protocols.TCPPING;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.UDP;
import org.jgroups.protocols.UFC;
import org.jgroups.protocols.UNICAST3;
import org.jgroups.protocols.VERIFY_SUSPECT;
import org.jgroups.protocols.dns.DNS_PING;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.NAKACK2;
import org.jgroups.protocols.pbcast.STABLE;
import org.jgroups.protocols.raft.CLIENT;
import org.jgroups.protocols.raft.ELECTION;
import org.jgroups.protocols.raft.NO_DUPES;
import org.jgroups.protocols.raft.RAFT;
import org.jgroups.protocols.raft.REDIRECT;
import org.jgroups.raft.blocks.ReplicatedStateMachine;
import org.jgroups.stack.Configurator;
import org.jgroups.stack.DiagnosticsHandler;
import org.jgroups.stack.NonReflectiveProbeHandler;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.util.StackType;
import org.jgroups.util.Util;

public class ProgrammaticRSM {
    protected static final JChannel ch;
    protected static final ReplicatedStateMachine<String, Object> rsm;
    protected static final NonReflectiveProbeHandler h;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Discovery discovery;
        String name = null;
        boolean follower = false;
        long timeout = 3000L;
        String bind_addr = null;
        int bind_port = 0;
        List members = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-name")) {
                name = args[++i];
                continue;
            }
            if (args[i].equals("-follower")) {
                follower = true;
                continue;
            }
            if (args[i].equals("-timeout")) {
                timeout = Long.parseLong(args[++i]);
                continue;
            }
            if (args[i].equals("-bind_addr")) {
                bind_addr = args[++i];
                continue;
            }
            if (args[i].equals("-bind_port")) {
                bind_port = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-members")) {
                members = Util.parseCommaDelimitedStrings((String)args[++i]);
                continue;
            }
            System.out.println("ReplicatedStateMachine -members members -name name                       [-follower] [-timeout timeout] -tcp true|false]\n                       [-bind_addr addr] [-bind_port port]\n Example: -members A,B,C,D -name C");
            return;
        }
        if (members == null || members.isEmpty()) {
            throw new IllegalArgumentException("-members must be set");
        }
        if (name == null) {
            throw new IllegalArgumentException("-name must be set");
        }
        ch.setName(name);
        ProtocolStack stack = ch.getProtocolStack();
        TP transport = stack.getTransport();
        transport.registerProbeHandler((DiagnosticsHandler.ProbeHandler)h);
        InetAddress ba = bind_addr == null ? Util.getAddress((String)"site_local", (StackType)Util.getIpStackType()) : InetAddress.getByName(bind_addr);
        InetAddress diag_addr = Util.getAddress((String)"224.0.75.75", (StackType)Util.getIpStackType());
        InetAddress mcast_addr = Util.getAddress((String)"228.8.8.8", (StackType)Util.getIpStackType());
        InetAddress mping_mcast = Util.getAddress((String)"230.5.6.7", (StackType)Util.getIpStackType());
        transport.setBindAddress(ba).setBindPort(bind_port).setDiagnosticsAddr(diag_addr);
        if (transport instanceof UDP) {
            ((UDP)transport).setMulticastAddress(mcast_addr);
        }
        if ((discovery = (Discovery)stack.findProtocol(TCPPING.class)) != null) {
            ((TCPPING)discovery).initialHosts(Collections.singletonList(new InetSocketAddress(ba, 7800)));
        }
        if ((discovery = (Discovery)stack.findProtocol(MPING.class)) != null) {
            ((MPING)discovery).setMcastAddr(mping_mcast);
        }
        RAFT raft = (RAFT)stack.findProtocol(RAFT.class);
        raft.members(members).raftId(name);
        rsm.raftId(name).timeout(timeout);
        if (follower) {
            ProgrammaticRSM.disableElections(ch);
        }
        try {
            ch.connect("rsm");
            DiagnosticsHandler diag_handler = transport.getDiagnosticsHandler();
            if (diag_handler != null) {
                Set probe_handlers = diag_handler.getProbeHandlers();
                probe_handlers.removeIf(probe_handler -> {
                    String[] keys = probe_handler.supportedKeys();
                    return keys != null && Stream.of(keys).anyMatch(s -> s.startsWith("jmx"));
                });
            }
            transport.registerProbeHandler((DiagnosticsHandler.ProbeHandler)h);
            rsm.addNotificationListener(new ReplicatedStateMachine.Notification<String, Object>(){

                @Override
                public void put(String key, Object val, Object old_val) {
                    System.out.printf("-- put(%s, %s) -> %s\n", key, val, old_val);
                }

                @Override
                public void remove(String key, Object old_val) {
                    System.out.printf("-- remove(%s) -> %s\n", key, old_val);
                }
            });
            rsm.addRoleChangeListener(role -> System.out.println("-- changed role to " + role));
            ProgrammaticRSM.loop();
        }
        finally {
            Util.close((Closeable)ch);
        }
    }

    protected static JChannel create(boolean udp) throws Exception {
        ArrayList<Object> prots = new ArrayList<Object>();
        TP transport = udp ? new UDP().diagEnableUdp(true) : new TCP().diagEnableUdp(false).diagEnableTcp(true).setBindPort(7800);
        transport.setThreadPoolMaxThreads(200).setDiagnosticsEnabled(true);
        prots.add(transport);
        if (udp) {
            prots.add(new PING());
        } else {
            prots.add(new MPING());
            if (System.getProperty("jgroups.dns.dns_query") != null) {
                prots.add(new DNS_PING());
            }
            prots.add(new TCPPING());
        }
        Protocol[] rest = new Protocol[]{new MERGE3().setMinInterval(10000L).setMaxInterval(30000L), new FD_SOCK(), new FD_ALL3().setTimeout(60000L).setInterval(10000L), new VERIFY_SUSPECT(), new NAKACK2(), new UNICAST3(), new STABLE(), new NO_DUPES(), new GMS().setJoinTimeout(2000L), new UFC(), new MFC(), new FRAG4(), new ELECTION(), new RAFT(), new REDIRECT(), new CLIENT()};
        prots.addAll(Arrays.asList(rest));
        return new JChannel(prots);
    }

    protected static void disableElections(JChannel ch) {
        ELECTION election = (ELECTION)ch.getProtocolStack().findProtocol(ELECTION.class);
        if (election != null) {
            election.noElections(true);
        }
    }

    protected static void loop() {
        boolean looping = true;
        while (looping) {
            int input = Util.keyPress((String)("[1] add [2] get [3] remove [4] show all [5] dump log [6] snapshot [7] put N [x] exit\nfirst-applied=" + ProgrammaticRSM.firstApplied() + ", last-applied=" + rsm.lastApplied() + ", commit-index=" + rsm.commitIndex() + ", log size=" + Util.printBytes((double)ProgrammaticRSM.logSize()) + "\n"));
            switch (input) {
                case 49: {
                    ProgrammaticRSM.put(ProgrammaticRSM.read("key"), ProgrammaticRSM.read("value"));
                    break;
                }
                case 50: {
                    ProgrammaticRSM.get(ProgrammaticRSM.read("key"));
                    break;
                }
                case 51: {
                    ProgrammaticRSM.remove(ProgrammaticRSM.read("key"));
                    break;
                }
                case 52: {
                    System.out.println(rsm + "\n");
                    break;
                }
                case 53: {
                    ProgrammaticRSM.dumpLog();
                    break;
                }
                case 54: {
                    try {
                        rsm.snapshot();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case 55: {
                    try {
                        int num = Util.readIntFromStdin((String)"num: ");
                        System.out.println();
                        String value = "hello world #";
                        int print = num / 10;
                        long start = System.currentTimeMillis();
                        for (int i = 1; i <= num; ++i) {
                            ProgrammaticRSM.put("key-" + i, value + i);
                            if (i <= 0 || i % print != 0) continue;
                            System.out.println("-- count=" + i);
                        }
                        long diff = System.currentTimeMillis() - start;
                        System.out.println("\n" + num + " puts took " + diff + " ms; " + (double)num / ((double)diff / 1000.0) + " ops /sec\n");
                    }
                    catch (Throwable throwable) {}
                    break;
                }
                case 120: {
                    looping = false;
                }
            }
        }
    }

    protected static void put(String key, String value) {
        if (key == null || value == null) {
            System.err.printf("Key (%s) or value (%s) is null\n", key, value);
            return;
        }
        try {
            rsm.put(key, value);
        }
        catch (Throwable t) {
            System.err.println("failed setting " + key + "=" + value + ": " + t);
        }
    }

    protected static void get(String key) {
        Object val = rsm.get(key);
        System.out.printf("-- get(%s) -> %s\n", key, val);
    }

    protected static void remove(String key) {
        try {
            rsm.remove(key);
        }
        catch (Exception ex) {
            System.err.println("failed removing " + key + ": " + ex);
        }
    }

    protected static String read(String name) {
        try {
            return Util.readStringFromStdin((String)(name + ": "));
        }
        catch (Exception e) {
            return null;
        }
    }

    protected static int firstApplied() {
        RAFT raft = (RAFT)rsm.channel().getProtocolStack().findProtocol(RAFT.class);
        return raft.log().firstAppended();
    }

    protected static int logSize() {
        return rsm.logSize();
    }

    protected static void dumpLog() {
        System.out.printf("\nindex (term): command\n---------------------\n%s\n", rsm.dumpLog());
    }

    static {
        LogFactory.useJdkLogger((boolean)true);
        Configurator.skipSettingDefaultValues((boolean)true);
        boolean use_udp = Boolean.getBoolean("use.udp");
        try {
            ch = ProgrammaticRSM.create(use_udp);
            Configurator.skipSettingDefaultValues((boolean)false);
            h = new NonReflectiveProbeHandler(ch).initialize((Collection)ch.getProtocolStack().getProtocols());
            ch.setReceiver(new Receiver(){

                public void viewAccepted(View view) {
                    System.out.println("-- view change: " + view);
                }
            });
            rsm = new ReplicatedStateMachine(ch);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

