/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.raft;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.function.ObjIntConsumer;
import org.apache.commons.io.FileUtils;
import org.jgroups.Address;
import org.jgroups.protocols.raft.Log;
import org.jgroups.protocols.raft.LogEntry;
import org.jgroups.raft.filelog.LogEntryStorage;
import org.jgroups.raft.filelog.MetadataStorage;

public class FileBasedLog
implements Log {
    private final Object metadataLock = new Object();
    private volatile File logDir;
    private volatile Address votedFor;
    private volatile int commitIndex;
    private volatile int currentTerm;
    private volatile MetadataStorage metadataStorage;
    private volatile LogEntryStorage logEntryStorage;

    @Override
    public synchronized void init(String log_name, Map<String, String> args) throws Exception {
        this.logDir = new File(log_name);
        if (!this.logDir.exists() && !this.logDir.mkdirs()) {
            throw new IllegalArgumentException("Unable to create directory " + this.logDir.getAbsolutePath());
        }
        if (!this.logDir.isDirectory()) {
            throw new IllegalArgumentException("File " + this.logDir.getAbsolutePath() + " is not a directory!");
        }
        this.metadataStorage = new MetadataStorage(this.logDir);
        this.metadataStorage.open();
        this.logEntryStorage = new LogEntryStorage(this.logDir);
        this.logEntryStorage.open();
        this.commitIndex = this.metadataStorage.getCommitIndex();
        this.currentTerm = this.metadataStorage.getCurrentTerm();
        this.votedFor = this.metadataStorage.getVotedFor();
        this.logEntryStorage.reload();
    }

    @Override
    public synchronized void close() {
        try {
            LogEntryStorage entryStorage;
            MetadataStorage metadataStorage = this.metadataStorage;
            if (metadataStorage != null) {
                metadataStorage.close();
            }
            if ((entryStorage = this.logEntryStorage) != null) {
                entryStorage.close();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public synchronized void delete() {
        try {
            LogEntryStorage entryStorage;
            MetadataStorage storage = this.metadataStorage;
            if (storage != null) {
                storage.delete();
            }
            if ((entryStorage = this.logEntryStorage) != null) {
                entryStorage.delete();
            }
            if (this.logDir != null) {
                FileUtils.deleteDirectory((File)this.logDir);
                this.logDir = null;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public int currentTerm() {
        return this.currentTerm;
    }

    @Override
    public Log currentTerm(int new_term) {
        Object object = this.metadataLock;
        synchronized (object) {
            try {
                this.checkMetadataStarted().setCurrentTerm(new_term);
                this.currentTerm = new_term;
                return this;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public Address votedFor() {
        return this.votedFor;
    }

    @Override
    public Log votedFor(Address member) {
        Object object = this.metadataLock;
        synchronized (object) {
            try {
                this.checkMetadataStarted().setVotedFor(member);
                this.votedFor = member;
                return this;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public int commitIndex() {
        return this.commitIndex;
    }

    @Override
    public Log commitIndex(int new_index) {
        Object object = this.metadataLock;
        synchronized (object) {
            assert (new_index >= this.commitIndex);
            try {
                this.checkMetadataStarted().setCommitIndex(new_index);
                this.commitIndex = new_index;
                return this;
            }
            catch (IOException e) {
                throw new IllegalStateException();
            }
        }
    }

    @Override
    public int firstAppended() {
        return this.checkLogEntryStorageStarted().getFirstAppended();
    }

    @Override
    public int lastAppended() {
        return this.checkLogEntryStorageStarted().getLastAppended();
    }

    @Override
    public void append(int index, boolean overwrite, LogEntry ... entries) {
        assert (index > this.firstAppended());
        assert (index > this.commitIndex());
        LogEntryStorage storage = this.checkLogEntryStorageStarted();
        try {
            int term = storage.write(index, entries, overwrite);
            if (this.currentTerm != term) {
                this.currentTerm(term);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public LogEntry get(int index) {
        try {
            return this.checkLogEntryStorageStarted().getLogEntry(index);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public void truncate(int index) {
        assert (index > this.firstAppended());
        try {
            this.checkLogEntryStorageStarted().removeOld(index);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public synchronized void deleteAllEntriesStartingFrom(int start_index) {
        assert (start_index > this.commitIndex);
        assert (start_index >= this.firstAppended());
        LogEntryStorage storage = this.checkLogEntryStorageStarted();
        try {
            this.currentTerm(storage.removeNew(start_index));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void forEach(ObjIntConsumer<LogEntry> function, int start_index, int end_index) {
        try {
            this.checkLogEntryStorageStarted().forEach(function, start_index, end_index);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void forEach(ObjIntConsumer<LogEntry> function) {
        this.forEach(function, this.firstAppended(), this.lastAppended());
    }

    private MetadataStorage checkMetadataStarted() {
        MetadataStorage storage = this.metadataStorage;
        if (storage == null) {
            throw new IllegalStateException("Log not initialized");
        }
        return storage;
    }

    private LogEntryStorage checkLogEntryStorageStarted() {
        LogEntryStorage storage = this.logEntryStorage;
        if (storage == null) {
            throw new IllegalStateException("Log not initialized");
        }
        return storage;
    }
}

