/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.raft;

import java.io.DataInput;
import org.jgroups.Address;
import org.jgroups.EmptyMessage;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.protocols.raft.AppendEntriesResponse;
import org.jgroups.protocols.raft.AppendResult;
import org.jgroups.protocols.raft.Log;
import org.jgroups.protocols.raft.LogEntry;
import org.jgroups.protocols.raft.RAFT;
import org.jgroups.protocols.raft.RaftImpl;
import org.jgroups.protocols.raft.StateMachine;
import org.jgroups.util.ByteArrayDataInputStream;
import org.jgroups.util.Util;

public class Follower
extends RaftImpl {
    public Follower(RAFT raft) {
        super(raft);
    }

    @Override
    public void handleInstallSnapshotRequest(Message msg, int term, Address leader, int last_included_index, int last_included_term) {
        StateMachine sm = this.raft.state_machine;
        if (sm == null) {
            this.raft.getLog().error("%s: no state machine set, cannot install snapshot", new Object[]{this.raft.getAddress()});
            return;
        }
        Address sender = msg.src();
        try {
            ByteArrayDataInputStream in = new ByteArrayDataInputStream(msg.getArray(), msg.getOffset(), msg.getLength());
            sm.readContentFrom((DataInput)in);
            this.raft.doSnapshot();
            Log log = this.raft.log();
            log.append(last_included_index, true, new LogEntry(last_included_term, null));
            this.raft.last_appended = last_included_index;
            log.commitIndex(last_included_index);
            this.raft.commit_index = last_included_index;
            log.truncate(last_included_index);
            this.raft.getLog().debug("%s: applied snapshot (%s) from %s; last_appended=%d, commit_index=%d", new Object[]{this.raft.getAddress(), Util.printBytes((double)msg.getLength()), msg.src(), this.raft.lastAppended(), this.raft.commitIndex()});
            AppendResult result = new AppendResult(AppendResult.Result.OK, last_included_index).commitIndex(this.raft.commitIndex());
            Message ack = new EmptyMessage(leader).putHeader(this.raft.getId(), (Header)new AppendEntriesResponse(this.raft.currentTerm(), result));
            this.raft.getDownProtocol().down(ack);
        }
        catch (Exception ex) {
            this.raft.getLog().error("%s: failed applying snapshot from %s: %s", new Object[]{this.raft.getAddress(), sender, ex});
        }
    }
}

