/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.raft;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.function.ObjIntConsumer;
import org.apache.commons.io.FileUtils;
import org.fusesource.leveldbjni.JniDBFactory;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.DBIterator;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.WriteBatch;
import org.jgroups.Address;
import org.jgroups.logging.LogFactory;
import org.jgroups.protocols.raft.Log;
import org.jgroups.protocols.raft.LogEntry;
import org.jgroups.raft.util.IntegerHelper;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class LevelDBLog
implements Log {
    protected final org.jgroups.logging.Log log = LogFactory.getLog(this.getClass());
    private static final byte[] FIRSTAPPENDED = "FA".getBytes();
    private static final byte[] LASTAPPENDED = "LA".getBytes();
    private static final byte[] CURRENTTERM = "CT".getBytes();
    private static final byte[] COMMITINDEX = "CX".getBytes();
    private static final byte[] VOTEDFOR = "VF".getBytes();
    private DB db;
    private File dbFileName;
    private int currentTerm;
    private Address votedFor;
    private int firstAppended;
    private int commitIndex;
    private int lastAppended;

    @Override
    public void init(String log_name, Map<String, String> args) throws Exception {
        Options options = new Options().createIfMissing(true);
        this.dbFileName = new File(log_name);
        this.db = JniDBFactory.factory.open(this.dbFileName, options);
        this.log.trace("opened %s", new Object[]{this.db});
        if (this.isANewRAFTLog()) {
            this.log.trace("log %s is new, must be initialized", new Object[]{this.dbFileName});
            this.initLogWithMetadata();
        } else {
            this.log.trace("log %s exists, does not have to be initialized", new Object[]{this.dbFileName});
            this.readMetadataFromLog();
        }
        this.checkForConsistency();
    }

    @Override
    public void close() throws IOException {
        this.log.trace("closing DB: %s", new Object[]{this.db});
        if (this.db != null) {
            this.db.close();
        }
        this.currentTerm = 0;
        this.votedFor = null;
        this.commitIndex = 0;
        this.lastAppended = 0;
        this.firstAppended = 0;
    }

    @Override
    public void delete() throws IOException {
        Util.close((Closeable)this);
        this.log.trace("deleting DB directory: %s", new Object[]{this.dbFileName});
        FileUtils.deleteDirectory((File)this.dbFileName);
    }

    @Override
    public int firstAppended() {
        return this.firstAppended;
    }

    @Override
    public int commitIndex() {
        return this.commitIndex;
    }

    @Override
    public int lastAppended() {
        return this.lastAppended;
    }

    @Override
    public int currentTerm() {
        return this.currentTerm;
    }

    @Override
    public Address votedFor() {
        return this.votedFor;
    }

    @Override
    public Log commitIndex(int new_index) {
        if (new_index == this.commitIndex) {
            return this;
        }
        this.log.trace("Updating commit index: %d", new Object[]{new_index});
        this.db.put(COMMITINDEX, IntegerHelper.fromIntToByteArray(new_index));
        this.commitIndex = new_index;
        return this;
    }

    @Override
    public Log currentTerm(int new_term) {
        if (new_term == this.currentTerm) {
            return this;
        }
        this.log.trace("Updating current term: %d", new Object[]{new_term});
        this.db.put(CURRENTTERM, IntegerHelper.fromIntToByteArray(new_term));
        this.currentTerm = new_term;
        return this;
    }

    @Override
    public Log votedFor(Address member) {
        if (Objects.equals(member, this.votedFor)) {
            return this;
        }
        try {
            this.log.debug("Updating voted for: %s", new Object[]{member});
            this.db.put(VOTEDFOR, Util.objectToByteBuffer((Object)member));
            this.votedFor = member;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    @Override
    public void append(int index, boolean overwrite, LogEntry ... entries) {
        this.log.trace("Appending %d entries", new Object[]{entries.length});
        try (WriteBatch batch = this.db.createWriteBatch();){
            for (LogEntry entry : entries) {
                if (overwrite) {
                    this.appendEntry(index, entry, batch);
                } else {
                    this.appendEntryIfAbsent(index, entry, batch);
                }
                this.updateLastAppended(index, batch);
                this.updateCurrentTerm(entry.term, batch);
                this.log.trace("Flushing batch to DB: %s", new Object[]{batch});
                this.db.write(batch);
                ++index;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public LogEntry get(int index) {
        byte[] entryBytes = this.db.get(IntegerHelper.fromIntToByteArray(index));
        try {
            return entryBytes != null ? (LogEntry)Util.streamableFromByteBuffer(LogEntry.class, (byte[])entryBytes) : null;
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("getting log entry at index %d failed", index), ex);
        }
    }

    @Override
    public void forEach(ObjIntConsumer<LogEntry> function, int start_index, int end_index) {
        start_index = Math.max(start_index, Math.max(this.firstAppended, 1));
        end_index = Math.min(end_index, this.lastAppended);
        DBIterator it = this.db.iterator();
        it.seek(IntegerHelper.fromIntToByteArray(start_index));
        for (int i = start_index; i <= end_index && it.hasNext(); ++i) {
            Map.Entry e = (Map.Entry)it.next();
            try {
                LogEntry l = (LogEntry)Util.streamableFromByteBuffer(LogEntry.class, (byte[])((byte[])e.getValue()));
                function.accept(l, i);
                continue;
            }
            catch (Exception ex) {
                throw new RuntimeException("failed deserializing LogRecord", ex);
            }
        }
    }

    @Override
    public void forEach(ObjIntConsumer<LogEntry> function) {
        this.forEach(function, Math.max(1, this.firstAppended), this.lastAppended);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncate(int upto_index) {
        if (upto_index < this.firstAppended || upto_index > this.lastAppended) {
            return;
        }
        if (upto_index > this.commitIndex) {
            this.log.warn("upto_index (%d) is higher than commit-index (%d); only truncating up to %d", new Object[]{upto_index, this.commitIndex, this.commitIndex});
            upto_index = this.commitIndex;
        }
        WriteBatch batch = null;
        try {
            batch = this.db.createWriteBatch();
            for (int index = this.firstAppended; index < upto_index; ++index) {
                batch.delete(IntegerHelper.fromIntToByteArray(index));
            }
            batch.put(FIRSTAPPENDED, IntegerHelper.fromIntToByteArray(upto_index));
            this.db.write(batch);
            this.firstAppended = upto_index;
        }
        finally {
            Util.close((Closeable)batch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAllEntriesStartingFrom(int start_index) {
        if (start_index < this.firstAppended || start_index > this.lastAppended) {
            return;
        }
        WriteBatch batch = null;
        try {
            batch = this.db.createWriteBatch();
            for (int index = start_index; index <= this.lastAppended; ++index) {
                batch.delete(IntegerHelper.fromIntToByteArray(index));
            }
            LogEntry last = this.get(start_index - 1);
            if (last == null) {
                this.updateCurrentTerm(0, batch);
            } else {
                this.updateCurrentTerm(last.term, batch);
            }
            this.updateLastAppended(start_index - 1, batch);
            if (this.commitIndex > this.lastAppended) {
                this.commitIndex(this.lastAppended);
            }
            this.db.write(batch);
        }
        finally {
            Util.close((Closeable)batch);
        }
    }

    public byte[] print(byte[] bytes) {
        return this.db.get(bytes);
    }

    public void printMetadata() throws Exception {
        this.log.info("-----------------");
        this.log.info("RAFT Log Metadata");
        this.log.info("-----------------");
        byte[] firstAppendedBytes = this.db.get(FIRSTAPPENDED);
        this.log.info("First Appended: %d", new Object[]{IntegerHelper.fromByteArrayToInt(firstAppendedBytes)});
        byte[] lastAppendedBytes = this.db.get(LASTAPPENDED);
        this.log.info("Last Appended: %d", new Object[]{IntegerHelper.fromByteArrayToInt(lastAppendedBytes)});
        byte[] currentTermBytes = this.db.get(CURRENTTERM);
        this.log.info("Current Term: %d", new Object[]{IntegerHelper.fromByteArrayToInt(currentTermBytes)});
        byte[] commitIndexBytes = this.db.get(COMMITINDEX);
        this.log.info("Commit Index: %d", new Object[]{IntegerHelper.fromByteArrayToInt(commitIndexBytes)});
        Address votedForTmp = (Address)Util.objectFromByteBuffer((byte[])this.db.get(VOTEDFOR));
        this.log.info("Voted for: %s", new Object[]{votedForTmp});
    }

    public String toString() {
        return String.format("first=%d, commit=%d, last-appended=%d, term=%d (size=%d)", this.firstAppended, this.commitIndex, this.lastAppended, this.currentTerm, this.size());
    }

    private void appendEntryIfAbsent(int index, LogEntry entry, WriteBatch batch) throws Exception {
        if (this.db.get(IntegerHelper.fromIntToByteArray(index)) != null) {
            this.log.trace("Entry %d: %s can't be appended, index already present", new Object[]{index, entry});
            throw new IllegalStateException("Entry at index " + index + " already exists");
        }
        this.appendEntry(index, entry, batch);
    }

    private void appendEntry(int index, LogEntry entry, WriteBatch batch) throws Exception {
        this.log.trace("Appending entry %d: %s", new Object[]{index, entry});
        batch.put(IntegerHelper.fromIntToByteArray(index), Util.streamableToByteBuffer((Streamable)entry));
    }

    private void updateCurrentTerm(int new_term, WriteBatch batch) {
        if (new_term == this.currentTerm) {
            return;
        }
        this.log.trace("Updating currentTerm: %d", new Object[]{new_term});
        batch.put(CURRENTTERM, IntegerHelper.fromIntToByteArray(new_term));
        this.currentTerm = new_term;
    }

    private void updateLastAppended(int new_last_appended, WriteBatch batch) {
        if (new_last_appended == this.lastAppended) {
            return;
        }
        this.log.trace("Updating lastAppended: %d", new Object[]{new_last_appended});
        batch.put(LASTAPPENDED, IntegerHelper.fromIntToByteArray(new_last_appended));
        this.lastAppended = new_last_appended;
    }

    private boolean isANewRAFTLog() {
        return this.db.get(FIRSTAPPENDED) == null;
    }

    private void initLogWithMetadata() {
        this.log.debug("Initializing log with empty Metadata");
        WriteBatch batch = this.db.createWriteBatch();
        try {
            batch.put(FIRSTAPPENDED, IntegerHelper.fromIntToByteArray(0));
            batch.put(LASTAPPENDED, IntegerHelper.fromIntToByteArray(0));
            batch.put(CURRENTTERM, IntegerHelper.fromIntToByteArray(0));
            batch.put(COMMITINDEX, IntegerHelper.fromIntToByteArray(0));
            this.db.write(batch);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                batch.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void readMetadataFromLog() throws Exception {
        this.firstAppended = IntegerHelper.fromByteArrayToInt(this.db.get(FIRSTAPPENDED));
        this.lastAppended = IntegerHelper.fromByteArrayToInt(this.db.get(LASTAPPENDED));
        this.currentTerm = IntegerHelper.fromByteArrayToInt(this.db.get(CURRENTTERM));
        this.commitIndex = IntegerHelper.fromByteArrayToInt(this.db.get(COMMITINDEX));
        this.votedFor = (Address)Util.objectFromByteBuffer((byte[])this.db.get(VOTEDFOR));
        this.log.debug("read metadata from log: firstAppended=%d, lastAppended=%d, currentTerm=%d, commitIndex=%d, votedFor=%s", new Object[]{this.firstAppended, this.lastAppended, this.currentTerm, this.commitIndex, this.votedFor});
    }

    private void checkForConsistency() throws Exception {
        int loggedFirstAppended = IntegerHelper.fromByteArrayToInt(this.db.get(FIRSTAPPENDED));
        this.log.trace("FirstAppended in DB is: %d", new Object[]{loggedFirstAppended});
        int loggedLastAppended = IntegerHelper.fromByteArrayToInt(this.db.get(LASTAPPENDED));
        this.log.trace("LastAppended in DB is: %d", new Object[]{loggedLastAppended});
        int loggedCurrentTerm = IntegerHelper.fromByteArrayToInt(this.db.get(CURRENTTERM));
        this.log.trace("CurrentTerm in DB is: %d", new Object[]{loggedCurrentTerm});
        int loggedCommitIndex = IntegerHelper.fromByteArrayToInt(this.db.get(COMMITINDEX));
        this.log.trace("CommitIndex in DB is: %d", new Object[]{loggedCommitIndex});
        Address loggedVotedForAddress = (Address)Util.objectFromByteBuffer((byte[])this.db.get(VOTEDFOR));
        this.log.trace("VotedFor in DB is: %s", new Object[]{loggedVotedForAddress});
        assert (this.firstAppended == loggedFirstAppended);
        assert (this.lastAppended == loggedLastAppended);
        assert (this.currentTerm == loggedCurrentTerm);
        assert (this.commitIndex == loggedCommitIndex);
        assert (this.votedFor == null || this.votedFor.equals(loggedVotedForAddress));
        LogEntry lastAppendedEntry = this.get(this.lastAppended);
        assert (lastAppendedEntry == null || lastAppendedEntry.term <= this.currentTerm);
        assert (this.firstAppended <= this.commitIndex);
        assert (this.commitIndex <= this.lastAppended);
    }
}

