/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.raft;

import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.protocols.raft.AppendResult;
import org.jgroups.protocols.raft.Log;
import org.jgroups.protocols.raft.LogEntry;
import org.jgroups.protocols.raft.RAFT;

public abstract class RaftImpl {
    protected RAFT raft;

    public RaftImpl(RAFT raft) {
        this.raft = raft;
    }

    public RAFT raft() {
        return this.raft;
    }

    public RaftImpl raft(RAFT r) {
        this.raft = r;
        return this;
    }

    public void init() {
    }

    public void destroy() {
    }

    public AppendResult handleAppendEntriesRequest(byte[] data, int offset, int length, Address leader, int prev_index, int prev_term, int entry_term, int leader_commit, boolean internal) {
        this.raft.leader(leader);
        int curr_index = prev_index + 1;
        if (data == null || length == 0 || curr_index <= this.raft.commitIndex()) {
            this.raft.commitLogTo(leader_commit);
            return new AppendResult(AppendResult.Result.OK, this.raft.lastAppended()).commitIndex(this.raft.commitIndex());
        }
        LogEntry prev = this.raft.log_impl.get(prev_index);
        if (prev == null && prev_index > 0) {
            ++this.raft.num_failed_append_requests_not_found;
            return new AppendResult(AppendResult.Result.FAIL_ENTRY_NOT_FOUND, this.raft.lastAppended());
        }
        if (prev_index == 0 || prev.term == prev_term) {
            LogEntry existing = this.raft.log_impl.get(curr_index);
            if (existing != null && existing.term != entry_term) {
                this.raft.deleteAllLogEntriesStartingFrom(curr_index);
            }
            boolean added = this.raft.append(entry_term, curr_index, data, offset, length, internal);
            this.raft.commitLogTo(leader_commit);
            if (internal) {
                this.raft.executeInternalCommand(null, data, offset, length);
            }
            return new AppendResult(AppendResult.Result.OK, added ? curr_index : this.raft.lastAppended()).commitIndex(this.raft.commitIndex());
        }
        ++this.raft.num_failed_append_requests_wrong_term;
        int conflicting_index = this.getFirstIndexOfConflictingTerm(prev_index, prev.term);
        if (conflicting_index <= this.raft.commitIndex()) {
            this.raft.getLog().error("%s: cannot delete entries <= %d as commit_index is higher: log=%s", new Object[]{this.raft.getAddress(), conflicting_index, this.raft.log_impl});
            conflicting_index = this.raft.last_appended;
        } else {
            this.raft.deleteAllLogEntriesStartingFrom(conflicting_index);
        }
        return new AppendResult(AppendResult.Result.FAIL_CONFLICTING_PREV_TERM, conflicting_index, prev.term).commitIndex(this.raft.commitIndex());
    }

    public void handleAppendEntriesResponse(Address sender, int term, AppendResult result) {
    }

    public void handleInstallSnapshotRequest(Message msg, int term, Address leader, int last_included_index, int last_included_term) {
    }

    protected int getFirstIndexOfConflictingTerm(int start_index, int conflicting_term) {
        LogEntry entry;
        int retval;
        Log log = this.raft.log_impl;
        int first = Math.max(1, log.firstAppended());
        int last = log.lastAppended();
        int commit_index = log.commitIndex();
        int i = retval = Math.min(start_index, last);
        while (i >= first && i > commit_index && (entry = log.get(i)) != null && entry.term == conflicting_term) {
            retval = i--;
        }
        return retval;
    }
}

