/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.raft.demos;

import java.io.DataInput;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Objects;
import javax.management.MBeanServer;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Receiver;
import org.jgroups.View;
import org.jgroups.blocks.cs.BaseServer;
import org.jgroups.blocks.cs.TcpServer;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.protocols.raft.ELECTION;
import org.jgroups.protocols.raft.RAFT;
import org.jgroups.protocols.raft.Role;
import org.jgroups.raft.blocks.ReplicatedStateMachine;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.ByteArrayDataInputStream;
import org.jgroups.util.Util;

public class ReplicatedStateMachineDemo
implements org.jgroups.blocks.cs.Receiver,
RAFT.RoleChange {
    protected JChannel ch;
    protected ReplicatedStateMachine<String, Object> rsm;
    protected BaseServer server;

    public void start(String props, String name, boolean follower, long timeout, InetAddress bind_addr, int port, boolean listen, boolean nohup) throws Exception {
        this.ch = new JChannel(props).name(name);
        this.rsm = new ReplicatedStateMachine(this.ch).raftId(name).timeout(timeout);
        if (follower) {
            ReplicatedStateMachineDemo.disableElections(this.ch);
        }
        this.ch.setReceiver(new Receiver(){

            public void viewAccepted(View view) {
                System.out.println("-- view change: " + view);
            }
        });
        this.ch.connect("rsm");
        Util.registerChannel((JChannel)this.rsm.channel(), (String)"rsm");
        this.rsm.addRoleChangeListener(this);
        this.rsm.addNotificationListener(new ReplicatedStateMachine.Notification<String, Object>(){

            @Override
            public void put(String key, Object val, Object old_val) {
            }

            @Override
            public void remove(String key, Object old_val) {
                System.out.printf("-- remove(%s) -> %s\n", key, old_val);
            }
        });
        if (listen) {
            this.start(bind_addr, port);
        }
        if (!nohup) {
            this.loop();
        }
    }

    public void receive(Address sender, byte[] buf, int offset, int length) {
        ByteArrayDataInputStream in = new ByteArrayDataInputStream(buf, offset, length);
        try {
            this.receive(sender, (DataInput)in);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void receive(Address sender, ByteBuffer buf) {
        Util.bufferToArray((Address)sender, (ByteBuffer)buf, (org.jgroups.blocks.cs.Receiver)this);
    }

    public void receive(Address sender, DataInput in) throws Exception {
        byte ordinal = in.readByte();
        Command cmd = Command.values()[ordinal];
        switch (cmd) {
            case PUT: {
                String key = (String)Util.objectFromStream((DataInput)in);
                String value = (String)Util.objectFromStream((DataInput)in);
                Object retval = this.put(key, value);
                this.sendResponse(sender, retval);
                break;
            }
            case GET: {
                String key = (String)Util.objectFromStream((DataInput)in);
                Object retval = this.get(key);
                this.sendResponse(sender, retval);
                break;
            }
            case REMOVE: {
                String key = (String)Util.objectFromStream((DataInput)in);
                Object retval = this.remove(key);
                this.sendResponse(sender, retval);
                break;
            }
            case SHOW_ALL: {
                String result = this.rsm.toString();
                this.sendResponse(sender, result);
                break;
            }
            case DUMP_LOG: {
                String result = this.dumpLog();
                this.sendResponse(sender, result);
                break;
            }
            case SNAPSHOT: {
                String result = (String)this.snapshot();
                this.sendResponse(sender, result);
                break;
            }
            case GET_VIEW: {
                String result = this.getView();
                this.sendResponse(sender, result);
            }
        }
    }

    protected void start(InetAddress bind_addr, int port) throws Exception {
        this.server = new TcpServer(bind_addr, port).receiver((org.jgroups.blocks.cs.Receiver)this);
        this.server.start();
        JmxConfigurator.register((Object)this.server, (MBeanServer)Util.getMBeanServer(), (String)"rsm:name=rsm");
        int local_port = this.server.localAddress() instanceof IpAddress ? ((IpAddress)this.server.localAddress()).getPort() : 0;
        System.out.printf("\n-- %s listening at %s:%s\n\n", ReplicatedStateMachineDemo.class.getSimpleName(), bind_addr != null ? bind_addr : "0.0.0.0", local_port);
    }

    protected static void disableElections(JChannel ch) {
        ELECTION election = (ELECTION)ch.getProtocolStack().findProtocol(ELECTION.class);
        if (election != null) {
            election.noElections(true);
        }
    }

    protected void loop() {
        boolean looping = true;
        while (looping) {
            int input = Util.keyPress((String)("[1] add [2] get [3] remove [4] show all [5] dump log [6] snapshot [7] put N [x] exit\nfirst-applied=" + this.firstApplied() + ", last-applied=" + this.rsm.lastApplied() + ", commit-index=" + this.rsm.commitIndex() + ", log size=" + this.logSize() + "\n"));
            switch (input) {
                case 49: {
                    this.put(ReplicatedStateMachineDemo.read("key"), ReplicatedStateMachineDemo.read("value"));
                    break;
                }
                case 50: {
                    this.get(ReplicatedStateMachineDemo.read("key"));
                    break;
                }
                case 51: {
                    this.remove(ReplicatedStateMachineDemo.read("key"));
                    break;
                }
                case 52: {
                    System.out.println(this.rsm + "\n");
                    break;
                }
                case 53: {
                    System.out.println(this.dumpLog());
                    break;
                }
                case 54: {
                    this.snapshot();
                    break;
                }
                case 55: {
                    try {
                        int num = Util.readIntFromStdin((String)"num: ");
                        System.out.println();
                        String value = "hello world #";
                        int print = num / 10;
                        long start = System.currentTimeMillis();
                        for (int i = 1; i <= num; ++i) {
                            this.put("key-" + i, value + i);
                            if (i <= 0 || i % print != 0) continue;
                            System.out.println("-- count=" + i);
                        }
                        long diff = System.currentTimeMillis() - start;
                        System.out.println("\n" + num + " puts took " + diff + " ms; " + (double)num / ((double)diff / 1000.0) + " ops /sec\n");
                    }
                    catch (Throwable throwable) {}
                    break;
                }
                case 120: {
                    looping = false;
                }
            }
        }
    }

    protected Object put(String key, String value) {
        try {
            return this.rsm.put(Objects.requireNonNull(key, "key must be non-null)"), Objects.requireNonNull(value, "value must be non-null"));
        }
        catch (Throwable t) {
            String ret = String.format("failed setting %s=%s: %s", key, value, t);
            System.err.println(ret);
            return ret;
        }
    }

    protected Object get(String key) {
        Object val = this.rsm.get(key);
        System.out.printf("-- get(%s) -> %s\n", key, val);
        return val;
    }

    protected Object remove(String key) {
        try {
            return this.rsm.remove(key);
        }
        catch (Exception ex) {
            String err = String.format("failed removing %s: %s", key, ex);
            System.out.println(err);
            return err;
        }
    }

    protected Object snapshot() {
        try {
            this.rsm.snapshot();
            return "snapshot suceeded";
        }
        catch (Exception e) {
            return String.format("snapshot failed: %s", e);
        }
    }

    protected String getView() {
        return String.format("local address: %s\nview: %s", this.ch.getAddress(), this.ch.getView());
    }

    protected static String read(String name) {
        try {
            return Util.readStringFromStdin((String)(name + ": "));
        }
        catch (Exception e) {
            return null;
        }
    }

    protected int firstApplied() {
        RAFT raft = (RAFT)this.rsm.channel().getProtocolStack().findProtocol(RAFT.class);
        return raft.log().firstAppended();
    }

    protected int logSize() {
        return this.rsm.logSize();
    }

    protected String dumpLog() {
        return String.format("\nindex (term): command\n---------------------\n%s\n", this.rsm.dumpLog());
    }

    protected void sendResponse(Address target, Object rsp) throws Exception {
        byte[] buf = Util.objectToByteBuffer((Object)rsp);
        this.server.send(target, buf, 0, buf.length);
    }

    @Override
    public void roleChanged(Role role) {
        System.out.println("-- changed role to " + role);
    }

    public static void main(String[] args) throws Exception {
        String props = "raft.xml";
        String name = null;
        boolean follower = false;
        boolean listen = false;
        boolean nohup = false;
        long timeout = 3000L;
        InetAddress bind_addr = null;
        int port = 2065;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-props")) {
                props = args[++i];
                continue;
            }
            if (args[i].equals("-name")) {
                name = args[++i];
                continue;
            }
            if (args[i].equals("-follower")) {
                follower = true;
                continue;
            }
            if (args[i].equals("-listen")) {
                listen = true;
                continue;
            }
            if (args[i].equals("-nohup")) {
                nohup = true;
                continue;
            }
            if (args[i].equals("-timeout")) {
                timeout = Long.parseLong(args[++i]);
                continue;
            }
            if (args[i].equals("-bind_addr")) {
                bind_addr = InetAddress.getByName(args[++i]);
                continue;
            }
            if (args[i].equals("-port")) {
                port = Integer.parseInt(args[++i]);
                continue;
            }
            System.out.printf("\n%s [-props <config>] [-name <name>] [-follower] [-timeout timeout]\n                   [-bind_addr <bind address>] [-port <bind port>] [-nohup]\n\n", ReplicatedStateMachineDemo.class.getSimpleName());
            return;
        }
        new ReplicatedStateMachineDemo().start(props, name, follower, timeout, bind_addr, port, listen, nohup);
    }

    public static enum Command {
        PUT,
        GET,
        REMOVE,
        SHOW_ALL,
        DUMP_LOG,
        SNAPSHOT,
        GET_VIEW;

    }
}

