/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.raft.filelog;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Objects;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.raft.util.pmem.FileProvider;

public abstract class BaseStorage {
    protected static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final File storageFile;
    private volatile FileChannel channel;

    BaseStorage(File storageFile) {
        this.storageFile = Objects.requireNonNull(storageFile);
    }

    public synchronized void open() throws IOException {
        if (this.channel == null) {
            this.channel = FileProvider.openChannel(this.storageFile, 1024, true, true);
        }
    }

    public synchronized void close() throws IOException {
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
    }

    public synchronized void delete() throws IOException {
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
        if (this.storageFile.exists() && !this.storageFile.delete()) {
            log.warn("Failed to delete file " + this.storageFile.getAbsolutePath());
        }
    }

    protected FileChannel checkOpen() throws IOException {
        FileChannel fileChannel = this.channel;
        if (fileChannel == null) {
            throw new IOException("File " + this.storageFile.getAbsolutePath() + " not open!");
        }
        return fileChannel;
    }

    protected synchronized void truncateUntil(long position) throws IOException {
        FileChannel existing = this.checkOpen();
        File tmpFile = new File(this.storageFile.getParentFile(), this.storageFile.getName() + ".tmp");
        FileChannel newChannel = FileProvider.openChannel(tmpFile, (int)existing.size(), true, true);
        existing.transferTo(position, existing.size(), newChannel);
        newChannel.close();
        existing.close();
        Files.move(tmpFile.toPath(), this.storageFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        this.channel = null;
        this.open();
    }
}

