/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.raft.filelog;

import java.util.Arrays;

public class FilePositionCache {
    public static final int TOO_OLD = -1;
    public static final int NO_CAPACITY = -2;
    public static final int OK = 1;
    private static final int SIZE_INCREMENT = 128;
    private final long[] position;
    private final int firstLogIndex;

    public FilePositionCache(int firstLogIndex) {
        this.position = new long[128];
        this.firstLogIndex = firstLogIndex;
        Arrays.fill(this.position, -1L);
    }

    private FilePositionCache(int firstLogIndex, long[] position) {
        this.position = position;
        this.firstLogIndex = firstLogIndex;
    }

    public long getPosition(int index) {
        int arrayIndex = this.toArrayIndex(index);
        if (arrayIndex < 0) {
            return -1L;
        }
        return arrayIndex < this.position.length ? this.position[arrayIndex] : -2L;
    }

    public int set(int logIndex, long position) {
        int arrayIndex = this.toArrayIndex(logIndex);
        if (arrayIndex < 0) {
            return -1;
        }
        if (arrayIndex >= this.position.length) {
            return -2;
        }
        this.position[arrayIndex] = position;
        return 1;
    }

    public FilePositionCache expand() {
        long[] pos = Arrays.copyOf(this.position, this.position.length + 128);
        Arrays.fill(pos, this.position.length, pos.length, -1L);
        return new FilePositionCache(this.firstLogIndex, pos);
    }

    private int toArrayIndex(int logIndex) {
        return logIndex - this.firstLogIndex;
    }

    public int getFirstAppended() {
        return this.firstLogIndex;
    }

    public void invalidate(int index) {
        int arrayIndex = this.toArrayIndex(index);
        if (arrayIndex < 0 || arrayIndex >= this.position.length) {
            return;
        }
        Arrays.fill(this.position, this.toArrayIndex(index), this.position.length, -1L);
    }

    public FilePositionCache deleteFrom(int index) {
        int arrayIndex = this.toArrayIndex(index);
        if (arrayIndex < 0 || arrayIndex >= this.position.length) {
            throw new IllegalArgumentException();
        }
        long positionToDecrement = this.position[arrayIndex];
        long[] pos = new long[this.position.length - arrayIndex];
        for (int i = 0; i < pos.length; ++i) {
            pos[i] = Math.max(this.position[i + arrayIndex] - positionToDecrement, -1L);
        }
        return new FilePositionCache(index, pos);
    }
}

