/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.raft.filelog;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Objects;
import java.util.concurrent.locks.StampedLock;
import java.util.function.ObjIntConsumer;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.protocols.raft.LogEntry;
import org.jgroups.raft.filelog.BaseStorage;
import org.jgroups.raft.filelog.FilePositionCache;

public class LogEntryStorage
extends BaseStorage {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private static final byte MAGIC_NUMBER = 1;
    private static final String FILE_NAME = "entries.raft";
    private static final int HEADER_SIZE = 17;
    private FilePositionCache positionCache;
    private volatile int lastAppended;
    private final StampedLock lock = new StampedLock();

    public LogEntryStorage(File parentDir) {
        super(new File(parentDir, FILE_NAME));
        this.positionCache = new FilePositionCache(0);
    }

    public void reload() throws IOException {
        long stamp = this.lock.writeLock();
        try {
            FileChannel channel = this.checkOpen();
            Header header = LogEntryStorage.readHeader(channel, 0L);
            if (header == null) {
                this.positionCache = new FilePositionCache(0);
                this.lastAppended = 0;
                return;
            }
            this.positionCache = new FilePositionCache(header.index == 1 ? 0 : header.index);
            this.setFilePosition(header);
            this.lastAppended = header.index;
            long position = header.nextPosition();
            while (true) {
                if ((header = LogEntryStorage.readHeader(channel, position)) == null) {
                    return;
                }
                this.setFilePosition(header);
                position = header.nextPosition();
                this.lastAppended = header.index;
            }
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFirstAppended() {
        long stamp = this.lock.readLock();
        try {
            int n = this.positionCache.getFirstAppended();
            return n;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    public int getLastAppended() {
        return this.lastAppended;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogEntry getLogEntry(int index) throws IOException {
        long stamp = this.lock.readLock();
        try {
            FileChannel channel = this.checkOpen();
            long position = this.positionCache.getPosition(index);
            if (position < 0L) {
                LogEntry logEntry = null;
                return logEntry;
            }
            Header header = LogEntryStorage.readHeader(channel, position);
            if (header == null) {
                LogEntry logEntry = null;
                return logEntry;
            }
            LogEntry logEntry = header.readLogEntry(channel);
            return logEntry;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(int startIndex, LogEntry[] entries, boolean overwrite) throws IOException {
        PositionCheck check = overwrite ? PositionCheck.OVERWRITE : PositionCheck.PUT_IF_ABSENT;
        FileChannel channel = this.checkOpen();
        long stamp = this.lock.writeLock();
        try {
            if (startIndex == 1) {
                int n = this.appendLocked(channel, entries, 1, 0L, check);
                return n;
            }
            long previousPosition = this.positionCache.getPosition(startIndex - 1);
            if (previousPosition < 0L) {
                throw new IllegalStateException();
            }
            Header previous = LogEntryStorage.readHeader(channel, previousPosition);
            if (previous == null) {
                throw new IllegalStateException();
            }
            int n = this.appendLocked(channel, entries, startIndex, previous.nextPosition(), check);
            return n;
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    private void expandCapacity() {
        this.positionCache = this.positionCache.expand();
    }

    private void setFilePosition(Header header) {
        this.setFilePosition(header.index, header.position);
    }

    private void setFilePosition(int index, long position) {
        block4: while (true) {
            switch (this.positionCache.set(index, position)) {
                case -2: {
                    this.expandCapacity();
                    continue block4;
                }
                case -1: {
                    log.warn("Unable to set file position for index " + index + ". LogEntry is too old");
                }
            }
            break;
        }
    }

    private int appendLocked(FileChannel channel, LogEntry[] entries, int index, long position, PositionCheck check) throws IOException {
        Buffer buffer = null;
        int term = 0;
        channel.position(position);
        for (LogEntry entry : entries) {
            Header header = new Header(position, index, entry);
            if (check.canWrite(channel, header, entry)) {
                if (buffer == null || buffer.capacity() < header.totalLength) {
                    buffer = ByteBuffer.allocate(header.totalLength);
                }
                this.writeLogEntry(channel, header, entry, (ByteBuffer)buffer);
                term = Math.max(entry.term(), term);
            }
            position = header.nextPosition();
            ++index;
        }
        this.lastAppended = index - 1;
        this.positionCache.invalidate(index);
        channel.truncate(position);
        return term;
    }

    private static Header readHeader(FileChannel channel, long position) throws IOException {
        ByteBuffer data = ByteBuffer.allocate(17);
        channel.read(data, position);
        data.flip();
        if (data.remaining() != 17) {
            return null;
        }
        return new Header(position, data).consistencyCheck();
    }

    private void writeLogEntry(FileChannel channel, Header header, LogEntry entry, ByteBuffer buffer) throws IOException {
        header.writeTo(buffer);
        buffer.put(entry.command(), entry.offset(), entry.length());
        buffer.flip();
        channel.write(buffer);
        buffer.clear();
        this.setFilePosition(header);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOld(int index) throws IOException {
        long stamp = this.lock.writeLock();
        try {
            long position = this.positionCache.getPosition(index);
            this.truncateUntil(position);
            this.positionCache = this.positionCache.deleteFrom(index);
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeNew(int index) throws IOException {
        long stamp = this.lock.readLock();
        try {
            FileChannel channel = this.checkOpen();
            if (index == 1) {
                channel.truncate(0L);
                this.lastAppended = 0;
                int n = 0;
                return n;
            }
            long position = this.positionCache.getPosition(index - 1);
            Header previousHeader = LogEntryStorage.readHeader(channel, position);
            if (previousHeader == null) {
                throw new IllegalStateException();
            }
            channel.truncate(previousHeader.nextPosition());
            this.positionCache.invalidate(index);
            this.lastAppended = index - 1;
            int n = previousHeader.term;
            return n;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEach(ObjIntConsumer<LogEntry> consumer, int startIndex, int endIndex) throws IOException {
        long stamp = this.lock.readLock();
        try {
            long position = this.positionCache.getPosition(startIndex);
            if (position < 0L) {
                return;
            }
            FileChannel channel = this.checkOpen();
            for (startIndex = Math.max(Math.max(startIndex, this.getFirstAppended()), 1); startIndex <= endIndex; ++startIndex) {
                Header header = LogEntryStorage.readHeader(channel, position);
                if (header == null) {
                    return;
                }
                consumer.accept(header.readLogEntry(channel), startIndex);
                position = header.nextPosition();
            }
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    private static class Header {
        final long position;
        final byte magic;
        final int totalLength;
        final int term;
        final int index;
        final int dataLength;

        Header(long position, int index, LogEntry entry) {
            Objects.requireNonNull(entry);
            this.position = position;
            this.magic = 1;
            this.index = index;
            this.term = entry.term();
            this.dataLength = entry.length();
            this.totalLength = 17 + this.dataLength;
        }

        Header(long position, ByteBuffer buffer) {
            this.position = position;
            this.magic = buffer.get();
            this.totalLength = buffer.getInt();
            this.term = buffer.getInt();
            this.index = buffer.getInt();
            this.dataLength = buffer.getInt();
        }

        public void writeTo(ByteBuffer buffer) {
            buffer.put(this.magic);
            buffer.putInt(this.totalLength);
            buffer.putInt(this.term);
            buffer.putInt(this.index);
            buffer.putInt(this.dataLength);
        }

        long nextPosition() {
            return 17L + this.position + (long)this.dataLength;
        }

        Header consistencyCheck() {
            return this.magic != 1 || this.term <= 0 || this.index <= 0 || this.dataLength < 0 || this.totalLength < 17 || this.dataLength + 17 != this.totalLength ? null : this;
        }

        LogEntry readLogEntry(FileChannel channel) throws IOException {
            ByteBuffer data = ByteBuffer.allocate(this.dataLength);
            channel.read(data, this.position + 17L);
            data.flip();
            if (data.remaining() != this.dataLength) {
                return null;
            }
            if (data.hasArray()) {
                return new LogEntry(this.term, data.array(), data.arrayOffset(), this.dataLength);
            }
            byte[] bytes = new byte[this.dataLength];
            data.get(bytes);
            return new LogEntry(this.term, bytes);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Header header = (Header)o;
            return this.position == header.position && this.magic == header.magic && this.totalLength == header.totalLength && this.term == header.term && this.index == header.index && this.dataLength == header.dataLength;
        }

        public int hashCode() {
            return Objects.hash(this.position, this.magic, this.totalLength, this.term, this.index, this.dataLength);
        }
    }

    private static enum PositionCheck {
        OVERWRITE{

            @Override
            public boolean canWrite(FileChannel channel, Header header, LogEntry entry) {
                return true;
            }
        }
        ,
        PUT_IF_ABSENT{

            @Override
            public boolean canWrite(FileChannel channel, Header header, LogEntry entry) throws IOException {
                Header existing = LogEntryStorage.readHeader(channel, header.position);
                if (existing == null) {
                    return true;
                }
                if (existing.equals(header)) {
                    return false;
                }
                throw new IllegalStateException();
            }
        };


        abstract boolean canWrite(FileChannel var1, Header var2, LogEntry var3) throws IOException;
    }
}

