/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.raft.filelog;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.jgroups.Address;
import org.jgroups.raft.filelog.BaseStorage;
import org.jgroups.util.ByteBufferInputStream;
import org.jgroups.util.Util;

public class MetadataStorage
extends BaseStorage {
    private static final String FILE_NAME = "metadata.raft";
    private static final int COMMIT_INDEX_POS = 0;
    private static final int CURRENT_TERM_POS = 4;
    private static final int VOTED_FOR_POS = 8;

    public MetadataStorage(File parentDir) {
        super(new File(parentDir, FILE_NAME));
    }

    public int getCommitIndex() throws IOException {
        return this.readIntOrZero(0L);
    }

    public void setCommitIndex(int commitIndex) throws IOException {
        this.writeInt(commitIndex, 0L);
    }

    public int getCurrentTerm() throws IOException {
        return this.readIntOrZero(4L);
    }

    public void setCurrentTerm(int term) throws IOException {
        this.writeInt(term, 4L);
    }

    public Address getVotedFor() throws IOException, ClassNotFoundException {
        FileChannel fChannel = this.checkOpen();
        ByteBuffer data = ByteBuffer.allocate(4);
        fChannel.read(data, 8L);
        data.flip();
        if (data.remaining() != 4) {
            return null;
        }
        int addressLength = data.getInt();
        data = ByteBuffer.allocate(addressLength);
        fChannel.read(data, 12L);
        data.flip();
        if (data.remaining() != addressLength) {
            return null;
        }
        return MetadataStorage.readAddress(data);
    }

    public void setVotedFor(Address address) throws IOException {
        FileChannel fChannel = this.checkOpen();
        if (address == null) {
            fChannel.truncate(8L);
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Util.writeAddress((Address)address, (DataOutput)new DataOutputStream(baos));
        byte[] data = baos.toByteArray();
        ByteBuffer buffer = ByteBuffer.allocate(4 + data.length);
        buffer.putInt(data.length);
        buffer.put(data);
        fChannel.write(buffer.flip(), 8L);
    }

    private int readIntOrZero(long position) throws IOException {
        FileChannel fChannel = this.checkOpen();
        ByteBuffer data = ByteBuffer.allocate(4);
        int read = fChannel.read(data, position);
        data.flip();
        return read == 4 ? data.getInt() : 0;
    }

    private void writeInt(int value, long position) throws IOException {
        FileChannel fChannel = this.checkOpen();
        ByteBuffer data = ByteBuffer.allocate(4);
        data.putInt(value);
        data.flip();
        fChannel.write(data, position);
    }

    private static Address readAddress(ByteBuffer buffer) throws IOException, ClassNotFoundException {
        return Util.readAddress((DataInput)new ByteBufferInputStream(buffer));
    }
}

