/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.raft.testfwk;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.raft.testfwk.RaftNode;
import org.jgroups.stack.Protocol;

public class RaftCluster {
    protected final Map<Address, RaftNode> nodes = new ConcurrentHashMap<Address, RaftNode>();
    protected final Map<Address, RaftNode> dropped_members = new ConcurrentHashMap<Address, RaftNode>();

    public RaftCluster add(Address addr, RaftNode node) {
        this.nodes.put(addr, node);
        return this;
    }

    public RaftCluster remove(Address addr) {
        this.nodes.remove(addr);
        return this;
    }

    public RaftCluster clear() {
        this.nodes.clear();
        return this;
    }

    public boolean dropTraffic() {
        return !this.dropped_members.isEmpty();
    }

    public RaftCluster dropTrafficTo(Address a) {
        RaftCluster.move(a, this.nodes, this.dropped_members);
        return this;
    }

    public RaftCluster clearDroppedTrafficTo(Address a) {
        RaftCluster.move(a, this.dropped_members, this.nodes);
        return this;
    }

    public RaftCluster clearDroppedTraffic() {
        RaftCluster.moveAll(this.dropped_members, this.nodes);
        return this;
    }

    public void handleView(View view) {
        List members = view.getMembers();
        this.nodes.keySet().retainAll(Objects.requireNonNull(members));
        this.nodes.values().forEach(n -> {
            Protocol[] protocols;
            for (Protocol p : protocols = n.protocols()) {
                p.down(new Event(6, (Object)view));
            }
        });
    }

    public void send(Message msg) {
        Address dest = msg.dest();
        Address src = msg.src();
        if (dest != null) {
            RaftNode node = this.nodes.get(dest);
            node.up(msg);
        } else {
            for (Map.Entry<Address, RaftNode> e : this.nodes.entrySet()) {
                Address d = e.getKey();
                RaftNode n = e.getValue();
                if (Objects.equals(d, src) && msg.isFlagSet(Message.TransientFlag.DONT_LOOPBACK)) continue;
                n.up(msg);
            }
        }
    }

    public String toString() {
        return String.format("%d nodes: %s%s", this.nodes.size(), this.nodes.keySet(), this.dropTraffic() ? String.format(" (dropping traffic to %s)", this.dropped_members.keySet()) : "");
    }

    protected static void move(Address key, Map<Address, RaftNode> from, Map<Address, RaftNode> to) {
        RaftNode val = from.remove(key);
        if (val != null) {
            to.putIfAbsent(key, val);
        }
    }

    protected static void moveAll(Map<Address, RaftNode> from, Map<Address, RaftNode> to) {
        for (Map.Entry<Address, RaftNode> e : from.entrySet()) {
            to.putIfAbsent(e.getKey(), e.getValue());
        }
        from.clear();
    }
}

