/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.raft.util.pmem;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import org.jgroups.raft.util.pmem.PmemUtilWrapper;

public class FileProvider {
    private static final boolean ATTEMPT_PMEM;

    public static FileChannel openChannel(File file, int length, boolean create, boolean readSharedMetadata) throws IOException {
        FileChannel fileChannel;
        FileChannel fileChannel2 = fileChannel = ATTEMPT_PMEM ? PmemUtilWrapper.pmemChannelFor(file, length, create, readSharedMetadata) : null;
        if (fileChannel == null) {
            if (!file.exists() && !create) {
                return null;
            }
            return FileChannel.open(file.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.READ);
        }
        return fileChannel;
    }

    static {
        boolean attemptPmem = false;
        try {
            Class.forName("io.mashona.logwriting.PmemUtil");
            attemptPmem = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        ATTEMPT_PMEM = attemptPmem;
    }
}

