/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.perf;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.Version;
import org.jgroups.View;
import org.jgroups.annotations.Property;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.blocks.atomic.Counter;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.protocols.TP;
import org.jgroups.raft.blocks.CounterService;
import org.jgroups.tests.perf.PerfUtil;
import org.jgroups.util.Average;
import org.jgroups.util.Bits;
import org.jgroups.util.DefaultThreadFactory;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.jgroups.util.Streamable;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.Util;

public class CounterPerf
implements Receiver {
    private JChannel channel;
    private Address local_addr;
    private RpcDispatcher disp;
    static final String groupname = "counter-perf";
    protected final List<Address> members = new ArrayList<Address>();
    protected volatile View view;
    protected volatile boolean looping = true;
    protected ThreadFactory thread_factory;
    protected CounterService counter_service;
    protected Counter counter;
    @Property
    protected int num_threads = 100;
    @Property
    protected int time = 30;
    @Property
    protected boolean print_updaters;
    @Property
    protected boolean print_details;
    @Property
    protected long timeout = 60000L;
    @Property
    protected int range = 10;
    private static final Method[] METHODS = new Method[4];
    private static final short START = 0;
    private static final short GET_CONFIG = 1;
    private static final short SET = 2;
    private static final short QUIT_ALL = 3;
    protected static final Field NUM_THREADS;
    protected static final Field TIME;
    protected static final Field TIMEOUT;
    protected static final Field PRINT_INVOKERS;
    protected static final Field PRINT_DETAILS;
    protected static final Field RANGE;
    protected static final String format = "[1] Start test [2] View [4] Threads (%d) [6] Time (%s) [r] Range (%d)\n[t] incr timeout (%s) [d] details (%b)  [i] print updaters (%b)\n[v] Version [x] Exit [X] Exit all %s";

    public void init(String props, String name, int bind_port, boolean use_fibers) throws Throwable {
        this.thread_factory = new DefaultThreadFactory("updater", false, true).useFibers(use_fibers);
        if (use_fibers && Util.fibersAvailable()) {
            System.out.println("-- using fibers instead of threads");
        }
        this.channel = new JChannel(props).setName(name);
        if (bind_port > 0) {
            TP transport = this.channel.getProtocolStack().getTransport();
            transport.setBindPort(bind_port);
        }
        this.disp = new RpcDispatcher(this.channel, (Object)this).setReceiver((Receiver)this).setMethodLookup(id -> METHODS[id]);
        this.counter_service = new CounterService(this.channel).raftId(name).replTimeout(this.timeout);
        this.channel.connect(groupname);
        this.local_addr = this.channel.getAddress();
        if (this.members.size() < 2) {
            return;
        }
        Address coord = this.members.get(0);
        PerfUtil.Config config = (PerfUtil.Config)this.disp.callRemoteMethod(coord, new MethodCall(1, new Object[0]), new RequestOptions(ResponseMode.GET_ALL, 5000L));
        if (config != null) {
            this.applyConfig(config);
            System.out.println("Fetched config from " + coord + ": " + config + "\n");
        } else {
            System.err.println("failed to fetch config from " + coord);
        }
    }

    void stop() {
        Util.close((Closeable[])new Closeable[]{this.disp, this.channel});
    }

    protected void stopEventLoop() {
        this.looping = false;
        Util.close((Closeable)this.channel);
    }

    public void viewAccepted(View new_view) {
        this.view = new_view;
        System.out.println("** view: " + new_view);
        this.members.clear();
        this.members.addAll(new_view.getMembers());
    }

    /*
     * WARNING - void declaration
     */
    public UpdateResult startTest() throws Throwable {
        void var11_17;
        System.out.printf("running for %d seconds\n", this.time);
        CountDownLatch latch = new CountDownLatch(1);
        this.counter = this.counter_service.getOrCreateCounter("counter", 0L);
        Updater[] updaters = new Updater[this.num_threads];
        Thread[] threads = new Thread[this.num_threads];
        for (int i = 0; i < threads.length; ++i) {
            updaters[i] = new Updater(latch);
            threads[i] = this.thread_factory.newThread((Runnable)updaters[i]);
            threads[i].setName("updater-" + (i + 1));
            threads[i].start();
        }
        long start = System.currentTimeMillis();
        latch.countDown();
        long interval = (long)((double)this.time * 1000.0 / 10.0);
        for (int i = 1; i <= 10; ++i) {
            Util.sleep((long)interval);
            System.out.printf("%d: %s\n", i, this.printAverage(start, updaters));
        }
        for (Updater updater : updaters) {
            updater.stop();
        }
        for (Runnable runnable : threads) {
            ((Thread)runnable).join();
        }
        long total_time = System.currentTimeMillis() - start;
        System.out.println();
        AverageMinMax avg_incrs = null;
        boolean bl = false;
        while (var11_17 < updaters.length) {
            Updater updater = updaters[var11_17];
            if (this.print_updaters) {
                System.out.printf("updater %s: updates %s\n", threads[var11_17].getId(), CounterPerf.print(updater.avg_updatetime, this.print_details));
            }
            if (avg_incrs == null) {
                avg_incrs = updater.avgUpdateTime();
            } else {
                avg_incrs.merge(updater.avgUpdateTime());
            }
            ++var11_17;
        }
        if (this.print_updaters) {
            System.out.printf("\navg over all updaters: %s\n", CounterPerf.print(avg_incrs, this.print_details));
        }
        System.out.printf("\ndone (in %s ms)\n", total_time);
        return new UpdateResult(this.getTotalUpdates(updaters), total_time, avg_incrs);
    }

    public void quitAll() {
        System.out.println("-- received quitAll(): shutting down");
        this.stopEventLoop();
        System.exit(0);
    }

    protected String printAverage(long start_time, Updater[] updaters) {
        long tmp_time = System.currentTimeMillis() - start_time;
        long incrs = this.getTotalUpdates(updaters);
        double incrs_sec = (double)incrs / ((double)tmp_time / 1000.0);
        return String.format("%,.0f updates/sec (%,d updates)", incrs_sec, incrs);
    }

    protected long getTotalUpdates(Updater[] updaters) {
        long total = 0L;
        if (updaters != null) {
            for (Updater incr : updaters) {
                total += incr.numUpdates();
            }
        }
        return total;
    }

    public void set(String field_name, Object value) {
        Field field = Util.getField(this.getClass(), (String)field_name);
        if (field == null) {
            System.err.println("Field " + field_name + " not found");
        } else {
            Util.setField((Field)field, (Object)this, (Object)value);
            System.out.println(field.getName() + "=" + value);
        }
    }

    public PerfUtil.Config getConfig() {
        PerfUtil.Config config = new PerfUtil.Config();
        for (Field field : Util.getAllDeclaredFieldsWithAnnotations(CounterPerf.class, (Class[])new Class[]{Property.class})) {
            if (!field.isAnnotationPresent(Property.class)) continue;
            config.add(field.getName(), Util.getField((Field)field, (Object)this));
        }
        return config;
    }

    protected void applyConfig(PerfUtil.Config config) {
        for (Map.Entry entry : config.values().entrySet()) {
            Field field = Util.getField(this.getClass(), (String)((String)entry.getKey()));
            Util.setField((Field)field, (Object)this, entry.getValue());
        }
    }

    public void eventLoop() {
        while (this.looping) {
            try {
                long cnt = this.getCounter();
                int c = Util.keyPress((String)String.format(format, this.num_threads, Util.printTime((double)this.time, (TimeUnit)TimeUnit.MILLISECONDS), this.range, Util.printTime((double)this.timeout, (TimeUnit)TimeUnit.MILLISECONDS), this.print_details, this.print_updaters, cnt < 0L ? "\n" : String.format(" (counter=%d)\n", cnt)));
                switch (c) {
                    case 49: {
                        this.startBenchmark();
                        break;
                    }
                    case 50: {
                        this.printView();
                        break;
                    }
                    case 52: {
                        this.changeFieldAcrossCluster(NUM_THREADS, Util.readIntFromStdin((String)"Number of updater threads: "));
                        break;
                    }
                    case 54: {
                        this.changeFieldAcrossCluster(TIME, Util.readIntFromStdin((String)"Time (secs): "));
                        break;
                    }
                    case 100: {
                        this.changeFieldAcrossCluster(PRINT_DETAILS, !this.print_details);
                        break;
                    }
                    case 105: {
                        this.changeFieldAcrossCluster(PRINT_INVOKERS, !this.print_updaters);
                        break;
                    }
                    case 116: {
                        this.changeFieldAcrossCluster(TIMEOUT, Util.readIntFromStdin((String)"update timeout (ms): "));
                        break;
                    }
                    case 114: {
                        this.changeFieldAcrossCluster(RANGE, Util.readIntFromStdin((String)"range: "));
                        break;
                    }
                    case 118: {
                        System.out.printf("Version: %s, Java version: %s\n", Version.printVersion(), System.getProperty("java.vm.version", "n/a"));
                        break;
                    }
                    case -1: 
                    case 120: {
                        this.looping = false;
                        break;
                    }
                    case 88: {
                        try {
                            RequestOptions options = new RequestOptions(ResponseMode.GET_NONE, 0L).flags(new Message.Flag[]{Message.Flag.OOB, Message.Flag.DONT_BUNDLE, Message.Flag.NO_FC});
                            this.disp.callRemoteMethods(null, new MethodCall(3, new Object[0]), options);
                        }
                        catch (Throwable t) {
                            System.err.println("Calling quitAll() failed: " + t);
                        }
                        break;
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        this.stop();
    }

    void startBenchmark() throws Exception {
        RspList responses = null;
        try {
            RequestOptions options = new RequestOptions(ResponseMode.GET_ALL, 0L).flags(new Message.Flag[]{Message.Flag.OOB, Message.Flag.DONT_BUNDLE, Message.Flag.NO_FC});
            responses = this.disp.callRemoteMethods(null, new MethodCall(0, new Object[0]), options);
        }
        catch (Throwable t) {
            System.err.println("starting the benchmark failed: " + t);
            return;
        }
        long total_incrs = 0L;
        long total_time = 0L;
        AverageMinMax avg_incrs = null;
        System.out.println("\n======================= Results: ===========================");
        for (Map.Entry entry : responses.entrySet()) {
            Address mbr = (Address)entry.getKey();
            Rsp rsp = (Rsp)entry.getValue();
            UpdateResult result = (UpdateResult)rsp.getValue();
            if (result != null) {
                total_incrs += result.num_updates;
                total_time += result.total_time;
                if (avg_incrs == null) {
                    avg_incrs = result.avg_updates;
                } else {
                    avg_incrs.merge(result.avg_updates);
                }
            }
            System.out.println(mbr + ": " + result);
        }
        double total_reqs_sec = (double)total_incrs / ((double)total_time / 1000.0);
        System.out.println("\n");
        System.out.println(Util.bold((String)String.format("Throughput: %,.2f updates/sec/node\nTime:       %s / update\n", total_reqs_sec, CounterPerf.print(avg_incrs, this.print_details))));
        System.out.println("\n\n");
    }

    protected void changeFieldAcrossCluster(Field field, Object value) throws Exception {
        this.disp.callRemoteMethods(null, new MethodCall(2, new Object[]{field.getName(), value}), RequestOptions.SYNC());
    }

    protected void printView() {
        System.out.printf("\n-- local: %s, view: %s\n", this.local_addr, this.view);
        try {
            System.in.skip(System.in.available());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static String print(AverageMinMax avg, boolean details) {
        return details ? String.format("min/avg/max = %s", avg.toString(TimeUnit.NANOSECONDS)) : String.format("%s", Util.printTime((double)avg.average(), (TimeUnit)TimeUnit.NANOSECONDS));
    }

    protected long getCounter() {
        try {
            if (this.counter == null) {
                this.counter = this.counter_service.getOrCreateCounter("counter", 0L);
            }
            return this.counter.get();
        }
        catch (Exception ignored) {
            return -1L;
        }
    }

    protected int getDelta() {
        long random = Util.random((long)this.range);
        return (int)(Util.tossWeightedCoin((double)0.5) ? -random : random);
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        block11: {
            String props = null;
            String name = null;
            boolean run_event_loop = true;
            boolean use_fibers = true;
            int port = 0;
            for (int i = 0; i < args.length; ++i) {
                if ("-props".equals(args[i])) {
                    props = args[++i];
                    continue;
                }
                if ("-name".equals(args[i])) {
                    name = args[++i];
                    continue;
                }
                if ("-nohup".equals(args[i])) {
                    run_event_loop = false;
                    continue;
                }
                if ("-port".equals(args[i])) {
                    port = Integer.parseInt(args[++i]);
                    continue;
                }
                if ("-use_fibers".equals(args[i])) {
                    use_fibers = Boolean.parseBoolean(args[++i]);
                    continue;
                }
                CounterPerf.help();
                return;
            }
            if (name == null) {
                throw new IllegalArgumentException("name (raft-id) must be set");
            }
            CounterPerf test = null;
            try {
                test = new CounterPerf();
                test.init(props, name, port, use_fibers);
                if (run_event_loop) {
                    test.eventLoop();
                    break block11;
                }
                while (true) {
                    Util.sleep((long)60000L);
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                if (test == null) break block11;
                test.stop();
            }
        }
    }

    static void help() {
        System.out.println("CounterPerf [-props <props>] [-name name] [-nohup] [-port <bind port>] [-use_fibers <true|false>]");
    }

    static {
        try {
            CounterPerf.METHODS[0] = CounterPerf.class.getMethod("startTest", new Class[0]);
            CounterPerf.METHODS[1] = CounterPerf.class.getMethod("getConfig", new Class[0]);
            CounterPerf.METHODS[2] = CounterPerf.class.getMethod("set", String.class, Object.class);
            CounterPerf.METHODS[3] = CounterPerf.class.getMethod("quitAll", new Class[0]);
            NUM_THREADS = Util.getField(CounterPerf.class, (String)"num_threads", (boolean)true);
            TIME = Util.getField(CounterPerf.class, (String)"time", (boolean)true);
            TIMEOUT = Util.getField(CounterPerf.class, (String)"timeout", (boolean)true);
            PRINT_INVOKERS = Util.getField(CounterPerf.class, (String)"print_updaters", (boolean)true);
            PRINT_DETAILS = Util.getField(CounterPerf.class, (String)"print_details", (boolean)true);
            RANGE = Util.getField(CounterPerf.class, (String)"range", (boolean)true);
            PerfUtil.init();
            ClassConfigurator.addIfAbsent((short)1050, UpdateResult.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class AverageMinMax
    extends Average {
        protected long min = Long.MAX_VALUE;
        protected long max = 0L;
        protected List<Long> values;

        public long min() {
            return this.min;
        }

        public long max() {
            return this.max;
        }

        public boolean usePercentiles() {
            return this.values != null;
        }

        public AverageMinMax usePercentiles(int capacity) {
            this.values = capacity > 0 ? new ArrayList(capacity) : null;
            return this;
        }

        public <T extends Average> T add(long num) {
            super.add(num);
            this.min = Math.min(this.min, num);
            this.max = Math.max(this.max, num);
            if (this.values != null) {
                this.values.add(num);
            }
            return (T)((Object)this);
        }

        public <T extends Average> T merge(T other) {
            if (other.count() == 0L) {
                return (T)((Object)this);
            }
            super.merge(other);
            if (other instanceof AverageMinMax) {
                AverageMinMax o = (AverageMinMax)other;
                this.min = Math.min(this.min, o.min());
                this.max = Math.max(this.max, o.max());
                if (this.values != null) {
                    this.values.addAll(o.values);
                }
            }
            return (T)((Object)this);
        }

        public void clear() {
            super.clear();
            if (this.values != null) {
                this.values.clear();
            }
            this.min = Long.MAX_VALUE;
            this.max = 0L;
        }

        public String percentiles() {
            if (this.values == null) {
                return "n/a";
            }
            Collections.sort(this.values);
            double stddev = this.stddev();
            return String.format("stddev: %.2f, 50: %d, 90: %d, 99: %d, 99.9: %d, 99.99: %d, 99.999: %d, 100: %d\n", stddev, this.p(50.0), this.p(90.0), this.p(99.0), this.p(99.9), this.p(99.99), this.p(99.999), this.p(100.0));
        }

        public String toString() {
            return this.count == 0L ? "n/a" : String.format("min/avg/max=%,d/%,.2f/%,d", this.min, this.getAverage(), this.max);
        }

        public String toString(TimeUnit u) {
            if (this.count == 0L) {
                return "n/a";
            }
            return String.format("%s/%s/%s", Util.printTime((double)this.min, (TimeUnit)u), Util.printTime((double)this.getAverage(), (TimeUnit)u), Util.printTime((double)this.max, (TimeUnit)u));
        }

        public void writeTo(DataOutput out) throws IOException {
            super.writeTo(out);
            Bits.writeLongCompressed((long)this.min, (DataOutput)out);
            Bits.writeLongCompressed((long)this.max, (DataOutput)out);
        }

        public void readFrom(DataInput in) throws IOException {
            super.readFrom(in);
            this.min = Bits.readLongCompressed((DataInput)in);
            this.max = Bits.readLongCompressed((DataInput)in);
        }

        protected long p(double percentile) {
            if (this.values == null) {
                return -1L;
            }
            int size = this.values.size();
            int index = (int)((double)size * (percentile / 100.0));
            return this.values.get(index - 1);
        }

        protected double stddev() {
            if (this.values == null) {
                return -1.0;
            }
            double av = this.average();
            int size = this.values.size();
            double variance = this.values.stream().map(v -> ((double)v.longValue() - av) * ((double)v.longValue() - av)).reduce(0.0, Double::sum) / (double)size;
            return Math.sqrt(variance);
        }
    }

    protected static class UpdateResult
    implements Streamable {
        protected long num_updates;
        protected long total_time;
        protected AverageMinMax avg_updates;

        public UpdateResult() {
        }

        public UpdateResult(long num_updates, long total_time, AverageMinMax avg_updates) {
            this.num_updates = num_updates;
            this.total_time = total_time;
            this.avg_updates = avg_updates;
        }

        public void writeTo(DataOutput out) throws IOException {
            Bits.writeLongCompressed((long)this.num_updates, (DataOutput)out);
            Bits.writeLongCompressed((long)this.total_time, (DataOutput)out);
            Util.writeStreamable((Streamable)this.avg_updates, (DataOutput)out);
        }

        public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
            this.num_updates = Bits.readLongCompressed((DataInput)in);
            this.total_time = Bits.readLongCompressed((DataInput)in);
            this.avg_updates = (AverageMinMax)Util.readStreamable(AverageMinMax::new, (DataInput)in);
        }

        public String toString() {
            double total_reqs_per_sec = (double)this.num_updates / ((double)this.total_time / 1000.0);
            return String.format("%,.2f updates/sec (%,d updates, %s / update)", total_reqs_per_sec, this.num_updates, Util.printTime((double)this.avg_updates.average(), (TimeUnit)TimeUnit.NANOSECONDS));
        }
    }

    protected class Updater
    implements Runnable {
        private final CountDownLatch latch;
        private long num_updates;
        private final AverageMinMax avg_updatetime = new AverageMinMax();
        private volatile boolean running = true;

        public Updater(CountDownLatch latch) {
            this.latch = latch;
        }

        public long numUpdates() {
            return this.num_updates;
        }

        public AverageMinMax avgUpdateTime() {
            return this.avg_updatetime;
        }

        public void stop() {
            this.running = false;
        }

        @Override
        public void run() {
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            while (this.running) {
                try {
                    int delta = CounterPerf.this.getDelta();
                    long start = System.nanoTime();
                    CounterPerf.this.counter.addAndGet((long)delta);
                    long incr_time = System.nanoTime() - start;
                    this.avg_updatetime.add(incr_time);
                    ++this.num_updates;
                }
                catch (Throwable t) {
                    if (!this.running) continue;
                    t.printStackTrace();
                }
            }
        }
    }
}

