/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.raft;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.Supplier;
import org.jgroups.Address;
import org.jgroups.Header;
import org.jgroups.protocols.raft.RaftHeader;
import org.jgroups.util.Bits;
import org.jgroups.util.Util;

public class AppendEntriesRequest
extends RaftHeader {
    protected Address leader;
    protected int entry_term;
    protected int prev_log_index;
    protected int prev_log_term;
    protected int leader_commit;

    public AppendEntriesRequest() {
    }

    public AppendEntriesRequest(Address leader, int current_term, int prev_log_index, int prev_log_term, int entry_term, int leader_commit) {
        super(current_term);
        this.leader = leader;
        this.entry_term = entry_term;
        this.prev_log_index = prev_log_index;
        this.prev_log_term = prev_log_term;
        this.leader_commit = leader_commit;
    }

    public short getMagicId() {
        return 2000;
    }

    public Supplier<? extends Header> create() {
        return AppendEntriesRequest::new;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + Util.size((Address)this.leader) + Bits.size((int)this.entry_term) + Bits.size((int)this.prev_log_index) + Bits.size((int)this.prev_log_term) + Bits.size((int)this.leader_commit);
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        Util.writeAddress((Address)this.leader, (DataOutput)out);
        Bits.writeIntCompressed((int)this.entry_term, (DataOutput)out);
        Bits.writeIntCompressed((int)this.prev_log_index, (DataOutput)out);
        Bits.writeIntCompressed((int)this.prev_log_term, (DataOutput)out);
        Bits.writeIntCompressed((int)this.leader_commit, (DataOutput)out);
    }

    @Override
    public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
        super.readFrom(in);
        this.leader = Util.readAddress((DataInput)in);
        this.entry_term = Bits.readIntCompressed((DataInput)in);
        this.prev_log_index = Bits.readIntCompressed((DataInput)in);
        this.prev_log_term = Bits.readIntCompressed((DataInput)in);
        this.leader_commit = Bits.readIntCompressed((DataInput)in);
    }

    @Override
    public String toString() {
        return String.format("%s, leader=%s, entry_term=%d, prev_log_index=%d, prev_log_term=%d, leader_commit=%d", super.toString(), this.leader, this.entry_term, this.prev_log_index, this.prev_log_term, this.leader_commit);
    }
}

