/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.raft;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jgroups.util.Bits;
import org.jgroups.util.Streamable;

public class AppendResult
implements Streamable {
    protected Result result;
    protected int index;
    protected int commit_index;
    protected int non_matching_term;

    public AppendResult() {
    }

    public AppendResult(Result result, int index) {
        this.result = result;
        this.index = index;
    }

    public AppendResult(Result result, int index, int non_matching_term) {
        this(result, index);
        this.non_matching_term = non_matching_term;
    }

    public boolean success() {
        return this.result != null && this.result == Result.OK;
    }

    public int index() {
        return this.index;
    }

    public int commitIndex() {
        return this.commit_index;
    }

    public int nonMatchingTerm() {
        return this.non_matching_term;
    }

    public AppendResult commitIndex(int ci) {
        this.commit_index = ci;
        return this;
    }

    public int size() {
        return Bits.size((int)this.result.ordinal()) + Bits.size((int)this.index) + Bits.size((int)this.commit_index) + Bits.size((int)this.non_matching_term);
    }

    public void writeTo(DataOutput out) throws IOException {
        Bits.writeIntCompressed((int)this.result.ordinal(), (DataOutput)out);
        Bits.writeIntCompressed((int)this.index, (DataOutput)out);
        Bits.writeIntCompressed((int)this.commit_index, (DataOutput)out);
        Bits.writeIntCompressed((int)this.non_matching_term, (DataOutput)out);
    }

    public void readFrom(DataInput in) throws IOException {
        int ordinal = Bits.readIntCompressed((DataInput)in);
        this.result = Result.values()[ordinal];
        this.index = Bits.readIntCompressed((DataInput)in);
        this.commit_index = Bits.readIntCompressed((DataInput)in);
        this.non_matching_term = Bits.readIntCompressed((DataInput)in);
    }

    public String toString() {
        return String.format("%b%s, index=%d, commit-index=%d%s", this.success(), this.success() ? "" : String.format(" (%s)", new Object[]{this.result}), this.index, this.commit_index, this.non_matching_term > 0 ? String.format(", non-matching-term=%d", this.non_matching_term) : "");
    }

    public static enum Result {
        OK,
        FAIL_ENTRY_NOT_FOUND,
        FAIL_CONFLICTING_PREV_TERM;

    }
}

