/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.raft;

import java.io.Closeable;
import java.util.Map;
import java.util.function.ObjIntConsumer;
import org.jgroups.Address;
import org.jgroups.protocols.raft.LogEntries;
import org.jgroups.protocols.raft.LogEntry;

public interface Log
extends Closeable {
    public void init(String var1, Map<String, String> var2) throws Exception;

    public Log useFsync(boolean var1);

    public boolean useFsync();

    public void delete() throws Exception;

    public int currentTerm();

    public Log currentTerm(int var1);

    public Address votedFor();

    public Log votedFor(Address var1);

    public int commitIndex();

    public Log commitIndex(int var1);

    public int firstAppended();

    public int lastAppended();

    public int append(int var1, LogEntries var2);

    public LogEntry get(int var1);

    public void truncate(int var1);

    public void reinitializeTo(int var1, LogEntry var2) throws Exception;

    public void deleteAllEntriesStartingFrom(int var1);

    public void forEach(ObjIntConsumer<LogEntry> var1, int var2, int var3);

    public void forEach(ObjIntConsumer<LogEntry> var1);

    default public int size() {
        int last = this.lastAppended();
        int first = this.firstAppended();
        return first == 0 ? last : last - first + 1;
    }
}

