/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.raft;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.jgroups.protocols.raft.LogEntry;
import org.jgroups.util.Bits;
import org.jgroups.util.SizeStreamable;

public class LogEntries
implements SizeStreamable,
Iterable<LogEntry> {
    protected List<LogEntry> entries;

    public LogEntries add(LogEntry ... log_entries) {
        if (this.entries == null) {
            this.entries = new ArrayList<LogEntry>();
        }
        for (LogEntry le : log_entries) {
            this.entries.add(Objects.requireNonNull(le));
        }
        return this;
    }

    public static LogEntries create(LogEntry ... entries) {
        return new LogEntries().add(entries);
    }

    public LogEntries clear() {
        if (this.entries != null) {
            this.entries.clear();
        }
        return this;
    }

    @Override
    public Iterator<LogEntry> iterator() {
        if (this.entries == null) {
            this.entries = new ArrayList<LogEntry>();
        }
        return this.entries.iterator();
    }

    public int size() {
        return this.entries != null ? this.entries.size() : 0;
    }

    public LogEntry[] toArray() {
        if (this.entries == null) {
            return new LogEntry[0];
        }
        LogEntry[] ret = new LogEntry[this.size()];
        int index = 0;
        for (LogEntry le : this.entries) {
            ret[index++] = le;
        }
        return ret;
    }

    public long totalSize() {
        return this.entries == null ? 0L : (long)this.entries.stream().filter(Objects::nonNull).map(e -> e.length).reduce(0, Integer::sum).intValue();
    }

    public int serializedSize() {
        int size = this.size();
        int retval = Bits.size((int)size);
        if (size > 0) {
            for (LogEntry le : this.entries) {
                retval += le.serializedSize();
            }
        }
        return retval;
    }

    public void writeTo(DataOutput out) throws IOException {
        int size = this.size();
        Bits.writeIntCompressed((int)size, (DataOutput)out);
        if (size > 0) {
            for (LogEntry le : this.entries) {
                le.writeTo(out);
            }
        }
    }

    public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
        int size = Bits.readIntCompressed((DataInput)in);
        if (size > 0) {
            this.entries = new ArrayList<LogEntry>(size);
            for (int i = 0; i < size; ++i) {
                LogEntry le = new LogEntry();
                le.readFrom(in);
                this.entries.add(le);
            }
        }
    }

    public String toString() {
        return String.format("%d entries", this.size());
    }
}

