/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.raft;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.Supplier;
import org.jgroups.Header;
import org.jgroups.protocols.raft.RaftHeader;
import org.jgroups.util.Bits;

public class VoteResponse
extends RaftHeader {
    protected int last_log_term;
    protected int last_log_index;

    public VoteResponse() {
    }

    public VoteResponse(int term, int last_log_term, int last_log_index) {
        super(term);
        this.last_log_term = last_log_term;
        this.last_log_index = last_log_index;
    }

    public short getMagicId() {
        return 3001;
    }

    public Supplier<? extends Header> create() {
        return VoteResponse::new;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + Bits.size((int)this.last_log_term) + Bits.size((int)this.last_log_index);
    }

    @Override
    public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
        super.readFrom(in);
        this.last_log_term = Bits.readIntCompressed((DataInput)in);
        this.last_log_index = Bits.readIntCompressed((DataInput)in);
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        Bits.writeIntCompressed((int)this.last_log_term, (DataOutput)out);
        Bits.writeIntCompressed((int)this.last_log_index, (DataOutput)out);
    }

    @Override
    public String toString() {
        return super.toString() + ", last_log_term=" + this.last_log_term + ", last_log_index=" + this.last_log_index;
    }
}

