/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.raft.filelog;

import java.util.ArrayList;
import java.util.Arrays;

public class FilePositionCache {
    public static final int TOO_OLD = -2;
    public static final int EMPTY = -1;
    private static final int PAGE_CAPACITY = 1024;
    private static final int PAGE_SHIFT = Integer.numberOfTrailingZeros(1024);
    private static final int PAGE_MASK = 1023;
    private final ArrayList<PositionPage> positionPages;
    private final int firstLogIndex;

    public FilePositionCache(int firstLogIndex) {
        assert (Integer.bitCount(1024) == 1) : "PAGE_CAPACITY MUST BE A POWER OF TWO";
        this.positionPages = new ArrayList();
        this.firstLogIndex = firstLogIndex;
    }

    public FilePositionCache(int firstLogIndex, int requiredPages) {
        assert (Integer.bitCount(1024) == 1) : "PAGE_CAPACITY MUST BE A POWER OF TWO";
        this.positionPages = new ArrayList(requiredPages);
        this.firstLogIndex = firstLogIndex;
    }

    public int getFirstLogIndex() {
        return this.firstLogIndex;
    }

    private static int toPageIndex(int cacheIndex) {
        return cacheIndex >> PAGE_SHIFT;
    }

    private static int toPageOffset(int cacheIndex) {
        return cacheIndex & 0x3FF;
    }

    public long getPosition(int logIndex) {
        int cacheIndex = this.toCacheIndex(logIndex);
        if (cacheIndex < 0) {
            return -2L;
        }
        int pageIndex = FilePositionCache.toPageIndex(cacheIndex);
        if (pageIndex >= this.positionPages.size()) {
            return -1L;
        }
        PositionPage page = this.positionPages.get(pageIndex);
        if (page == null) {
            return -1L;
        }
        return page.get(FilePositionCache.toPageOffset(cacheIndex));
    }

    private PositionPage getOrCreatePage(int pageIndex) {
        int pages = this.positionPages.size();
        if (pageIndex < pages) {
            PositionPage page = this.positionPages.get(pageIndex);
            if (page != null) {
                return page;
            }
            PositionPage positionPage = new PositionPage();
            this.positionPages.set(pageIndex, positionPage);
            return positionPage;
        }
        int requiredCapacity = pageIndex + 1;
        this.positionPages.ensureCapacity(requiredCapacity);
        for (int i = pages; i < pageIndex; ++i) {
            this.positionPages.add(null);
        }
        PositionPage positionPage = new PositionPage();
        this.positionPages.add(positionPage);
        assert (this.positionPages.size() == pageIndex + 1);
        return positionPage;
    }

    public boolean set(int logIndex, long position) {
        if (position < 0L) {
            throw new IllegalArgumentException("position must be greater then zero");
        }
        int cacheIndex = this.toCacheIndex(logIndex);
        if (cacheIndex < 0) {
            return false;
        }
        this.getOrCreatePage(FilePositionCache.toPageIndex(cacheIndex)).set(FilePositionCache.toPageOffset(cacheIndex), position);
        return true;
    }

    private int toCacheIndex(int logIndex) {
        return logIndex - this.firstLogIndex;
    }

    public int getFirstAppended() {
        return this.firstLogIndex;
    }

    public boolean invalidateFrom(int logIndex) {
        int cacheIndex = this.toCacheIndex(logIndex);
        if (cacheIndex < 0) {
            return false;
        }
        int pageIndex = FilePositionCache.toPageIndex(cacheIndex);
        if (pageIndex >= this.positionPages.size()) {
            return false;
        }
        boolean clearSomething = this.positionPages.get(pageIndex).clearFrom(FilePositionCache.toPageOffset(cacheIndex));
        for (int i = pageIndex + 1; i < this.positionPages.size(); ++i) {
            clearSomething |= this.positionPages.get(i).clear();
        }
        return clearSomething;
    }

    public FilePositionCache createDeleteCopyFrom(int logIndex) {
        int cacheIndex = this.toCacheIndex(logIndex);
        if (cacheIndex < 0) {
            throw new IllegalArgumentException();
        }
        int pageIndex = FilePositionCache.toPageIndex(cacheIndex);
        if (pageIndex >= this.positionPages.size()) {
            return new FilePositionCache(logIndex);
        }
        int pageOffset = FilePositionCache.toPageOffset(cacheIndex);
        PositionPage positionPage = this.positionPages.get(pageIndex);
        if (positionPage == null) {
            return new FilePositionCache(logIndex);
        }
        long positionToDecrement = positionPage.get(pageOffset);
        if (positionToDecrement == -1L) {
            return new FilePositionCache(logIndex);
        }
        int oldPages = this.positionPages.size();
        FilePositionCache newCache = new FilePositionCache(logIndex, oldPages - pageIndex);
        int newLogIndex = logIndex;
        for (int offset = pageOffset; offset <= positionPage.lastNotEmptyOffset; ++offset) {
            long oldPosition = positionPage.get(offset);
            if (oldPosition != -1L) {
                newCache.set(newLogIndex, oldPosition - positionToDecrement);
            }
            ++newLogIndex;
        }
        newLogIndex += 1024 - (positionPage.lastNotEmptyOffset + 1);
        for (int i = pageIndex + 1; i < oldPages; ++i) {
            int lastNotEmptyPageOffset;
            PositionPage page = this.positionPages.get(i);
            if (page != null && (lastNotEmptyPageOffset = page.lastNotEmptyOffset) >= 0) {
                for (int offset = 0; offset <= lastNotEmptyPageOffset; ++offset) {
                    long oldPosition = page.get(offset);
                    if (oldPosition == -1L) continue;
                    newCache.set(newLogIndex + offset, oldPosition - positionToDecrement);
                }
            }
            newLogIndex += 1024;
        }
        return newCache;
    }

    private static final class PositionPage {
        private final long[] positions = new long[1024];
        private int lastNotEmptyOffset;

        public PositionPage() {
            Arrays.fill(this.positions, -1L);
            this.lastNotEmptyOffset = -1;
        }

        public boolean clear() {
            return this.clearFrom(0);
        }

        public boolean clearFrom(int pageOffset) {
            if (pageOffset > this.lastNotEmptyOffset) {
                return false;
            }
            if (pageOffset < 0) {
                throw new IllegalArgumentException("pageOffset must be greater then 0");
            }
            if (pageOffset >= 1024) {
                throw new IllegalArgumentException("pageOffset must be less then page capacity");
            }
            assert (this.lastNotEmptyOffset >= 0);
            Arrays.fill(this.positions, pageOffset, this.lastNotEmptyOffset + 1, -1L);
            this.lastNotEmptyOffset = -1;
            for (int i = pageOffset; i >= 0; --i) {
                if (this.positions[i] == -1L) continue;
                this.lastNotEmptyOffset = i;
                break;
            }
            return true;
        }

        public long set(int pageOffset, long position) {
            if (position < 0L) {
                throw new IllegalArgumentException("position must be greater then zero");
            }
            if (pageOffset >= 1024) {
                throw new IllegalArgumentException("The required pageOffset is beyond page capacity");
            }
            long oldValue = this.positions[pageOffset];
            if (oldValue == -1L && pageOffset > this.lastNotEmptyOffset) {
                this.lastNotEmptyOffset = pageOffset;
            }
            this.positions[pageOffset] = position;
            return oldValue;
        }

        public long get(int pageOffset) {
            if (pageOffset >= 1024) {
                throw new IllegalArgumentException("The required pageOffset is beyond page capacity");
            }
            if (pageOffset > this.lastNotEmptyOffset) {
                return -1L;
            }
            return this.positions[pageOffset];
        }
    }
}

