/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.raft.util;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.jgroups.Address;

public class CommitTable {
    protected final ConcurrentMap<Address, Entry> map = new ConcurrentHashMap<Address, Entry>();

    public CommitTable(List<Address> members, int next_index) {
        this.adjust(members, next_index);
    }

    public Set<Address> keys() {
        return this.map.keySet();
    }

    public Entry get(Address a) {
        return (Entry)this.map.get(a);
    }

    public void adjust(List<Address> members, int next_index) {
        this.map.keySet().retainAll(members);
        members.forEach((? super T mbr) -> this.map.computeIfAbsent((Address)mbr, k -> new Entry(next_index)));
    }

    public CommitTable update(Address member, int match_index, int next_index, int commit_index, boolean single_resend) {
        return this.update(member, match_index, next_index, commit_index, single_resend, false);
    }

    public CommitTable update(Address member, int match_index, int next_index, int commit_index, boolean single_resend, boolean overwrite) {
        Entry e = (Entry)this.map.get(member);
        if (e == null) {
            return this;
        }
        e.match_index = overwrite ? match_index : Math.max(match_index, e.match_index);
        e.next_index = Math.max(1, next_index);
        e.commit_index = Math.max(e.commit_index, commit_index);
        e.send_single_msg = single_resend;
        e.assertInvariant();
        return this;
    }

    public boolean snapshotInProgress(Address mbr, boolean flag) {
        Entry entry = (Entry)this.map.get(mbr);
        return entry != null && entry.snapshotInProgress(flag);
    }

    public void forEach(BiConsumer<Address, Entry> function) {
        for (Map.Entry entry : this.map.entrySet()) {
            Entry val = (Entry)entry.getValue();
            if (val.snapshot_in_progress) continue;
            function.accept((Address)entry.getKey(), val);
        }
    }

    public String toString() {
        return this.map.entrySet().stream().map(e -> String.format("%s: %s", e.getKey(), e.getValue())).collect(Collectors.joining("\n"));
    }

    public static class Entry {
        protected int commit_index;
        protected int match_index;
        protected int next_index;
        protected boolean snapshot_in_progress;
        protected boolean send_single_msg;

        public Entry(int next_index) {
            this.next_index = next_index;
        }

        public int commitIndex() {
            return this.commit_index;
        }

        public Entry commitIndex(int idx) {
            this.commit_index = idx;
            return this;
        }

        public int matchIndex() {
            return this.match_index;
        }

        public Entry matchIndex(int idx) {
            this.match_index = idx;
            return this;
        }

        public int nextIndex() {
            return this.next_index;
        }

        public Entry nextIndex(int idx) {
            this.next_index = idx;
            return this;
        }

        public boolean sendSingleMessage() {
            return this.send_single_msg;
        }

        public Entry sendSingleMessage(boolean flag) {
            this.send_single_msg = flag;
            return this;
        }

        public boolean snapshotInProgress(boolean flag) {
            if (this.snapshot_in_progress == flag) {
                return false;
            }
            this.snapshot_in_progress = flag;
            return true;
        }

        public void assertInvariant() {
            assert (this.commit_index <= this.match_index && this.match_index <= this.next_index) : this;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("commit-index=").append(this.commit_index).append(", match-index=").append(this.match_index).append(", next-index=").append(this.next_index);
            if (this.snapshot_in_progress) {
                sb.append(" [snapshotting]");
            }
            if (this.send_single_msg) {
                sb.append(" [send-single-msg]");
            }
            return sb.toString();
        }
    }
}

