/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.raft.util;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.function.ObjIntConsumer;
import org.jgroups.Address;
import org.jgroups.protocols.raft.Log;
import org.jgroups.protocols.raft.LogEntries;
import org.jgroups.protocols.raft.LogEntry;
import org.jgroups.raft.util.ArrayRingBuffer;

public class LogCache
implements Log {
    private static final int DEFAULT_MAX_SIZE = 1024;
    protected final Log log;
    protected ArrayRingBuffer<LogEntry> cache;
    protected int max_size;
    protected int current_term;
    protected int commit_index;
    protected int first_appended;
    protected int last_appended;
    protected Address voted_for;
    protected int num_trims;
    protected int num_hits;
    protected int num_misses;

    public LogCache(Log log) {
        this(log, 1024);
    }

    public LogCache(Log log, int max_size) {
        this.log = Objects.requireNonNull(log);
        this.current_term = log.currentTerm();
        this.commit_index = log.commitIndex();
        this.first_appended = log.firstAppended();
        this.last_appended = log.lastAppended();
        this.voted_for = log.votedFor();
        this.max_size = max_size;
        this.cache = new ArrayRingBuffer(max_size, log.commitIndex());
    }

    public int maxSize() {
        return this.max_size;
    }

    public Log maxSize(int s) {
        this.max_size = s;
        return this;
    }

    public int cacheSize() {
        return this.cache.size();
    }

    public Log log() {
        return this.log;
    }

    public int numTrims() {
        return this.num_trims;
    }

    public int numAccesses() {
        return this.num_hits + this.num_misses;
    }

    public double hitRatio() {
        return this.numAccesses() == 0 ? 0.0 : (double)this.num_hits / (double)this.numAccesses();
    }

    public Log resetStats() {
        this.num_misses = 0;
        this.num_hits = 0;
        this.num_trims = 0;
        return this;
    }

    @Override
    public Log useFsync(boolean f) {
        this.log.useFsync(f);
        return this;
    }

    @Override
    public boolean useFsync() {
        return this.log.useFsync();
    }

    @Override
    public void init(String log_name, Map<String, String> args) throws Exception {
        this.log.init(log_name, args);
    }

    @Override
    public void delete() throws Exception {
        this.log.delete();
        this.last_appended = 0;
        this.first_appended = 0;
        this.commit_index = 0;
        this.current_term = 0;
        this.voted_for = null;
        this.cache.clear();
    }

    @Override
    public int currentTerm() {
        return this.current_term;
    }

    @Override
    public Log currentTerm(int new_term) {
        this.log.currentTerm(new_term);
        this.current_term = new_term;
        return this;
    }

    @Override
    public Address votedFor() {
        return this.voted_for;
    }

    @Override
    public Log votedFor(Address member) {
        this.log.votedFor(member);
        this.voted_for = member;
        return this;
    }

    @Override
    public int commitIndex() {
        return this.commit_index;
    }

    @Override
    public Log commitIndex(int new_index) {
        this.log.commitIndex(new_index);
        this.commit_index = new_index;
        this.cache.dropHeadUntil(new_index);
        return this;
    }

    @Override
    public int firstAppended() {
        return this.first_appended;
    }

    @Override
    public int lastAppended() {
        return this.last_appended;
    }

    @Override
    public int append(int index, LogEntries entries) {
        this.last_appended = this.log.append(index, entries);
        this.current_term = this.log.currentTerm();
        for (LogEntry le : entries) {
            int logIndex;
            if ((long)(logIndex = index++) < this.cache.getHeadSequence()) continue;
            if (this.cache.availableCapacityWithoutResizing() == 0) {
                this.trim();
            }
            this.cache.set(logIndex, le);
        }
        this.trim();
        return this.last_appended;
    }

    @Override
    public LogEntry get(int index) {
        LogEntry e;
        if (index > this.last_appended) {
            return null;
        }
        if ((long)index < this.cache.getHeadSequence()) {
            ++this.num_misses;
            assert (!this.cache.contains(index));
            return this.log.get(index);
        }
        if (this.cache.contains(index) && (e = this.cache.get(index)) != null) {
            ++this.num_hits;
            return e;
        }
        e = this.log.get(index);
        if (e == null) {
            return null;
        }
        ++this.num_misses;
        this.cache.set(index, e);
        this.trim();
        return e;
    }

    @Override
    public void truncate(int index_exclusive) {
        this.log.truncate(index_exclusive);
        this.cache.dropHeadUntil(index_exclusive);
        this.first_appended = this.log.firstAppended();
        this.last_appended = this.log.lastAppended();
    }

    @Override
    public void reinitializeTo(int index, LogEntry le) throws Exception {
        this.log.reinitializeTo(index, le);
        this.cache.clear();
        this.cache = new ArrayRingBuffer(this.max_size, index);
        this.cache.add(le);
        this.first_appended = this.log.firstAppended();
        this.commit_index = this.log.commitIndex();
        this.last_appended = this.log.lastAppended();
        this.current_term = this.log.currentTerm();
    }

    @Override
    public void deleteAllEntriesStartingFrom(int start_index) {
        this.log.deleteAllEntriesStartingFrom(start_index);
        this.commit_index = this.log.commitIndex();
        this.last_appended = this.log.lastAppended();
        this.current_term = this.log.currentTerm();
        this.cache.dropTailTo(start_index);
    }

    @Override
    public void forEach(ObjIntConsumer<LogEntry> function, int start_index, int end_index) {
        this.log.forEach(function, start_index, end_index);
    }

    @Override
    public void forEach(ObjIntConsumer<LogEntry> function) {
        this.forEach(function, this.first_appended, this.last_appended);
    }

    @Override
    public void close() throws IOException {
        this.log.close();
        this.cache.clear();
    }

    public LogCache clear() {
        this.cache.clear();
        return this;
    }

    public Log trim() {
        int oldestToRemove = this.cache.size() - this.max_size;
        if (oldestToRemove > 0) {
            this.cache.dropHeadUntil(this.cache.getHeadSequence() + (long)oldestToRemove);
            ++this.num_trims;
        }
        return this;
    }

    public String toString() {
        return String.format("first=%d commit=%d last=%d term=%d (%d entries, max-size=%d)", this.first_appended, this.commit_index, this.last_appended, this.current_term, this.cache.size(), this.max_size);
    }

    public String toStringDetails() {
        return String.format("first=%d log-first=%d commit=%d log-commit=%d last=%d log-last=%d term=%d log-term=%d (max-size=%d)", this.first_appended, this.log.firstAppended(), this.commit_index, this.log.commitIndex(), this.last_appended, this.log.lastAppended(), this.current_term, this.log.currentTerm(), this.max_size);
    }
}

