/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.raft.util;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.jgroups.raft.util.ArrayRingBuffer;

public class RequestTable<T> {
    protected ArrayRingBuffer<Entry<T>> requests;

    public void create(int index, T vote, CompletableFuture<byte[]> future, int majority) {
        Entry<T> entry = new Entry<T>(future);
        if (this.requests == null) {
            this.requests = new ArrayRingBuffer(index);
        }
        this.requests.set(index, entry);
        entry.add(vote, majority);
    }

    public boolean add(int index, T sender, int majority) {
        if (this.requests == null) {
            return false;
        }
        boolean added = false;
        for (long i = this.requests.getHeadSequence(); i <= Math.min((long)index, this.requests.getTailSequence() - 1L); ++i) {
            Entry<T> entry = this.requests.get(i);
            if (entry == null) continue;
            boolean entryAdded = entry.add(sender, majority);
            if (i != (long)index || !entryAdded) continue;
            added = true;
        }
        return added;
    }

    public boolean isCommitted(int index) {
        if (this.requests == null) {
            return false;
        }
        if ((long)index < this.requests.getHeadSequence()) {
            return true;
        }
        Entry<T> entry = this.requests.contains(index) ? this.requests.get(index) : null;
        return entry != null && entry.committed;
    }

    public int size() {
        if (this.requests == null) {
            return 0;
        }
        return this.requests.size();
    }

    public void notifyAndRemove(int index, byte[] response) {
        if (this.requests == null) {
            return;
        }
        Entry<T> entry = this.requests.remove(index);
        if (entry != null && entry.client_future != null) {
            entry.client_future.complete(response);
        }
    }

    public String toString() {
        if (this.requests == null || this.requests.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        this.requests.forEach((entry, index) -> sb.append(index).append(": ").append(entry).append("\n"));
        return sb.toString();
    }

    protected static class Entry<T> {
        protected final CompletableFuture<byte[]> client_future;
        protected final Set<T> votes = new HashSet<T>();
        protected boolean committed;

        public Entry(CompletableFuture<byte[]> client_future) {
            this.client_future = client_future;
        }

        protected boolean add(T vote, int majority) {
            return this.votes.add(vote) && this.votes.size() >= majority && this.commit();
        }

        protected boolean commit() {
            boolean prev_committed = this.committed;
            this.committed = true;
            return !prev_committed;
        }

        public String toString() {
            return "committed=" + this.committed + ", votes=" + this.votes;
        }
    }
}

