/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.raft;

import java.util.List;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.protocols.raft.election.BaseElection;
import org.jgroups.raft.util.Utils;

@MBean(description="Protocol performing leader election according to the RAFT paper")
public class ELECTION
extends BaseElection {
    protected static final short ELECTION_ID = 520;

    @Override
    protected void handleView(View v) {
        View previousView = this.view;
        this.view = v;
        Utils.Majority result = Utils.computeMajority(previousView, v, this.raft().majority(), this.raft.leader());
        this.log.debug("%s: existing view: %s, new view: %s, result: %s", new Object[]{this.local_addr, previousView, v, result});
        List joiners = View.newMembers((View)previousView, (View)v);
        boolean has_new_members = joiners != null && !joiners.isEmpty();
        boolean coordinatorChanged = Utils.viewCoordinatorChanged(previousView, v);
        switch (result) {
            case no_change: {
                if (this.raft.isLeader() && has_new_members) {
                    this.sendLeaderElectedMessage(this.raft.leader(), this.raft.currentTerm());
                    break;
                }
                if (!coordinatorChanged || !this.isViewCoordinator() || !this.isMajorityAvailable() || this.raft.leader() != null) break;
                this.startVotingThread();
                break;
            }
            case reached: 
            case leader_lost: {
                if (!this.isViewCoordinator()) break;
                this.log.trace("%s: starting voting process (reason: %s, view: %s)", new Object[]{this.local_addr, result, this.view});
                this.startVotingThread();
                break;
            }
            case lost: {
                this.stopVotingThread();
                this.raft.setLeaderAndTerm(null);
            }
        }
    }

    static {
        ClassConfigurator.addProtocol((short)520, ELECTION.class);
    }
}

