/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.raft.election;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.Supplier;
import org.jgroups.Address;
import org.jgroups.Header;
import org.jgroups.protocols.raft.RaftHeader;
import org.jgroups.util.Util;

public class LeaderElected
extends RaftHeader {
    protected Address leader;

    public LeaderElected() {
    }

    public LeaderElected(Address leader) {
        this.leader = leader;
    }

    public Address leader() {
        return this.leader;
    }

    public short getMagicId() {
        return 3005;
    }

    public Supplier<? extends Header> create() {
        return LeaderElected::new;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + Util.size((Address)this.leader);
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        Util.writeAddress((Address)this.leader, (DataOutput)out);
    }

    @Override
    public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
        super.readFrom(in);
        this.leader = Util.readAddress((DataInput)in);
    }

    @Override
    public String toString() {
        return super.toString() + ", leader=" + String.valueOf(this.leader);
    }
}

