/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.raft.client;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.protocols.raft.CLIENT;
import org.jgroups.raft.Options;
import org.jgroups.raft.Settable;
import org.jgroups.util.DefaultThreadFactory;
import org.jgroups.util.Runner;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.Util;

public class ClientStub
implements Settable,
Closeable {
    protected InetAddress host;
    protected int port = 1965;
    protected Socket sock;
    protected DataInputStream in;
    protected DataOutputStream out;
    protected int current_request_id = 1;
    protected final Map<Integer, CompletableFuture<byte[]>> requests = new ConcurrentHashMap<Integer, CompletableFuture<byte[]>>();
    protected Runner runner;
    protected final Log log = LogFactory.getLog(ClientStub.class);

    public ClientStub(InetAddress host, int port) {
        this.host = host;
        this.port = port;
    }

    public InetAddress getHost() {
        return this.host;
    }

    public ClientStub setHost(InetAddress h) {
        this.host = h;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public ClientStub setPort(int p) {
        this.port = p;
        return this;
    }

    public ClientStub start() throws Exception {
        if (this.sock != null && this.sock.isConnected() && this.runner != null && this.runner.isRunning()) {
            return this;
        }
        if (this.host == null) {
            this.host = InetAddress.getLocalHost();
        }
        this.sock = new Socket(this.host, this.port);
        this.in = new DataInputStream(this.sock.getInputStream());
        this.out = new DataOutputStream(this.sock.getOutputStream());
        this.runner = new Runner((ThreadFactory)new DefaultThreadFactory("clientstub", true, true), "client-stub-reader", this::readResponse, null).start();
        return this;
    }

    public ClientStub stop() {
        Util.close((Closeable[])new Closeable[]{this.runner, this.sock, this.in, this.out});
        this.requests.values().forEach(cf -> cf.completeExceptionally(new IllegalStateException("server socket closed")));
        return this;
    }

    @Override
    public void close() {
        this.stop();
    }

    @Override
    public CompletableFuture<byte[]> setAsync(byte[] buf, int offset, int length, Options ignored) throws Exception {
        return this.setAsync(CLIENT.RequestType.set_req, buf, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<byte[]> setAsync(CLIENT.RequestType type, byte[] buf, int offset, int length) throws Exception {
        int req_id;
        CompletableFuture<byte[]> req = new CompletableFuture<byte[]>();
        ClientStub clientStub = this;
        synchronized (clientStub) {
            req_id = this.current_request_id++;
        }
        this.requests.put(req_id, req);
        this.out.writeByte((byte)type.ordinal());
        this.out.writeInt(req_id);
        this.out.writeInt(buf.length);
        this.out.write(buf, offset, length);
        return req;
    }

    protected void readResponse() {
        block10: {
            CompletableFuture<byte[]> cf = null;
            try {
                int len;
                CLIENT.RequestType type = CLIENT.RequestType.values()[this.in.readByte()];
                if (type != CLIENT.RequestType.rsp) {
                    throw new IllegalStateException(String.format("expected type %s but got %s", new Object[]{CLIENT.RequestType.rsp, type}));
                }
                int req_id = this.in.readInt();
                cf = this.requests.get(req_id);
                if (cf == null) {
                    this.log.warn("request with id=%d not found", new Object[]{req_id});
                }
                if ((len = this.in.readInt()) == 0) {
                    if (cf != null) {
                        cf.complete(null);
                    }
                    return;
                }
                byte[] buf = new byte[len];
                this.in.readFully(buf);
                if (cf != null) {
                    cf.complete(buf);
                }
            }
            catch (EOFException e) {
                this.log.warn("EOF reading socket, stopping reader");
                if (cf != null) {
                    cf.completeExceptionally(e);
                }
                this.close();
            }
            catch (Throwable t) {
                this.log.error("failed reading response", t);
                if (cf == null) break block10;
                cf.completeExceptionally(t);
            }
        }
        if (this.sock.isClosed()) {
            this.log.warn("Socket is closed, stopping reader");
            this.close();
        }
    }

    public String toString() {
        return String.format("remote: %s:%d%s", this.host, this.port, this.sock != null && this.sock.isConnected() ? " (connected)" : "");
    }
}

