/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.raft.testfwk;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.raft.testfwk.MockRaftCluster;
import org.jgroups.raft.testfwk.RaftNode;

public class RaftCluster
extends MockRaftCluster {
    protected final Map<Address, RaftNode> nodes = new ConcurrentHashMap<Address, RaftNode>();
    protected final Map<Address, RaftNode> dropped_members = new ConcurrentHashMap<Address, RaftNode>();
    private final AtomicBoolean viewChanging = new AtomicBoolean(false);
    private final BlockingQueue<Message> pending = new ArrayBlockingQueue<Message>(16);

    @Override
    public <T extends MockRaftCluster> T add(Address addr, RaftNode node) {
        this.nodes.put(addr, node);
        return this.self();
    }

    @Override
    public <T extends MockRaftCluster> T remove(Address addr) {
        this.nodes.remove(addr);
        return this.self();
    }

    @Override
    public <T extends MockRaftCluster> T clear() {
        this.nodes.clear();
        return this.self();
    }

    public boolean dropTraffic() {
        return !this.dropped_members.isEmpty();
    }

    public RaftCluster dropTrafficTo(Address a) {
        RaftCluster.move(a, this.nodes, this.dropped_members);
        return this;
    }

    public RaftCluster clearDroppedTrafficTo(Address a) {
        RaftCluster.move(a, this.dropped_members, this.nodes);
        return this;
    }

    public RaftCluster clearDroppedTraffic() {
        RaftCluster.moveAll(this.dropped_members, this.nodes);
        return this;
    }

    @Override
    public void handleView(View view) {
        this.viewChanging.set(true);
        try {
            List members = view.getMembers();
            this.nodes.keySet().retainAll(Objects.requireNonNull(members));
            this.nodes.values().forEach(n -> n.handleView(view));
        }
        finally {
            this.viewChanging.set(false);
            this.sendPending();
        }
    }

    @Override
    public void send(Message msg) {
        this.send(msg, this.async);
    }

    @Override
    public int size() {
        return this.nodes.size();
    }

    public void send(Message msg, boolean async) {
        boolean block;
        if (this.viewChanging.get()) {
            this.pending.add(msg);
            return;
        }
        Address dest = msg.dest();
        boolean bl = block = this.interceptor != null && this.interceptor.shouldBlock(msg);
        if (dest != null) {
            if (block) {
                this.interceptor.blockMessage(msg, async, () -> this.sendSingle(this.nodes.get(dest), msg, async));
            } else {
                this.sendSingle(this.nodes.get(dest), msg, async);
            }
        } else if (block) {
            this.interceptor.blockMessage(msg, async, () -> this.sendMany(this.nodes.keySet(), msg, async));
        } else {
            this.sendMany(this.nodes.keySet(), msg, async);
        }
    }

    private void sendSingle(RaftNode node, Message msg, boolean async) {
        if (this.async || async) {
            this.deliverAsync(node, msg);
        } else {
            node.up(msg);
        }
    }

    private void sendMany(Set<Address> targets, Message msg, boolean async) {
        for (Address d : targets) {
            RaftNode n = this.nodes.get(d);
            if (n == null || Objects.equals(d, msg.src()) && msg.isFlagSet(Message.TransientFlag.DONT_LOOPBACK)) continue;
            if (this.async || async) {
                this.deliverAsync(n, msg);
                continue;
            }
            n.up(msg);
        }
    }

    public String toString() {
        return String.format("%d nodes: %s%s", this.nodes.size(), this.nodes.keySet(), this.dropTraffic() ? String.format(" (dropping traffic to %s)", this.dropped_members.keySet()) : "");
    }

    protected static void move(Address key, Map<Address, RaftNode> from, Map<Address, RaftNode> to) {
        RaftNode val = from.remove(key);
        if (val != null) {
            to.putIfAbsent(key, val);
        }
    }

    protected static void moveAll(Map<Address, RaftNode> from, Map<Address, RaftNode> to) {
        for (Map.Entry<Address, RaftNode> e : from.entrySet()) {
            to.putIfAbsent(e.getKey(), e.getValue());
        }
        from.clear();
    }

    private void sendPending() {
        Message msg;
        while ((msg = (Message)this.pending.poll()) != null) {
            this.send(msg);
        }
    }
}

