/*
 * Decompiled with CFR 0.152.
 */
package org.jhades;

import java.net.URL;
import java.util.List;
import org.jhades.model.ClasspathEntry;
import org.jhades.model.ClasspathResource;
import org.jhades.model.ClasspathResourceVersion;
import org.jhades.model.ClazzLoader;
import org.jhades.model.JarPair;
import org.jhades.reports.DuplicatesReport;
import org.jhades.service.ClasspathScanner;

public class JHades {
    private ClasspathScanner scanner = new ClasspathScanner();

    public JHades printClassLoaderNames() {
        System.out.println("\n>> jHades printClassLoaders >> Printing classloader class names (ordered from child to parent):\n");
        List<ClazzLoader> classLoaders = this.scanner.findAllClassLoaders();
        boolean notSupportedFound = false;
        for (ClazzLoader classLoader : classLoaders) {
            if (classLoader.isSupported()) {
                System.out.println(classLoader.getName());
                continue;
            }
            notSupportedFound = true;
            System.out.println(classLoader.getName() + " - NOT SUPORTED");
        }
        this.endCommand(classLoaders.size() > 0);
        if (notSupportedFound) {
            System.out.println("Note: NOT SUPPORTED class loader means that any classes loaded by such a classloader will not be found on any jHades queries. \n");
        }
        return this;
    }

    public JHades dumpClassloaderInfo() {
        System.out.println("\n>> jHades printClassLoaders >> Printing all classloader available info (from the class loader toString(), ordered from child to parent):\n");
        List<ClazzLoader> classLoaders = this.scanner.findAllClassLoaders();
        boolean notSupportedFound = false;
        for (ClazzLoader classLoader : classLoaders) {
            if (classLoader.isSupported()) {
                System.out.println("\n>>> Dumping available info for classloader " + classLoader.getName() + "\n");
                System.out.println(classLoader.getDetails());
                continue;
            }
            notSupportedFound = true;
            System.out.println(classLoader.getName() + " - NOT SUPORTED");
        }
        this.endCommand(classLoaders.size() > 0);
        if (notSupportedFound) {
            System.out.println("Note: NOT SUPPORTED class loader means that any classes loaded by such a classloader will not be found on any jHades queries. \n");
        }
        return this;
    }

    public JHades printClasspath() {
        System.out.println("\n>> jHades printClasspath >> Printing all class folder and jars on the classpath:\n");
        List<ClasspathEntry> classpathEntries = this.scanner.findAllClasspathEntries();
        ClazzLoader clazzLoader = null;
        for (ClasspathEntry entry : classpathEntries) {
            if (entry.getClassLoader() != null && !entry.getClassLoader().equals(clazzLoader)) {
                System.out.println();
                clazzLoader = entry.getClassLoader();
            }
            System.out.println(entry.getClassLoaderName() + " - " + entry.getUrl());
        }
        this.endCommand(classpathEntries.size() > 0);
        return this;
    }

    public JHades findResource(String resource) {
        if (resource == null) {
            throw new IllegalArgumentException("Resource path cannot be null.");
        }
        System.out.println(">> jHades printResourcePath >> searching for " + resource + "\n");
        List<URL> allVersions = this.scanner.findAllResourceVersions(resource);
        boolean resultsFound = allVersions != null && allVersions.size() > 0;
        System.out.println("All versions:\n");
        for (URL version : allVersions) {
            System.out.println(version);
        }
        URL currentVersion = this.scanner.findCurrentResourceVersion(resource);
        if (resultsFound && currentVersion != null) {
            System.out.println("\nCurrent version being used: \n\n" + currentVersion);
        }
        this.endCommand(resultsFound);
        return this;
    }

    public JHades findClassByName(String classFullyQualifiedName) {
        if (classFullyQualifiedName == null) {
            throw new IllegalArgumentException("Class name cannot be null.");
        }
        String resourceName = classFullyQualifiedName.replaceAll("\\.", "/") + ".class";
        return this.findResource(resourceName);
    }

    public JHades findClass(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class name cannot be null.");
        }
        System.out.println(">> jHades searchClass >> Searching for class: " + clazz.getCanonicalName() + "\n");
        ClasspathResource foundClass = this.scanner.findClass(clazz);
        for (ClasspathResourceVersion version : foundClass.getResourceFileVersions()) {
            System.out.println(version.getClasspathEntry().getUrl() + foundClass.getName() + " size = " + version.getFileSize());
        }
        this.endCommand(foundClass != null);
        return this;
    }

    public JHades findByRegex(String search) {
        boolean resultsFound;
        if (search == null || search.isEmpty()) {
            throw new IllegalArgumentException("search string cannot be null or empty.");
        }
        System.out.println(">> jHades search >> Searching for resorce using search string: " + search + "\n");
        List<ClasspathResource> classpathResources = this.scanner.findByRegex(search);
        boolean bl = resultsFound = classpathResources != null && classpathResources.size() > 0;
        if (resultsFound) {
            System.out.println("\nResults Found:\n");
            for (ClasspathResource classpathResource : classpathResources) {
                System.out.println(classpathResource.getName());
            }
        }
        this.endCommand(resultsFound);
        return this;
    }

    public JHades multipleClassVersionsReport() {
        this.multipleClassVersionsReport(true);
        return this;
    }

    public JHades multipleClassVersionsReport(boolean excludeSameSizeDups) {
        List<ClasspathResource> resourcesWithDuplicates = this.scanner.findAllResourcesWithDuplicates(excludeSameSizeDups);
        DuplicatesReport report = new DuplicatesReport(resourcesWithDuplicates);
        report.print();
        return this;
    }

    public JHades overlappingJarsReport() {
        System.out.println("\n>> jHades - scanning classpath for overlapping jars: \n");
        List<JarPair> jarOverlapReportLines = this.scanner.findOverlappingJars();
        for (JarPair jarOverlapReportLine : jarOverlapReportLines) {
            String reportLine = jarOverlapReportLine.getJar1().getUrl() + " overlaps with \n" + jarOverlapReportLine.getJar2().getUrl() + " - total overlapping classes: " + jarOverlapReportLine.getDupClassesTotal() + " - ";
            reportLine = jarOverlapReportLine.getJar1().getClassLoader().equals(jarOverlapReportLine.getJar2().getClassLoader()) ? reportLine + "same classloader ! This is an ERROR!\n" : reportLine + "different classloaders.\n";
            System.out.println(reportLine);
        }
        this.endCommand(jarOverlapReportLines.size() > 0);
        return this;
    }

    private void endCommand(boolean resultsFound) {
        if (!resultsFound) {
            System.out.println("No results found.\n");
        } else {
            System.out.println("");
        }
    }
}

