/*
 * Decompiled with CFR 0.152.
 */
package org.jhades.model;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jhades.model.ClasspathEntry;
import org.jhades.model.ClasspathResource;
import org.jhades.model.ClasspathResourceVersion;
import org.jhades.service.ClasspathScannerListener;
import org.jhades.utils.StdOutLogger;

public final class ClasspathEntries {
    private ClasspathEntries() {
        throw new UnsupportedOperationException("Utility classes cannot be instantiated.");
    }

    public static List<ClasspathResource> findClasspathResourcesInEntries(List<ClasspathEntry> classpathEntries, StdOutLogger logger, ClasspathScannerListener listener) {
        ArrayList<ClasspathResourceVersion> allResourceVersions = new ArrayList<ClasspathResourceVersion>();
        HashMap<String, ClasspathResource> resourcesPerNameMap = new HashMap<String, ClasspathResource>();
        try {
            for (ClasspathEntry entry : classpathEntries) {
                if (listener != null) {
                    listener.onEntryScanStart(entry);
                }
                allResourceVersions.addAll(entry.getResourceVersions());
                if (listener == null) continue;
                listener.onEntryScanEnd(entry);
            }
            for (ClasspathResourceVersion resourceVersion : allResourceVersions) {
                String resourceName = resourceVersion.getResourceName();
                if (!resourcesPerNameMap.containsKey(resourceName)) {
                    resourcesPerNameMap.put(resourceName, new ClasspathResource(resourceName, resourceVersion));
                    continue;
                }
                ((ClasspathResource)resourcesPerNameMap.get(resourceName)).getResourceFileVersions().add(resourceVersion);
            }
        }
        catch (IOException | URISyntaxException ex) {
            logger.error(ex.getMessage(), ex);
        }
        return new ArrayList<ClasspathResource>(resourcesPerNameMap.values());
    }
}

