/*
 * Decompiled with CFR 0.152.
 */
package org.jhades.model;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.jhades.model.ClasspathResourceVersion;
import org.jhades.model.ClazzLoader;
import org.jhades.utils.StdOutLogger;

public class ClasspathEntry {
    private static final StdOutLogger logger = StdOutLogger.getLogger();
    private final ClazzLoader classLoader;
    private final String url;
    private List<ClasspathResourceVersion> resourceVersions = new ArrayList<ClasspathResourceVersion>();
    private boolean lazyLoadDone = false;

    public ClasspathEntry(ClazzLoader classLoader, String url) {
        this.classLoader = classLoader;
        this.url = url;
    }

    public ClazzLoader getClassLoader() {
        return this.classLoader;
    }

    public String getUrl() {
        return this.url;
    }

    public int hashCode() {
        int hash = 3;
        hash = 89 * hash + Objects.hashCode(this.url);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClasspathEntry other = (ClasspathEntry)obj;
        return Objects.equals(this.url, other.url);
    }

    public String toString() {
        return "classLoader=" + this.classLoader + ", path=" + this.url;
    }

    public boolean isJar() {
        return this.url != null && this.url.endsWith(".jar");
    }

    public boolean isClassFolder() {
        return this.url != null && this.url.endsWith("/");
    }

    public String getClassLoaderName() {
        return this.classLoader != null ? this.classLoader.getName() : null;
    }

    public List<ClasspathResourceVersion> getResourceVersions() throws URISyntaxException, IOException {
        if (!this.lazyLoadDone) {
            if (this.isClassFolder()) {
                logger.debug("\nScanning class folder: " + this.getUrl());
                URI uri = new URI(this.getUrl());
                Path start = Paths.get(uri);
                this.scanClasspathEntry(start);
            } else if (this.isJar()) {
                logger.debug("\nScanning jar: " + this.getUrl());
                URI uri = new URI("jar:" + this.getUrl());
                try (FileSystem jarFS = FileSystems.newFileSystem(uri, new HashMap());){
                    Path zipInJarPath = jarFS.getPath("/", new String[0]);
                    this.scanClasspathEntry(zipInJarPath);
                }
                catch (Exception exc) {
                    logger.debug("Could not scan jar: " + this.getUrl() + " - reason:" + exc.getMessage());
                }
            }
            this.lazyLoadDone = true;
        }
        return this.resourceVersions;
    }

    public List<ClasspathEntry> findManifestClasspathEntries() {
        ArrayList<ClasspathEntry> manifestClasspathEntries = new ArrayList<ClasspathEntry>();
        if (this.isJar()) {
            try {
                String[] jarPaths;
                String manifestClasspath;
                Attributes attrs;
                JarInputStream jarStream = new JarInputStream(new URL(this.getUrl()).openStream());
                Manifest manifest = jarStream.getManifest();
                if (manifest != null && (attrs = manifest.getMainAttributes()) != null && (manifestClasspath = attrs.getValue("Class-Path")) != null && (jarPaths = manifestClasspath.split(" ")) != null) {
                    for (String jarPath : jarPaths) {
                        logger.debug("Manifest jar path: " + jarPath);
                        manifestClasspathEntries.add(new ClasspathEntry(this.classLoader, jarPath));
                    }
                }
            }
            catch (IOException ex) {
                logger.warn("Problem scanning Manifest classpath: " + ex.getMessage());
            }
        }
        return manifestClasspathEntries;
    }

    private List<ClasspathResourceVersion> scanClasspathEntry(Path start) throws IOException {
        Files.walkFileTree(start, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path classpathResourceFile, BasicFileAttributes attrs) throws IOException {
                String resourceName = classpathResourceFile.toString();
                logger.debug(ClasspathEntry.this.getUrl() + " -" + resourceName);
                ClasspathResourceVersion classFileVersion = new ClasspathResourceVersion(ClasspathEntry.this, resourceName, attrs.size());
                ClasspathEntry.this.resourceVersions.add(classFileVersion);
                return FileVisitResult.CONTINUE;
            }
        });
        return this.resourceVersions;
    }
}

