/*
 * Decompiled with CFR 0.152.
 */
package org.jhades.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jhades.model.ClasspathResourceVersion;

public class ClasspathResource {
    private final String name;
    private final List<ClasspathResourceVersion> resourceFileVersions = new ArrayList<ClasspathResourceVersion>();

    public ClasspathResource(String name, ClasspathResourceVersion resourceFileVersion) {
        this.name = name;
        this.resourceFileVersions.add(resourceFileVersion);
    }

    public String getName() {
        return this.name;
    }

    public List<ClasspathResourceVersion> getResourceFileVersions() {
        return this.resourceFileVersions;
    }

    public int getNumberOfVersions() {
        return this.resourceFileVersions.size();
    }

    public int hashCode() {
        int hash = 5;
        hash = 29 * hash + Objects.hashCode(this.name);
        hash = 29 * hash + Objects.hashCode(this.resourceFileVersions);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClasspathResource other = (ClasspathResource)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        return Objects.equals(this.resourceFileVersions, other.resourceFileVersions);
    }

    public String toString() {
        return "Clazz{name=" + this.name + ", classFileVersions=" + this.resourceFileVersions + '}';
    }

    public boolean hasDuplicates(boolean excludeSameSizeDups) {
        boolean hasDuplicates = false;
        if (!excludeSameSizeDups) {
            hasDuplicates = this.resourceFileVersions.size() > 1;
        } else if (this.resourceFileVersions.size() > 1) {
            boolean multipleSizesExist = false;
            long size = this.resourceFileVersions.get(0).getFileSize();
            for (ClasspathResourceVersion resourceFileVersion : this.resourceFileVersions) {
                if (resourceFileVersion.getFileSize() == size) continue;
                multipleSizesExist = true;
                break;
            }
            hasDuplicates = multipleSizesExist;
        }
        return hasDuplicates;
    }
}

