/*
 * Decompiled with CFR 0.152.
 */
package org.jhades.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jhades.model.ClasspathResource;

public final class ClasspathResources {
    private ClasspathResources() {
        throw new UnsupportedOperationException("Utility classes cannot be instantiated.");
    }

    public static final List<ClasspathResource> filterClassFilesOnly(List<ClasspathResource> classpathResources) {
        if (classpathResources == null) {
            throw new IllegalArgumentException("Classpath resources cannot be null.");
        }
        ArrayList<ClasspathResource> filtered = new ArrayList<ClasspathResource>();
        for (ClasspathResource classpathResource : classpathResources) {
            String resourceName = classpathResource.getName();
            if (resourceName == null || !resourceName.endsWith(".class")) continue;
            filtered.add(classpathResource);
        }
        return filtered;
    }

    public static void sortByNumberOfVersionsDesc(List<ClasspathResource> resources) {
        Comparator<ClasspathResource> sortByNumberOfVersionsDesc = new Comparator<ClasspathResource>(){

            @Override
            public int compare(ClasspathResource resource1, ClasspathResource resource2) {
                return -1 * new Integer(resource1.getResourceFileVersions().size()).compareTo(resource2.getResourceFileVersions().size());
            }
        };
        Collections.sort(resources, sortByNumberOfVersionsDesc);
    }

    public static List<ClasspathResource> findResourcesWithDuplicates(List<ClasspathResource> resourceFiles, boolean excludeSameSizeDups) {
        ArrayList<ClasspathResource> resourcesWithDuplicates = new ArrayList<ClasspathResource>();
        for (ClasspathResource resource : resourceFiles) {
            if (!resource.hasDuplicates(excludeSameSizeDups)) continue;
            resourcesWithDuplicates.add(resource);
        }
        return resourcesWithDuplicates;
    }
}

