/*
 * Decompiled with CFR 0.152.
 */
package org.jhades.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jhades.model.ClasspathEntry;

public abstract class ClazzLoader {
    private String name;
    private String details;
    private boolean isSupported;
    private List<ClasspathEntry> classpathEntries = new ArrayList<ClasspathEntry>();

    public ClazzLoader(String name, String details, boolean isSupported) {
        this.name = name;
        this.details = details;
        this.isSupported = isSupported;
    }

    public String getName() {
        return this.name;
    }

    public String getDetails() {
        return this.details;
    }

    public boolean isSupported() {
        return this.isSupported;
    }

    public List<ClasspathEntry> getClasspathEntries() {
        return new ArrayList<ClasspathEntry>(this.classpathEntries);
    }

    protected void addClasspathEntry(ClasspathEntry newEntry) {
        this.classpathEntries.add(newEntry);
        if (newEntry.isJar()) {
            List<ClasspathEntry> manifestClasspath = newEntry.findManifestClasspathEntries();
            for (ClasspathEntry manifestEntry : manifestClasspath) {
                this.addClasspathEntry(manifestEntry);
            }
        }
    }

    public int hashCode() {
        int hash = 5;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClazzLoader other = (ClazzLoader)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.details, other.details)) {
            return false;
        }
        return this.isSupported == other.isSupported;
    }
}

