/*
 * Decompiled with CFR 0.152.
 */
package org.jhades.service;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jhades.model.ClasspathEntries;
import org.jhades.model.ClasspathEntry;
import org.jhades.model.ClasspathResource;
import org.jhades.model.ClasspathResourceVersion;
import org.jhades.model.ClasspathResources;
import org.jhades.model.ClazzLoader;
import org.jhades.model.ClazzLoaderFactory;
import org.jhades.model.ClazzLoaders;
import org.jhades.model.JarPair;
import org.jhades.utils.StdOutLogger;

public class ClasspathScanner {
    public static final String BOOTSTRAP_CLASS_LOADER = "Bootstrap class loader";
    private StdOutLogger logger = StdOutLogger.getLogger();

    public List<ClasspathEntry> findAllClasspathEntries() {
        List<ClazzLoader> classLoaders = this.findAllClassLoaders(this.getClass().getClassLoader());
        List<ClasspathEntry> allClasspathEntries = ClazzLoaders.findAllClasspathEntries(classLoaders);
        String classpath = System.getProperty("java.class.path");
        String separator = System.getProperty("path.separator");
        if (classpath != null && separator != null) {
            String[] paths;
            for (String pathEntry : paths = classpath.split(separator)) {
                boolean found = false;
                for (ClasspathEntry classpathEntry : allClasspathEntries) {
                    if (!classpathEntry.getUrl().contains(pathEntry)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                if (!pathEntry.endsWith("/")) {
                    pathEntry = pathEntry + "/";
                }
                this.logger.warn("This entry on the classpath system property java.class.path was not found on any classloader:" + pathEntry);
            }
        } else {
            this.logger.warn("could not parse classpath.");
        }
        return allClasspathEntries;
    }

    public List<ClasspathResource> findAllClasspathResources() {
        List<ClasspathEntry> classpathEntries = this.findAllClasspathEntries();
        return ClasspathEntries.findClasspathResourcesInEntries(classpathEntries, this.logger, null);
    }

    public List<ClazzLoader> findAllClassLoaders() {
        return this.findAllClassLoaders(this.getClass().getClassLoader());
    }

    public List<URL> findAllResourceVersions(String resourceUrl) {
        ClassLoader cl = this.getClass().getClassLoader();
        ArrayList<URL> results = new ArrayList<URL>();
        try {
            Enumeration<URL> urls = cl.getResources(resourceUrl);
            while (urls.hasMoreElements()) {
                results.add(urls.nextElement());
            }
        }
        catch (IOException exception) {
            System.out.println("Could not find the versions of classpath resource: " + resourceUrl);
            exception.printStackTrace();
        }
        return results;
    }

    public URL findCurrentResourceVersion(String resourceUrl) {
        ClassLoader cl = this.getClass().getClassLoader();
        return cl.getResource(resourceUrl);
    }

    public ClasspathResource findClass(Class clazz) {
        String classResourceName = clazz.getName().replace(".", "/") + ".class";
        List<ClasspathResource> allResources = this.findAllClasspathResources();
        ClasspathResource foundResource = null;
        for (ClasspathResource resource : allResources) {
            if (resource == null || resource.getName() == null || !resource.getName().endsWith(classResourceName)) continue;
            foundResource = resource;
            break;
        }
        return foundResource;
    }

    public List<ClasspathResource> findByRegex(String search) {
        List<ClasspathResource> allResources = this.findAllClasspathResources();
        ArrayList<ClasspathResource> matches = new ArrayList<ClasspathResource>();
        Pattern pattern = Pattern.compile(search);
        for (ClasspathResource resource : allResources) {
            if (resource == null || resource.getName() == null || !pattern.matcher(resource.getName()).find()) continue;
            matches.add(resource);
        }
        return matches;
    }

    public List<ClasspathResource> findAllResourcesWithDuplicates(boolean excludeSameSizeDups) {
        List<ClasspathResource> resourceFiles = this.findAllClasspathResources();
        return ClasspathResources.findResourcesWithDuplicates(resourceFiles, excludeSameSizeDups);
    }

    private List<ClazzLoader> findAllClassLoaders(ClassLoader classLoader) {
        ArrayList<ClazzLoader> classLoaders = new ArrayList<ClazzLoader>();
        if (classLoader != null) {
            ClazzLoader cl = ClazzLoaderFactory.createClazzLoader(classLoader);
            if (cl != null) {
                classLoaders.add(cl);
            }
            classLoaders.addAll(this.findAllClassLoaders(classLoader.getParent()));
        } else {
            classLoaders.add(ClazzLoaderFactory.createBootstrapClassLoader());
        }
        return classLoaders;
    }

    public List<ClasspathResource> findClassFileDuplicates(List<ClasspathResource> classpathResources, boolean excludeSameSizeDups) {
        List<ClasspathResource> classFilesWithDuplicates = ClasspathResources.findResourcesWithDuplicates(classpathResources, excludeSameSizeDups);
        return ClasspathResources.filterClassFilesOnly(classFilesWithDuplicates);
    }

    public List<JarPair> findOverlappingJars() {
        return this.findOverlappingJars(this.findAllClasspathResources(), false);
    }

    public List<JarPair> findOverlappingJars(boolean excludeSameSizeDups) {
        return this.findOverlappingJars(this.findAllClasspathResources(), excludeSameSizeDups);
    }

    public List<JarPair> findOverlappingJars(List<ClasspathResource> classpathResources, boolean excludeSameSizeDups) {
        List<ClasspathResource> classFilesWithDuplicates = this.findClassFileDuplicates(classpathResources, excludeSameSizeDups);
        HashMap<JarPair, JarPair> overlapPairs = new HashMap<JarPair, JarPair>();
        for (ClasspathResource classFile : classFilesWithDuplicates) {
            List<ClasspathResourceVersion> versions = classFile.getResourceFileVersions();
            this.findOverlappingJarsPairs(versions, overlapPairs, 0);
        }
        ArrayList<JarPair> overlapReportLines = new ArrayList<JarPair>(overlapPairs.keySet());
        Comparator<JarPair> comparator = new Comparator<JarPair>(){

            @Override
            public int compare(JarPair line1, JarPair line2) {
                return -1 * line1.getDupClassesTotal().compareTo(line2.getDupClassesTotal());
            }
        };
        Collections.sort(overlapReportLines, comparator);
        return overlapReportLines;
    }

    private void findOverlappingJarsPairs(List<ClasspathResourceVersion> versions, Map<JarPair, JarPair> overlapPairs, int anchorIndex) {
        ClasspathResourceVersion anchor = versions.get(anchorIndex);
        for (int i = anchorIndex + 1; i < versions.size(); ++i) {
            JarPair overlapPair = new JarPair(anchor.getClasspathEntry(), versions.get(i).getClasspathEntry());
            if (!overlapPairs.containsKey(overlapPair)) {
                overlapPairs.put(overlapPair, overlapPair);
            }
            overlapPairs.get(overlapPair).incrementDupClassesTotal();
        }
        if (anchorIndex + 1 < versions.size()) {
            this.findOverlappingJarsPairs(versions, overlapPairs, anchorIndex + 1);
        }
    }
}

