/*
 * Decompiled with CFR 0.152.
 */
package org.jhades.utils;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.jhades.utils.StdOutLogger;

public final class FileUtils {
    private static final StdOutLogger logger = StdOutLogger.getLogger();

    private FileUtils() {
        throw new UnsupportedOperationException("Utility classes cannot be instantiated.");
    }

    public static void deleteDirectory(String directory) {
        logger.debug("Deleting directory: " + directory);
        Path dir = Paths.get(directory, new String[0]);
        try {
            Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    logger.debug("Deleting dir: " + dir);
                    if (exc == null) {
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }
                    throw exc;
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

